/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.block;

import baguchi.tofucraft.block.TofuBlock;
import baguchi.tofucraft.registry.TofuTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.Nullable;

public class KinuTofuBlock
extends Block {
    public KinuTofuBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        super.animateTick(stateIn, worldIn, pos, rand);
        if (this.isUnderWeight(worldIn, pos) && rand.nextInt(4) == 0) {
            double d4 = rand.nextBoolean() ? 0.8 : -0.8;
            double d0 = (double)pos.getX() + 0.5 + (double)rand.nextFloat() * d4;
            double d1 = (float)pos.getY() + rand.nextFloat();
            double d2 = (double)pos.getZ() + 0.5 + (double)rand.nextFloat() * d4;
            worldIn.addParticle((ParticleOptions)ParticleTypes.DRIPPING_WATER, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public void fallOn(Level p_152426_, BlockState p_152427_, BlockPos p_152428_, Entity p_152429_, double p_397222_) {
        super.fallOn(p_152426_, p_152427_, p_152428_, p_152429_, p_397222_ * 0.25);
        if (p_397222_ > 0.5 && !p_152429_.getType().is(TofuTags.EntityTypes.WALKABLE_WITHOUT_TRIGGER)) {
            p_152426_.destroyBlock(p_152428_, true);
        }
    }

    public void randomTick(BlockState p_225542_1_, ServerLevel p_225542_2_, BlockPos p_225542_3_, RandomSource p_225542_4_) {
        super.randomTick(p_225542_1_, p_225542_2_, p_225542_3_, p_225542_4_);
        if (this.isUnderWeight((Level)p_225542_2_, p_225542_3_)) {
            p_225542_2_.destroyBlock(p_225542_3_, true);
        }
    }

    public boolean isUnderWeight(Level world, BlockPos pos) {
        BlockState weightBlock = world.getBlockState(pos.above());
        BlockState baseBlock = world.getBlockState(pos.below());
        float weightHardness = weightBlock.getDestroySpeed((BlockGetter)world, pos.above());
        boolean isWeightValid = weightBlock.isFaceSturdy((BlockGetter)world, pos, Direction.DOWN) && (weightHardness >= 1.0f || weightHardness < 0.0f) && !(weightBlock.getBlock() instanceof TofuBlock);
        float baseHardness = baseBlock.getDestroySpeed((BlockGetter)world, pos.below());
        boolean isBaseValid = baseBlock.isFaceSturdy((BlockGetter)world, pos, Direction.UP) && (baseHardness >= 1.0f || baseHardness < 0.0f) && !(baseBlock.getBlock() instanceof TofuBlock);
        return isWeightValid && isBaseValid;
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return PathType.DAMAGE_OTHER;
    }

    @Nullable
    public PathType getAdjacentBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, PathType originalType) {
        return PathType.DANGER_OTHER;
    }
}

