/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class ParticleStink
extends SingleQuadParticle {
    private final float scale;
    private final float shake;

    public ParticleStink(ClientLevel level, double x, double y, double z, double vx, double vy, double vz, double scale, int duration, double shake, TextureAtlasSprite sprite) {
        super(level, x, y, z, sprite);
        this.scale = (float)scale * 0.8f * 0.1f;
        this.lifetime = duration;
        this.xd = vx * 0.8;
        this.yd = vy * 0.8;
        this.zd = vz * 0.8;
        this.roll = this.oRoll = (float)((double)this.random.nextInt(4) * Math.PI / 2.0);
        this.shake = (float)shake;
    }

    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.OPAQUE;
    }

    public void tick() {
        super.tick();
        this.xd *= (double)this.shake;
        this.yd *= (double)this.shake;
        this.zd *= (double)this.shake;
        float time = (float)this.age / (float)this.lifetime;
        this.alpha = Mth.clamp((float)(1.0f - time), (float)0.1f, (float)1.0f);
    }

    public float getQuadSize(float tick) {
        float time = ((float)this.age + tick) / (float)this.lifetime;
        return this.scale * (1.25f * time + 0.3f);
    }

    public static final class StinkFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public StinkFactory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(SimpleParticleType p_446632_, ClientLevel p_107095_, double x, double y, double z, double motionX, double motionY, double motionZ, RandomSource random) {
            return new ParticleStink(p_107095_, x, y, z, motionX, motionY, motionZ, 10.0, 80, 1.2f, this.sprite.get(random));
        }
    }
}

