/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class ParticleZundaCloud
extends SingleQuadParticle {
    private final float scale;
    private final float shake;

    public ParticleZundaCloud(ClientLevel level, double x, double y, double z, double vx, double vy, double vz, double scale, int duration, double shake, TextureAtlasSprite textureAtlasSprite) {
        super(level, x, y, z, textureAtlasSprite);
        this.scale = (float)scale * 0.4f * 0.1f;
        this.lifetime = duration;
        this.xd = vx * 0.8;
        this.yd = vy * 0.8;
        this.zd = vz * 0.8;
        this.roll = this.oRoll = (float)((double)this.random.nextInt(4) * Math.PI / 2.0);
        this.shake = (float)shake;
    }

    public void tick() {
        super.tick();
        this.xd *= (double)this.shake;
        this.yd *= (double)this.shake;
        this.zd *= (double)this.shake;
        float time = (float)this.age / (float)this.lifetime;
        this.alpha = Mth.clamp((float)(1.0f - time), (float)0.1f, (float)1.0f);
    }

    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.OPAQUE;
    }

    public float getQuadSize(float tick) {
        float time = ((float)this.age + tick) / (float)this.lifetime;
        return this.scale * (1.25f * time + 0.3f);
    }

    public static final class CloudFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public CloudFactory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource randomSource) {
            ParticleZundaCloud particleCloud = new ParticleZundaCloud(level, x, y, z, xSpeed, ySpeed, zSpeed, 3.0, 20, 1.1f, this.sprite.get(randomSource));
            return particleCloud;
        }
    }
}

