/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.client.render.blockentity;

import baguchi.tofucraft.block.utils.TofuBedBlock;
import baguchi.tofucraft.blockentity.TofuBedBlockEntity;
import baguchi.tofucraft.registry.TofuBlockEntitys;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.renderer.blockentity.state.BedRenderState;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class TofuBedRenderer
implements BlockEntityRenderer<TofuBedBlockEntity, BedRenderState> {
    public static final ResourceLocation BED_TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"textures/entity/bed/tofubed.png");
    private final Model.Simple headModel;
    private final Model.Simple footModel;

    public TofuBedRenderer(BlockEntityRendererProvider.Context context) {
        this.headModel = new Model.Simple(context.bakeLayer(ModelLayers.BED_HEAD), RenderType::entitySolid);
        this.footModel = new Model.Simple(context.bakeLayer(ModelLayers.BED_FOOT), RenderType::entitySolid);
    }

    private void renderPiece(PoseStack p_173542_, MultiBufferSource p_173543_, ModelPart p_173544_, Direction p_173545_, int p_173547_, int p_173548_, boolean p_173549_) {
        p_173542_.pushPose();
        p_173542_.translate(0.0, 0.5625, p_173549_ ? -1.0 : 0.0);
        p_173542_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        p_173542_.translate(0.5, 0.5, 0.5);
        p_173542_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f + p_173545_.toYRot()));
        p_173542_.translate(-0.5, -0.5, -0.5);
        VertexConsumer var9 = p_173543_.getBuffer(RenderType.entitySolid((ResourceLocation)BED_TEXTURES));
        p_173544_.render(p_173542_, var9, p_173547_, p_173548_);
        p_173542_.popPose();
    }

    public BedRenderState createRenderState() {
        return new BedRenderState();
    }

    public void extractRenderState(TofuBedBlockEntity p_445886_, BedRenderState p_447090_, float p_446336_, Vec3 p_445891_, @Nullable ModelFeatureRenderer.CrumblingOverlay p_446152_) {
        BlockEntityRenderState.extractBase((BlockEntity)p_445886_, (BlockEntityRenderState)p_447090_, (ModelFeatureRenderer.CrumblingOverlay)p_446152_);
        p_447090_.facing = (Direction)p_445886_.getBlockState().getValue((Property)BedBlock.FACING);
        boolean bl = p_447090_.isHead = p_445886_.getBlockState().getValue((Property)BedBlock.PART) == BedPart.HEAD;
        if (p_445886_.getLevel() != null) {
            DoubleBlockCombiner.NeighborCombineResult neighborcombineresult = DoubleBlockCombiner.combineWithNeigbour((BlockEntityType)((BlockEntityType)TofuBlockEntitys.TOFUBED.get()), TofuBedBlock::getBlockType, BedBlock::getConnectedDirection, (Property)ChestBlock.FACING, (BlockState)p_445886_.getBlockState(), (LevelAccessor)p_445886_.getLevel(), (BlockPos)p_445886_.getBlockPos(), (p_112202_, p_112203_) -> false);
            p_447090_.lightCoords = ((Int2IntFunction)neighborcombineresult.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).get(p_447090_.lightCoords);
        }
    }

    public void submit(BedRenderState p_445609_, PoseStack p_439782_, SubmitNodeCollector p_439369_, CameraRenderState p_451216_) {
        Material material = Sheets.getBedMaterial((DyeColor)p_445609_.color);
        this.submitPiece(p_439782_, p_439369_, p_445609_.isHead ? this.headModel : this.footModel, p_445609_.facing, material, p_445609_.lightCoords, OverlayTexture.NO_OVERLAY, false, p_445609_.breakProgress);
    }

    public void submitSpecial(PoseStack p_439640_, SubmitNodeCollector p_439587_, int p_439564_, int p_440267_, Material p_440126_) {
        this.submitPiece(p_439640_, p_439587_, this.headModel, Direction.SOUTH, p_440126_, p_439564_, p_440267_, false, null);
        this.submitPiece(p_439640_, p_439587_, this.footModel, Direction.SOUTH, p_440126_, p_439564_, p_440267_, true, null);
    }

    private void submitPiece(PoseStack p_440523_, SubmitNodeCollector p_440584_, Model.Simple p_440701_, Direction p_439931_, Material p_439303_, int p_438920_, int p_439582_, boolean p_440123_, @Nullable ModelFeatureRenderer.CrumblingOverlay p_439398_) {
        p_440523_.pushPose();
        TofuBedRenderer.preparePose(p_440523_, p_440123_, p_439931_);
        p_440584_.submitModel((Model)p_440701_, (Object)Unit.INSTANCE, p_440523_, RenderType.entityCutoutNoCull((ResourceLocation)BED_TEXTURES), p_438920_, p_439582_, -1, null, 0, p_439398_);
        p_440523_.popPose();
    }

    private static void preparePose(PoseStack p_428361_, boolean p_428252_, Direction p_428231_) {
        p_428361_.translate(0.0f, 0.5625f, p_428252_ ? -1.0f : 0.0f);
        p_428361_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        p_428361_.translate(0.5f, 0.5f, 0.5f);
        p_428361_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f + p_428231_.toYRot()));
        p_428361_.translate(-0.5f, -0.5f, -0.5f);
    }

    public void getExtents(Set<Vector3f> p_428359_) {
        PoseStack posestack = new PoseStack();
        TofuBedRenderer.preparePose(posestack, false, Direction.SOUTH);
        this.headModel.root().getExtentsForGui(posestack, p_428359_);
        posestack.setIdentity();
        TofuBedRenderer.preparePose(posestack, true, Direction.SOUTH);
        this.footModel.root().getExtentsForGui(posestack, p_428359_);
    }
}

