/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.compat.jei;

import baguchi.tofucraft.compat.jei.JEIPlugin;
import baguchi.tofucraft.recipe.HardenRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class HardenCategory
implements IRecipeCategory<HardenRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"harden");
    protected final IDrawableAnimated arrow;
    private final Component title = Component.translatable((String)"tofucraft.jei.harden");
    private final IDrawable background;
    private final IDrawable icon;

    public HardenCategory(IGuiHelper helper) {
        ResourceLocation backgroundImage = ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"textures/gui/general_jei_recipe.png");
        this.background = helper.createDrawable(backgroundImage, 16, 16, 144, 54);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.COBBLESTONE));
        this.arrow = helper.drawableBuilder(backgroundImage, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public int getWidth() {
        return 144;
    }

    public int getHeight() {
        return 54;
    }

    public ResourceLocation getRegistryName(HardenRecipe recipe) {
        return UID;
    }

    public IRecipeType<HardenRecipe> getRecipeType() {
        return JEIPlugin.HARDEN_JEI_TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, HardenRecipe recipe, IFocusGroup focuses) {
        Ingredient recipeIngredients = recipe.getTofu();
        int borderSlotSize = 18;
        builder.addSlot(RecipeIngredientRole.INPUT, 38, 18).add(recipeIngredients);
        builder.addSlot(RecipeIngredientRole.INPUT, 38, 18 - borderSlotSize).add((ItemLike)Items.COBBLESTONE);
        builder.addSlot(RecipeIngredientRole.INPUT, 38, 18 + borderSlotSize).add((ItemLike)Items.COBBLESTONE);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 81, 18).add(recipe.getResult());
    }

    public void draw(HardenRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        this.background.draw(stack);
        this.arrow.draw(stack, 55, 18);
    }
}

