/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.compat.jei;

import baguchi.tofucraft.TofuCraftReload;
import baguchi.tofucraft.client.screen.TFOvenScreen;
import baguchi.tofucraft.client.screen.TfCraftingTableScreen;
import baguchi.tofucraft.client.screen.TofuPotScreen;
import baguchi.tofucraft.compat.jei.BitternCategory;
import baguchi.tofucraft.compat.jei.HardenCategory;
import baguchi.tofucraft.compat.jei.JEIContents;
import baguchi.tofucraft.compat.jei.TFRecipeCategory;
import baguchi.tofucraft.compat.jei.TofuPotCategory;
import baguchi.tofucraft.inventory.TFCraftingTableMenu;
import baguchi.tofucraft.inventory.TFOvenMenu;
import baguchi.tofucraft.inventory.TofuPotMenu;
import baguchi.tofucraft.recipe.BitternRecipe;
import baguchi.tofucraft.recipe.HardenRecipe;
import baguchi.tofucraft.recipe.TFCraftingRecipe;
import baguchi.tofucraft.recipe.TofuPotRecipe;
import baguchi.tofucraft.registry.TofuBlocks;
import baguchi.tofucraft.registry.TofuItems;
import baguchi.tofucraft.registry.TofuMenus;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.common.Internal;
import mezz.jei.library.plugins.vanilla.gui.RecipeBookGuiHandler;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final ResourceLocation PLUGIN_ID = ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"jei_plugin");
    public static final IRecipeType<HardenRecipe> HARDEN_JEI_TYPE = IRecipeType.create((ResourceLocation)TofuCraftReload.prefix("harden"), HardenRecipe.class);
    public static final IRecipeType<BitternRecipe> BITTERN_JEI_TYPE = IRecipeType.create((ResourceLocation)TofuCraftReload.prefix("bittern"), BitternRecipe.class);
    public static final IRecipeType<TFCraftingRecipe> TF_RECIPE_JEI_TYPE = IRecipeType.create((ResourceLocation)TofuCraftReload.prefix("tf_craft"), TFCraftingRecipe.class);
    public static final IRecipeType<TofuPotRecipe> TOFU_POT_RECIPE_JEI_TYPE = IRecipeType.create((ResourceLocation)TofuCraftReload.prefix("tofu_pot"), TofuPotRecipe.class);

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new HardenCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new BitternCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new TFRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new TofuPotCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        JEIPlugin.addInfo(registration, (Item)TofuItems.BITTERN_BOTTLE.get());
        JEIPlugin.addInfo(registration, ((Block)TofuBlocks.KINUTOFU.get()).asItem());
        JEIPlugin.addInfo(registration, ((Block)TofuBlocks.MOMENTOFU.get()).asItem());
        JEIPlugin.addInfo(registration, (Item)TofuItems.SOYMILK.get());
        JEIPlugin.addInfo(registration, (Item)TofuItems.SOYMILK_APPLE.get(), (Item)TofuItems.SOYMILK.get());
        JEIPlugin.addInfo(registration, (Item)TofuItems.SOYMILK_ANNIN.get(), (Item)TofuItems.SOYMILK.get());
        JEIPlugin.addInfo(registration, (Item)TofuItems.SOYMILK_PUDDING.get(), (Item)TofuItems.SOYMILK.get());
        JEIPlugin.addInfo(registration, (Item)TofuItems.SOYMILK_PUMPKIN.get(), (Item)TofuItems.SOYMILK.get());
        JEIPlugin.addInfo(registration, (Item)TofuItems.SOYMILK_STRAWBERRY.get(), (Item)TofuItems.SOYMILK.get());
        JEIPlugin.addInfo(registration, (Item)TofuItems.SOYMILK_FRUITS.get(), (Item)TofuItems.SOYMILK.get());
        JEIPlugin.addInfo(registration, (Item)TofuItems.SOYMILK_TEA.get(), (Item)TofuItems.SOYMILK.get());
        JEIPlugin.addInfo(registration, (Item)TofuItems.SOYMILK_HONEY.get(), (Item)TofuItems.SOYMILK.get());
        JEIPlugin.addInfo(registration, (Item)TofuItems.SOYMILK_RAMUNE.get(), (Item)TofuItems.SOYMILK.get());
        JEIPlugin.addInfo(registration, (Item)TofuItems.SOYMILK_SAKURA.get(), (Item)TofuItems.SOYMILK.get());
        registration.addRecipes(HARDEN_JEI_TYPE, JEIContents.getAllHardenRecipes(Internal.getClientSyncedRecipes()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(BITTERN_JEI_TYPE, JEIContents.getAllBitternRecipes(Internal.getClientSyncedRecipes()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(TF_RECIPE_JEI_TYPE, JEIContents.getAllTFCraftRecipes(Internal.getClientSyncedRecipes()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(TOFU_POT_RECIPE_JEI_TYPE, JEIContents.getAllTofuPotRecipes(Internal.getClientSyncedRecipes()).stream().map(RecipeHolder::value).toList());
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(TFCraftingTableMenu.class, TofuMenus.TF_CRAFTING_TABLE.get(), TF_RECIPE_JEI_TYPE, 0, 9, 10, 36);
        registration.addRecipeTransferHandler(TofuPotMenu.class, TofuMenus.TOFU_POT.get(), TOFU_POT_RECIPE_JEI_TYPE, 0, 12, 13, 36);
        registration.addRecipeTransferHandler(TFOvenMenu.class, TofuMenus.TF_OVEN.get(), (IRecipeType)RecipeTypes.SMELTING, 0, 1, 2, 36);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(TofuPotScreen.class, 103, 36, 28, 23, new IRecipeType[]{TOFU_POT_RECIPE_JEI_TYPE});
        registration.addRecipeClickArea(TfCraftingTableScreen.class, 88, 32, 28, 23, new IRecipeType[]{TF_RECIPE_JEI_TYPE});
        registration.addRecipeClickArea(TFOvenScreen.class, 70, 14, 28, 23, new IRecipeType[]{RecipeTypes.SMELTING});
        registration.addGuiContainerHandler(TofuPotScreen.class, (IGuiContainerHandler)new RecipeBookGuiHandler());
        registration.addGuiContainerHandler(TfCraftingTableScreen.class, (IGuiContainerHandler)new RecipeBookGuiHandler());
        registration.addGuiContainerHandler(TFOvenScreen.class, (IGuiContainerHandler)new RecipeBookGuiHandler());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addCraftingStation(HARDEN_JEI_TYPE, new ItemStack[]{new ItemStack((ItemLike)Blocks.COBBLESTONE)});
        registration.addCraftingStation(BITTERN_JEI_TYPE, new ItemStack[]{new ItemStack((ItemLike)TofuItems.BITTERN_BOTTLE.get())});
        registration.addCraftingStation(TF_RECIPE_JEI_TYPE, new ItemStack[]{new ItemStack((ItemLike)TofuBlocks.TF_CRAFTING_TABLE.get())});
        registration.addCraftingStation(TOFU_POT_RECIPE_JEI_TYPE, new ItemStack[]{new ItemStack((ItemLike)TofuBlocks.TOFU_POT.get())});
    }

    private static void addInfo(IRecipeRegistration registration, Item item) {
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)item), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)("tofucraft." + BuiltInRegistries.ITEM.getKey((Object)item).getPath() + ".jei_desc"))});
    }

    private static void addInfo(IRecipeRegistration registration, Item item, Item originalDescItem) {
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)item), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)("tofucraft." + BuiltInRegistries.ITEM.getKey((Object)originalDescItem).getPath() + ".jei_desc"))});
    }

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }
}

