/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.data.generator.recipe;

import baguchi.tofucraft.TofuCraftReload;
import baguchi.tofucraft.registry.TofuBlocks;
import baguchi.tofucraft.registry.TofuItems;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.SignBlock;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;

public abstract class CraftingDataHelper
extends RecipeProvider {
    public CraftingDataHelper(HolderLookup.Provider generator, RecipeOutput completableFuture) {
        super(generator, completableFuture);
    }

    public ShapedRecipeBuilder makeSign(Supplier<? extends SignBlock> signOut, Supplier<? extends Block> planksIn) {
        return ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)signOut.get()), (int)3).pattern("PPP").pattern("PPP").pattern(" / ").define(Character.valueOf('P'), (ItemLike)planksIn.get()).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)planksIn.get()).getPath(), this.has((ItemLike)planksIn.get()));
    }

    protected ShapedRecipeBuilder makeHangingSign(Supplier<? extends CeilingHangingSignBlock> result, Supplier<? extends Block> log) {
        return ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)result.get()), (int)6).pattern("| |").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)log.get()).define(Character.valueOf('|'), TofuBlocks.TOFU_METAL_CHAIN).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)log.get()).getPath(), this.has((ItemLike)log.get()));
    }

    public final Ingredient potion(Holder<Potion> potion) {
        PotionContents potionContents = new PotionContents(potion);
        DataComponentMap componentMap = DataComponentMap.builder().set(DataComponents.POTION_CONTENTS, (Object)potionContents).build();
        return DataComponentIngredient.of((boolean)false, (DataComponentMap)componentMap, (ItemLike[])new ItemLike[]{Items.POTION});
    }

    protected final void foodCooking(Supplier<? extends ItemLike> material, Supplier<? extends ItemLike> result, float xp, RecipeOutput consumer) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)material.get()), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result.get(), (float)xp, (int)200).unlockedBy("has_item", this.has(material.get())).save(consumer, this.prefix("smelting_" + BuiltInRegistries.ITEM.getKey((Object)result.get().asItem()).getPath()));
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike)material.get()), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result.get(), (float)xp, (int)100).unlockedBy("has_item", this.has(material.get())).save(consumer, this.prefix("smoking_" + BuiltInRegistries.ITEM.getKey((Object)result.get().asItem()).getPath()));
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike)material.get()), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result.get(), (float)xp, (int)600).unlockedBy("has_item", this.has(material.get())).save(consumer, this.prefix("campfire_cooking_" + BuiltInRegistries.ITEM.getKey((Object)result.get().asItem()).getPath()));
    }

    protected final void foodCookingButNoCampfire(Supplier<? extends ItemLike> material, Supplier<? extends ItemLike> result, float xp, RecipeOutput consumer) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)material.get()), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result.get(), (float)xp, (int)200).unlockedBy("has_item", this.has(material.get())).save(consumer, this.prefix("smelting_" + BuiltInRegistries.ITEM.getKey((Object)result.get().asItem()).getPath()));
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike)material.get()), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result.get(), (float)xp, (int)100).unlockedBy("has_item", this.has(material.get())).save(consumer, this.prefix("smoking_" + BuiltInRegistries.ITEM.getKey((Object)result.get().asItem()).getPath()));
    }

    protected final void foodCooking(Supplier<? extends ItemLike> material, Supplier<? extends ItemLike> result, float xp, RecipeOutput consumer, String recipeName) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)material.get()), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result.get(), (float)xp, (int)200).unlockedBy("has_item", this.has(material.get())).save(consumer, this.prefix("smelting_" + recipeName));
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike)material.get()), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result.get(), (float)xp, (int)100).unlockedBy("has_item", this.has(material.get())).save(consumer, this.prefix("smoking_" + recipeName));
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike)material.get()), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result.get(), (float)xp, (int)600).unlockedBy("has_item", this.has(material.get())).save(consumer, this.prefix("campfire_cooking_" + recipeName));
    }

    public void cuttingRecipe(RecipeOutput consumer, Supplier<? extends ItemLike> cuttingItem, Supplier<? extends ItemLike> result, int count) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike)cuttingItem.get()), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result.get(), (int)count).unlockedBy("has_item", this.has(cuttingItem.get())).save(consumer, this.prefix("cutting_" + CraftingDataHelper.getItemName((ItemLike)result.get()) + "_from_" + CraftingDataHelper.getItemName((ItemLike)cuttingItem.get())));
    }

    public void tofuDiamondSmithing(RecipeOutput consumer, ItemLike smithItem, RecipeCategory recipeCategory, Supplier<? extends Item> result) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike)((ItemLike)TofuItems.TOFU_UPGRADE_SMITHING_TEMPLATE.get())), (Ingredient)Ingredient.of((ItemLike)smithItem), (Ingredient)Ingredient.of((ItemLike)((ItemLike)TofuBlocks.DIAMONDTOFU.get())), (RecipeCategory)recipeCategory, (Item)result.get()).unlocks("has_item", this.has((ItemLike)TofuBlocks.DIAMONDTOFU.get())).save(consumer, this.prefix(BuiltInRegistries.ITEM.getKey((Object)result.get().asItem()).getPath() + "_smithing"));
    }

    public void zundaSmithing(RecipeOutput consumer, ItemLike smithItem, RecipeCategory recipeCategory, Supplier<? extends Item> result) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike)((ItemLike)TofuItems.ZUNDA_UPGRADE_SMITHING_TEMPLATE.get())), (Ingredient)Ingredient.of((ItemLike)smithItem), (Ingredient)Ingredient.of((ItemLike)((ItemLike)TofuItems.ZUNDAMA.get())), (RecipeCategory)recipeCategory, (Item)result.get()).unlocks("has_item", this.has((ItemLike)TofuItems.ZUNDAMA.get())).save(consumer, this.prefix(BuiltInRegistries.ITEM.getKey((Object)result.get().asItem()).getPath() + "_smithing"));
    }

    protected final void helmetItem(RecipeOutput consumer, String name, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> material) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result.get()).pattern("###").pattern("# #").define(Character.valueOf('#'), material.get()).unlockedBy("has_item", this.has(material.get())).save(consumer, this.locEquip(name));
    }

    protected final void chestplateItem(RecipeOutput consumer, String name, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> material) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result.get()).pattern("# #").pattern("###").pattern("###").define(Character.valueOf('#'), material.get()).unlockedBy("has_item", this.has(material.get())).save(consumer, this.locEquip(name));
    }

    protected final void leggingsItem(RecipeOutput consumer, String name, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> material) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result.get()).pattern("###").pattern("# #").pattern("# #").define(Character.valueOf('#'), material.get()).unlockedBy("has_item", this.has(material.get())).save(consumer, this.locEquip(name));
    }

    protected final void bootsItem(RecipeOutput consumer, String name, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> material) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result.get()).pattern("# #").pattern("# #").define(Character.valueOf('#'), material.get()).unlockedBy("has_item", this.has(material.get())).save(consumer, this.locEquip(name));
    }

    protected final void pickaxeItem(RecipeOutput consumer, String name, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> material, TagKey<Item> handle) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result.get()).pattern("###").pattern(" X ").pattern(" X ").define(Character.valueOf('#'), material.get()).define(Character.valueOf('X'), handle).unlockedBy("has_item", this.has(material.get())).save(consumer, this.locEquip(name));
    }

    protected final void swordItem(RecipeOutput consumer, String name, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> material, TagKey<Item> handle) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result.get()).pattern("#").pattern("#").pattern("X").define(Character.valueOf('#'), material.get()).define(Character.valueOf('X'), handle).unlockedBy("has_item", this.has(material.get())).save(consumer, this.locEquip(name));
    }

    protected final void axeItem(RecipeOutput consumer, String name, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> material, TagKey<Item> handle) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result.get()).pattern("##").pattern("#X").pattern(" X").define(Character.valueOf('#'), material.get()).define(Character.valueOf('X'), handle).unlockedBy("has_item", this.has(material.get())).save(consumer, this.locEquip(name));
    }

    protected final void shovelItem(RecipeOutput consumer, String name, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> material, TagKey<Item> handle) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result.get()).pattern("#").pattern("X").pattern("X").define(Character.valueOf('#'), material.get()).define(Character.valueOf('X'), handle).unlockedBy("has_item", this.has(material.get())).save(consumer, this.locEquip(name));
    }

    protected final void hoeItem(RecipeOutput consumer, String name, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> material, TagKey<Item> handle) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result.get()).pattern("##").pattern(" X").pattern(" X").define(Character.valueOf('#'), material.get()).define(Character.valueOf('X'), handle).unlockedBy("has_item", this.has(material.get())).save(consumer, this.locEquip(name));
    }

    protected final void tofuBlockItem(RecipeOutput consumer, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> material) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result.get()).pattern("##").pattern("##").define(Character.valueOf('#'), material.get()).unlockedBy("has_item", this.has(material.get())).save(consumer);
    }

    protected final void tofuBlockItem(RecipeOutput consumer, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> material, String name) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result.get()).pattern("##").pattern("##").define(Character.valueOf('#'), material.get()).unlockedBy("has_item", this.has(material.get())).save(consumer, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)TofuCraftReload.prefix(name)));
    }

    protected final void ladderItem(RecipeOutput consumer, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> material) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result.get(), (int)6).pattern("# #").pattern("###").pattern("# #").define(Character.valueOf('#'), material.get()).unlockedBy("has_item", this.has(material.get())).save(consumer);
    }

    protected final void buildingTofuBlockItem(RecipeOutput consumer, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> material) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result.get(), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), material.get()).unlockedBy("has_item", this.has(material.get())).save(consumer);
    }

    public void makeStairs(RecipeOutput consumer, Supplier<? extends ItemLike> stairsOut, Supplier<? extends ItemLike> blockIn) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stairsOut.get(), (int)4).pattern("M  ").pattern("MM ").pattern("MMM").define(Character.valueOf('M'), blockIn.get()).unlockedBy("has_item", this.has(blockIn.get())).save(consumer);
    }

    public void makeStairsCraftingOrCutting(RecipeOutput consumer, Supplier<? extends ItemLike> stairsOut, Supplier<? extends ItemLike> blockIn) {
        this.makeStairs(consumer, stairsOut, blockIn);
        this.cuttingRecipe(consumer, blockIn, stairsOut, 2);
    }

    public void makeSlab(RecipeOutput consumer, Supplier<? extends ItemLike> slabOut, Supplier<? extends ItemLike> blockIn) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slabOut.get(), (int)6).pattern("MMM").define(Character.valueOf('M'), blockIn.get()).unlockedBy("has_item", this.has(blockIn.get())).save(consumer);
    }

    public void makeSlabCraftingOrCutting(RecipeOutput consumer, Supplier<? extends ItemLike> slabOut, Supplier<? extends ItemLike> blockIn) {
        this.makeSlab(consumer, slabOut, blockIn);
        this.cuttingRecipe(consumer, blockIn, slabOut, 2);
    }

    public void makeSolidFence(RecipeOutput consumer, Supplier<? extends ItemLike> fenceOut, Supplier<? extends ItemLike> blockIn) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)fenceOut.get(), (int)6).pattern("MMM").pattern("MMM").define(Character.valueOf('M'), blockIn.get()).unlockedBy("has_item", this.has(blockIn.get())).save(consumer);
    }

    public void makeTorch(RecipeOutput consumer, Supplier<? extends ItemLike> torchOut, Supplier<? extends ItemLike> itemIn) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)torchOut.get(), (int)4).pattern("C").pattern("M").define(Character.valueOf('C'), ItemTags.COALS).define(Character.valueOf('M'), itemIn.get()).unlockedBy("has_item", this.has(itemIn.get())).save(consumer);
    }

    public void makeDoor(RecipeOutput consumer, Supplier<? extends Block> doorOut, Supplier<? extends Block> plankIn) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)doorOut.get()), (int)3).pattern("PP").pattern("PP").pattern("PP").define(Character.valueOf('P'), (ItemLike)plankIn.get()).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)plankIn.get().asItem()).getPath(), this.has((ItemLike)plankIn.get())).save(consumer);
    }

    public void makeTrapdoor(RecipeOutput consumer, Supplier<? extends Block> trapdoorOut, Supplier<? extends ItemLike> plankIn) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)trapdoorOut.get()), (int)2).pattern("PP").pattern("PP").define(Character.valueOf('P'), plankIn.get()).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)plankIn.get().asItem()).getPath(), this.has(plankIn.get())).save(consumer);
    }

    public void makeWoodFence(RecipeOutput consumer, Block fenceOut, Block blockIn) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)fenceOut, (int)3).pattern("MSM").pattern("MSM").define(Character.valueOf('M'), (ItemLike)blockIn).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)blockIn).getPath(), this.has((ItemLike)blockIn)).save(consumer);
    }

    public void makeFenceGate(RecipeOutput consumer, Block fenceOut, Block blockIn) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)fenceOut).pattern("SMS").pattern("SMS").define(Character.valueOf('M'), (ItemLike)blockIn).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)blockIn).getPath(), this.has((ItemLike)blockIn)).save(consumer);
    }

    protected ResourceKey<Recipe<?>> prefix(String name) {
        return ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)TofuCraftReload.prefix(name));
    }

    protected final ResourceKey<Recipe<?>> locEquip(String name) {
        return ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)TofuCraftReload.prefix("equipment/" + name));
    }
}

