/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.data.resources.registries;

import baguchi.tofucraft.TofuCraftReload;
import baguchi.tofucraft.api.entity.TofunianClothVariant;
import baguchi.tofucraft.registry.TofuBiomes;
import baguchi.tofucraft.registry.TofuTags;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public class TofunianClothVariants {
    public static final ResourceKey<Registry<TofunianClothVariant>> TOFUNIAN_CLOTH_VARIANT_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofunian_cloth_variant"));
    public static final ResourceKey<TofunianClothVariant> NORMAL = TofunianClothVariants.createKey("normal");
    public static final ResourceKey<TofunianClothVariant> ZUNDA = TofunianClothVariants.createKey("zunda");
    public static final ResourceKey<TofunianClothVariant> WASTE_LAND = TofunianClothVariants.createKey("waste_land");
    public static final ResourceKey<TofunianClothVariant> DEFAULT = NORMAL;

    private static ResourceKey<TofunianClothVariant> createKey(String name) {
        return ResourceKey.create(TOFUNIAN_CLOTH_VARIANT_REGISTRY_KEY, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)name));
    }

    static void register(BootstrapContext<TofunianClothVariant> context, ResourceKey<TofunianClothVariant> key, String name, ResourceKey<Biome> biomeResourceKey) {
        TofunianClothVariants.register(context, key, name, (HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.BIOME).getOrThrow(biomeResourceKey)}));
    }

    static void register(BootstrapContext<TofunianClothVariant> context, ResourceKey<TofunianClothVariant> key, String name, TagKey<Biome> biomeTag) {
        TofunianClothVariants.register(context, key, name, (HolderSet<Biome>)context.lookup(Registries.BIOME).getOrThrow(biomeTag));
    }

    static void register(BootstrapContext<TofunianClothVariant> context, ResourceKey<TofunianClothVariant> key, String name, HolderSet<Biome> biomeHolderSet) {
        ResourceLocation resourcelocation = TofuCraftReload.prefix("entity/tofunian/cloth/" + name);
        context.register(key, (Object)new TofunianClothVariant(resourcelocation, biomeHolderSet));
    }

    public static Holder<TofunianClothVariant> getSpawnVariant(RegistryAccess p_332694_, Holder<Biome> p_332773_) {
        Registry registry = p_332694_.lookupOrThrow(TOFUNIAN_CLOTH_VARIANT_REGISTRY_KEY);
        return (Holder)registry.listElements().filter(p_332674_ -> ((TofunianClothVariant)p_332674_.value()).biomes().contains(p_332773_)).findFirst().or(() -> registry.get(DEFAULT)).or(() -> ((Registry)registry).getAny()).orElseThrow();
    }

    public static void bootstrap(BootstrapContext<TofunianClothVariant> context) {
        TofunianClothVariants.register(context, NORMAL, "normal", (HolderSet<Biome>)HolderSet.empty());
        TofunianClothVariants.register(context, ZUNDA, "zunda", TofuBiomes.ZUNDA_FOREST);
        TofunianClothVariants.register(context, WASTE_LAND, "waste_land", TofuTags.Biomes.HOT_VARIANT_TOFUNIAN);
    }
}

