/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.entity.projectile;

import baguchi.tofucraft.registry.TofuBlocks;
import baguchi.tofucraft.registry.TofuDamageTypes;
import baguchi.tofucraft.registry.TofuEntityTypes;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class FallingTofuEntity
extends ThrowableProjectile {
    private BlockState state = Blocks.STONE.defaultBlockState();
    private boolean canPlace = true;

    public FallingTofuEntity(EntityType<? extends FallingTofuEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public FallingTofuEntity(Level world, LivingEntity thrower, @Nullable BlockState state) {
        super(TofuEntityTypes.FALLING_TOFU.get(), thrower.getX(), thrower.getY(), thrower.getZ(), world);
        this.setOwner((Entity)thrower);
        if (state != null) {
            this.state = state;
        }
    }

    protected void addAdditionalSaveData(ValueOutput tag) {
        super.addAdditionalSaveData(tag);
        tag.store("BlockState", BlockState.CODEC, (Object)this.state);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(ValueInput tag) {
        super.readAdditionalSaveData(tag);
        this.state = tag.read("BlockState", BlockState.CODEC).orElse(((Block)TofuBlocks.KINUTOFU.get()).defaultBlockState());
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            BlockParticleOption particle = new BlockParticleOption(ParticleTypes.BLOCK, this.state);
            for (int i = 0; i < 20; ++i) {
                this.level().addParticle((ParticleOptions)particle, this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.05, this.random.nextDouble() * 0.2, this.random.nextGaussian() * 0.05);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    public DamageSource tofuAttack(@Nullable Entity p_270857_) {
        return this.damageSources().source(TofuDamageTypes.FALLING_TOFU, (Entity)this, p_270857_);
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (!this.level().isClientSide()) {
            result.getEntity().hurt(this.tofuAttack(this.getOwner()), 3.0f);
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.gameEvent((Holder)GameEvent.BLOCK_DESTROY, this.getOwner());
            if (this.canPlace) {
                this.level().setBlock(this.blockPosition(), this.state, 2);
            }
            this.discard();
        }
    }

    public BlockState getBlockState() {
        return this.state;
    }

    public void setCanPlace(boolean canPlace) {
        this.canPlace = canPlace;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity p_352287_) {
        return new ClientboundAddEntityPacket((Entity)this, p_352287_, Block.getId((BlockState)this.getBlockState()));
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        this.state = Block.stateById((int)packet.getData());
    }
}

