/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.item;

import baguchi.tofucraft.api.tfenergy.IEnergyContained;
import baguchi.tofucraft.api.tfenergy.IEnergyExtractable;
import baguchi.tofucraft.api.tfenergy.IEnergyInsertable;
import baguchi.tofucraft.api.tfenergy.TFEnergyData;
import baguchi.tofucraft.registry.TofuDataComponents;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;

public class TFBatteryItem
extends Item
implements IEnergyInsertable,
IEnergyContained,
IEnergyExtractable {
    public TFBatteryItem(Item.Properties p_43089_) {
        super(p_43089_);
    }

    @Override
    public int fill(ItemStack inst, int energy, boolean simulate) {
        if (!simulate) {
            int calculated2 = Math.min(energy, this.getEnergyMax(inst) - this.getEnergy(inst));
            this.setEnergy(inst, this.getEnergy(inst) + calculated2);
            return calculated2;
        }
        return 0;
    }

    @Override
    public int getEnergy(ItemStack inst) {
        return inst.get(TofuDataComponents.TF_ENERGY_DATA) != null ? ((TFEnergyData)inst.get(TofuDataComponents.TF_ENERGY_DATA)).storeTF() : 0;
    }

    @Override
    public int getEnergyMax(ItemStack inst) {
        return inst.get(TofuDataComponents.TF_ENERGY_DATA) != null ? ((TFEnergyData)inst.get(TofuDataComponents.TF_ENERGY_DATA)).maxTF() : 5000;
    }

    @Override
    public void setEnergy(ItemStack inst, int amount) {
        inst.set(TofuDataComponents.TF_ENERGY_DATA, (Object)new TFEnergyData(amount, this.getEnergyMax(inst)));
    }

    @Override
    public void setEnergyMax(ItemStack inst, int amount) {
        inst.set(TofuDataComponents.TF_ENERGY_DATA, (Object)new TFEnergyData(this.getEnergy(inst), amount));
    }

    private boolean getShowState(ItemStack stack) {
        return this.getEnergy(stack) != 0;
    }

    public boolean isBarVisible(ItemStack p_150899_) {
        return this.getShowState(p_150899_) || super.isBarVisible(p_150899_);
    }

    public int getBarWidth(ItemStack stack) {
        return this.getShowState(stack) ? Math.round((float)this.getEnergy(stack) / (float)this.getEnergyMax(stack) * 13.0f) : super.getBarWidth(stack);
    }

    public int getBarColor(ItemStack p_150901_) {
        return this.getShowState(p_150901_) ? Color.white.getRGB() : super.getBarColor(p_150901_);
    }

    public void appendHoverText(ItemStack p_41421_, Item.TooltipContext p_339594_, TooltipDisplay p_399753_, Consumer<Component> p_399884_, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_339594_, p_399753_, p_399884_, p_41424_);
        p_399884_.accept((Component)Component.translatable((String)"tooltip.tofucraft.energy", (Object[])new Object[]{this.getEnergy(p_41421_), this.getEnergyMax(p_41421_)}));
    }

    @Override
    public int drain(ItemStack inst, int amount, boolean simulate) {
        if (!simulate) {
            int calculated2 = Math.min(this.getEnergy(inst), amount);
            this.setEnergy(inst, this.getEnergy(inst) - calculated2);
            return calculated2;
        }
        return 0;
    }
}

