/*
 * Decompiled with CFR 0.152.
 */
package net.critical_strike.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.critical_strike.client.particle.TemplateParticleEffect;
import net.critical_strike.client.particle.TemplateParticleType;
import net.critical_strike.client.util.Color;
import net.critical_strike.fx.CriticalStrikeParticles;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class CriticalStrikeParticle
extends TextureSheetParticle {
    private static final RandomSource RANDOM = RandomSource.create();
    private final SpriteSet spriteProvider;
    private final CriticalStrikeParticles.Motion motion;
    private boolean animated = false;
    public boolean glows = true;
    public boolean translucent = true;
    @Nullable
    Entity followEntity;
    private float growPerTickDelta = 0.0f;
    private float fadePerTickDelta = 0.0f;
    private float overlayScale = 0.8f;
    private float lastRendered = 0.0f;
    private boolean geometryForOverlay = false;

    CriticalStrikeParticle(ClientLevel world, SpriteSet spriteProvider, CriticalStrikeParticles.Motion motion, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        super(world, x, y, z, 0.5 - RANDOM.nextDouble(), velocityY, 0.5 - RANDOM.nextDouble());
        this.spriteProvider = spriteProvider;
        this.motion = motion;
        switch (motion) {
            case FLOAT: 
            case DECELERATE: {
                this.friction = 0.96f;
                this.xd = this.xd * (double)0.01f + velocityX;
                this.yd = this.yd * (double)0.01f + velocityY;
                this.zd = this.zd * (double)0.01f + velocityZ;
                this.x += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f);
                this.y += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f);
                this.z += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f);
                if (motion == CriticalStrikeParticles.Motion.DECELERATE) {
                    this.friction *= 0.8f;
                }
                this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2));
                break;
            }
            case ASCEND: {
                this.friction = 0.96f;
                this.gravity = -0.1f;
                this.speedUpWhenYMotionIsBlocked = true;
                this.yd *= 0.2;
                if (velocityX == 0.0 && velocityZ == 0.0) {
                    this.xd *= (double)0.1f;
                    this.zd *= (double)0.1f;
                }
                this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2));
                break;
            }
            case BURST: {
                this.friction = 0.7f;
                this.gravity = 0.5f;
                this.xd *= (double)0.1f;
                this.yd *= (double)0.1f;
                this.zd *= (double)0.1f;
                this.xd += velocityX * 0.4;
                this.yd += velocityY * 0.4;
                this.zd += velocityZ * 0.4;
                this.lifetime = Math.max((int)(6.0 / (Math.random() * 0.8 + 0.6)), 1);
            }
        }
        this.setSpriteFromAge(spriteProvider);
        this.hasPhysics = false;
    }

    public ParticleRenderType getRenderType() {
        if (this.glows) {
            if (this.translucent) {
                return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
            }
            return ParticleRenderType.PARTICLE_SHEET_LIT;
        }
        if (this.translucent) {
            return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
        }
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public int getLightColor(float tint) {
        if (this.glows) {
            return 255;
        }
        return super.getLightColor(tint);
    }

    public void move(double dx, double dy, double dz) {
        if (this.followEntity != null && !this.followEntity.isRemoved()) {
            dx += this.followEntity.getX() - this.followEntity.xo;
            dy += this.followEntity.getY() - this.followEntity.yo;
            dz += this.followEntity.getZ() - this.followEntity.zo;
        }
        super.move(dx, dy, dz);
    }

    public void tick() {
        super.tick();
        if (this.animated) {
            this.setSpriteFromAge(this.spriteProvider);
        }
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        float currentAge = (float)this.age + tickDelta;
        float elapsed = currentAge - this.lastRendered;
        this.quadSize += this.growPerTickDelta * elapsed;
        this.alpha -= this.fadePerTickDelta * elapsed;
        if (this.alpha < 0.0f) {
            this.alpha = 0.0f;
        }
        super.render(vertexConsumer, camera, tickDelta);
        float red = this.rCol;
        float green = this.gCol;
        float blue = this.bCol;
        float scale = this.quadSize;
        this.rCol = 1.0f;
        this.gCol = 1.0f;
        this.bCol = 1.0f;
        this.quadSize *= this.overlayScale;
        this.geometryForOverlay = true;
        super.render(vertexConsumer, camera, tickDelta);
        this.geometryForOverlay = false;
        this.rCol = red;
        this.gCol = green;
        this.bCol = blue;
        this.quadSize = scale;
        this.lastRendered = currentAge;
    }

    protected void renderRotatedQuad(VertexConsumer vertexConsumer, Camera camera, Quaternionf quaternionf, float f) {
        Vec3 vec3d = camera.getPosition();
        Vec3 overlayOffset = new Vec3(0.0, 0.0, 0.0);
        if (this.geometryForOverlay) {
            Vec3 cameraLook = Vec3.directionFromRotation((float)0.0f, (float)camera.getYRot());
            overlayOffset = cameraLook.normalize().scale(0.01);
        }
        float g = (float)(Mth.lerp((double)f, (double)this.xo, (double)this.x) - vec3d.x() - overlayOffset.x());
        float h = (float)(Mth.lerp((double)f, (double)this.yo, (double)this.y) - vec3d.y());
        float i = (float)(Mth.lerp((double)f, (double)this.zo, (double)this.z) - vec3d.z() - overlayOffset.z());
        this.renderRotatedQuad(vertexConsumer, quaternionf, g, h, i, f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MagicVariant
    implements ParticleProvider<TemplateParticleType> {
        private final SpriteSet spriteProvider;
        private final CriticalStrikeParticles.Behaviour particleBehaviour;

        public MagicVariant(SpriteSet spriteProvider, CriticalStrikeParticles.Behaviour particleBehaviour) {
            this.spriteProvider = spriteProvider;
            this.particleBehaviour = particleBehaviour;
        }

        public Particle createParticle(TemplateParticleType particleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            CriticalStrikeParticle particle = new CriticalStrikeParticle(clientWorld, this.spriteProvider, this.particleBehaviour.motion(), d, e, f, g, h, i);
            particle.glows = true;
            particle.translucent = this.particleBehaviour.fadePerTickDelta() > 0.0f;
            particle.rCol = 1.0f;
            particle.gCol = 1.0f;
            particle.bCol = 1.0f;
            particle.alpha = 0.75f;
            particle.animated = this.particleBehaviour.animated();
            particle.quadSize *= this.particleBehaviour.scale();
            particle.lifetime = this.particleBehaviour.maxAge();
            particle.growPerTickDelta = this.particleBehaviour.growPerTickDelta();
            particle.fadePerTickDelta = this.particleBehaviour.fadePerTickDelta();
            particle.overlayScale = this.particleBehaviour.overlayScale();
            TemplateParticleType.apply(particleType, (Particle)particle);
            TemplateParticleEffect.Appearance appearance = particleType.getAppearance();
            if (appearance != null) {
                Color color = appearance.color;
                if (color != null) {
                    particle.alpha *= appearance.color.alpha();
                }
                particle.quadSize *= appearance.scale;
                particle.followEntity = appearance.entityFollowed;
            }
            float j = clientWorld.random.nextFloat() * 0.4f + 0.6f;
            particle.setColor(particle.rCol * j, particle.gCol * j, particle.bCol * j);
            return particle;
        }
    }
}

