/*
 * Decompiled with CFR 0.152.
 */
package net.critical_strike.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.critical_strike.CriticalStrikeMod;
import net.critical_strike.internal.Config;
import net.critical_strike.internal.CritLogic;
import net.critical_strike.internal.CriticalStriker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={AbstractArrow.class})
public class PersistentProjectileEntityMixin {
    @WrapOperation(method={"onHitEntity(Lnet/minecraft/world/phys/EntityHitResult;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z")})
    private boolean wrapDamageEntity(Entity instance, DamageSource source, float amount, Operation<Boolean> original) {
        CriticalStriker critter;
        CritLogic.Result crit;
        Config config = (Config)CriticalStrikeMod.config.value;
        if (!config.enable_ranged_criticals) {
            return (Boolean)original.call(new Object[]{instance, source, Float.valueOf(amount)});
        }
        AbstractArrow projectile = (AbstractArrow)this;
        Entity entity = projectile.getOwner();
        if (entity instanceof CriticalStriker && (crit = CritLogic.modifyDamage(critter = (CriticalStriker)entity, source, amount)) != null) {
            Boolean result = (Boolean)original.call(new Object[]{instance, crit.source(), Float.valueOf(crit.amount())});
            if (result.booleanValue()) {
                CritLogic.playFxAt(instance, config.sound_ranged_crit_volume);
            }
            return result;
        }
        return (Boolean)original.call(new Object[]{instance, source, Float.valueOf(amount)});
    }
}

