/*
 * Decompiled with CFR 0.152.
 */
package net.critical_strike.fabric.datagen;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.critical_strike.api.CriticalStrikeAttributes;
import net.critical_strike.fabric.datagen.SimpleParticleGenerator;
import net.critical_strike.fabric.datagen.SimpleSoundGeneratorV2;
import net.critical_strike.fx.CriticalStrikeParticles;
import net.critical_strike.fx.CriticalStrikeSounds;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricDynamicRegistryProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1322;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_9274;
import net.minecraft.class_9636;
import net.minecraft.class_9701;
import net.minecraft.class_9704;
import net.minecraft.class_9720;

public class CriticalStrikeDataGenerator
implements DataGeneratorEntrypoint {
    public static final class_2960 CRITICAL_WEAPON_ENCHANTABLE = class_2960.method_60655((String)"critical_strike", (String)"enchantable/weapon");

    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(LangGenerator::new);
        pack.addProvider(ParticlesGen::new);
        pack.addProvider(SoundGen::new);
        pack.addProvider(ItemTagGen::new);
        pack.addProvider(EnchantmentTagGen::new);
        pack.addProvider(EnchantmentGenerator::new);
    }

    public static class EnchantmentGenerator
    extends FabricDynamicRegistryProvider {
        public EnchantmentGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void configure(class_7225.class_7874 registries, FabricDynamicRegistryProvider.Entries entries) {
            class_7871 itemLookup = registries.method_46758().method_46751(class_7924.field_41197);
            class_7871 enchantmentLookup = registries.method_46758().method_46751(class_7924.field_41265);
            class_5321 criticalStrikeId = class_5321.method_29179((class_5321)class_7924.field_41265, (class_2960)Enchantments.CRITICAL_CHANCE.id());
            class_1887.class_9700 criticalStrike = class_1887.method_60030((class_1887.class_9427)class_1887.method_58442((class_6885)itemLookup.method_46735(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)CRITICAL_WEAPON_ENCHANTABLE)), (int)5, (int)5, (class_1887.class_9426)class_1887.method_58441((int)3, (int)12), (class_1887.class_9426)class_1887.method_58441((int)12, (int)11), (int)1, (class_9274[])new class_9274[]{class_9274.field_49217})).method_60065(class_9701.field_51668, new class_9720(class_2960.method_60655((String)Enchantments.CRITICAL_CHANCE.id().method_12836(), (String)("enchantment_" + Enchantments.CRITICAL_CHANCE.id.method_12832())), CriticalStrikeAttributes.CHANCE.attributeEntry, (class_9704)class_9704.method_60194((float)0.04f), class_1322.class_1323.field_6330)).method_60061((class_6885)enchantmentLookup.method_46735(class_6862.method_40092((class_5321)class_7924.field_41265, (class_2960)Enchantments.mutexTagId)));
            entries.add(criticalStrikeId, (Object)criticalStrike.method_60060(criticalStrikeId.method_29177()));
            class_5321 criticalDamageId = class_5321.method_29179((class_5321)class_7924.field_41265, (class_2960)Enchantments.CRITICAL_DAMAGE.id());
            class_1887.class_9700 criticalDamage = class_1887.method_60030((class_1887.class_9427)class_1887.method_58442((class_6885)itemLookup.method_46735(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)CRITICAL_WEAPON_ENCHANTABLE)), (int)5, (int)5, (class_1887.class_9426)class_1887.method_58441((int)3, (int)12), (class_1887.class_9426)class_1887.method_58441((int)12, (int)11), (int)1, (class_9274[])new class_9274[]{class_9274.field_49217})).method_60065(class_9701.field_51668, new class_9720(class_2960.method_60655((String)Enchantments.CRITICAL_DAMAGE.id().method_12836(), (String)("enchantment_" + Enchantments.CRITICAL_DAMAGE.id.method_12832())), CriticalStrikeAttributes.DAMAGE.attributeEntry, (class_9704)class_9704.method_60194((float)0.1f), class_1322.class_1323.field_6330)).method_60061((class_6885)enchantmentLookup.method_46735(class_6862.method_40092((class_5321)class_7924.field_41265, (class_2960)Enchantments.mutexTagId)));
            entries.add(criticalDamageId, (Object)criticalDamage.method_60060(criticalDamageId.method_29177()));
        }

        public String method_10321() {
            return "Critical Strike Enchantments";
        }
    }

    public static class ItemTagGen
    extends FabricTagProvider<class_1792> {
        public ItemTagGen(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, class_7924.field_41197, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)CRITICAL_WEAPON_ENCHANTABLE);
            this.getOrCreateTagBuilder(tagKey).addOptionalTag(class_3489.field_48305.comp_327()).addOptionalTag(class_3489.field_48311.comp_327()).addOptionalTag(class_3489.field_48313.comp_327());
        }

        public String method_10321() {
            return "Critical Strike Item Tags";
        }
    }

    public static class EnchantmentTagGen
    extends FabricTagProvider<class_1887> {
        public EnchantmentTagGen(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, class_7924.field_41265, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41265, (class_2960)Enchantments.mutexTagId);
            this.getOrCreateTagBuilder(tagKey).addOptional(Enchantments.CRITICAL_CHANCE.id).addOptional(Enchantments.CRITICAL_DAMAGE.id);
            class_6862 nonTreasureTagKey = class_9636.field_51558;
            this.getOrCreateTagBuilder(nonTreasureTagKey).addOptional(Enchantments.CRITICAL_CHANCE.id).addOptional(Enchantments.CRITICAL_DAMAGE.id);
        }

        public String method_10321() {
            return "Critical Strike Enchantment Tags";
        }
    }

    public static class Enchantments {
        public static ArrayList<Entry> entries = new ArrayList();
        public static Entry CRITICAL_CHANCE = Enchantments.add(new Entry(class_2960.method_60655((String)"critical_strike", (String)"chance"), "Critical Hit", "Increase chance to deal critical hits."));
        public static Entry CRITICAL_DAMAGE = Enchantments.add(new Entry(class_2960.method_60655((String)"critical_strike", (String)"damage"), "Critical Impact", "Increase damage dealt by critical hits."));
        private static class_2960 mutexTagId = class_2960.method_60655((String)"critical_strike", (String)"critical_enchantments");

        public static Entry add(Entry entry) {
            entries.add(entry);
            return entry;
        }

        public record Entry(class_2960 id, String name, String description) {
        }
    }

    public static class SoundGen
    extends SimpleSoundGeneratorV2 {
        public SoundGen(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        @Override
        public void generateSounds(SimpleSoundGeneratorV2.Builder builder) {
            builder.entries.add(new SimpleSoundGeneratorV2.Entry("critical_strike", CriticalStrikeSounds.entries.stream().map(entry -> SimpleSoundGeneratorV2.SoundEntry.withVariants(entry.id().method_12832(), entry.variants())).toList()));
        }
    }

    public static class ParticlesGen
    extends SimpleParticleGenerator {
        public ParticlesGen(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        @Override
        public void generateSimpleParticles(SimpleParticleGenerator.Builder builder) {
            int i;
            for (CriticalStrikeParticles.Entry entry : CriticalStrikeParticles.ENTRIES) {
                if (entry.texture().frames() > 1) {
                    for (i = 0; i < entry.texture().frames(); ++i) {
                        builder.add(entry.id(), new SimpleParticleGenerator.ParticleData(List.of(entry.texture().id().toString() + "_" + i)));
                    }
                    continue;
                }
                builder.add(entry.id(), new SimpleParticleGenerator.ParticleData(List.of(entry.texture().id().toString())));
            }
            for (CriticalStrikeParticles.TemplateEntry templateEntry : CriticalStrikeParticles.TEMPLATE_ENTRIES) {
                if (templateEntry.texture().frames() > 1) {
                    for (i = 0; i < templateEntry.texture().frames(); ++i) {
                        builder.add(templateEntry.id(), new SimpleParticleGenerator.ParticleData(List.of(templateEntry.texture().id().toString() + "_" + i)));
                    }
                    continue;
                }
                builder.add(templateEntry.id(), new SimpleParticleGenerator.ParticleData(List.of(templateEntry.texture().id().toString())));
            }
        }
    }

    public static class LangGenerator
    extends FabricLanguageProvider {
        protected LangGenerator(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, "en_us", registryLookup);
        }

        public void generateTranslations(class_7225.class_7874 wrapperLookup, FabricLanguageProvider.TranslationBuilder translationBuilder) {
            for (CriticalStrikeAttributes.Entry entry : CriticalStrikeAttributes.all) {
                translationBuilder.add(entry.translationKey, entry.translations.name());
                String effectKey = class_156.method_646((String)"effect", (class_2960)entry.id);
                translationBuilder.add(effectKey, entry.translations.effectName());
                translationBuilder.add(effectKey + ".description", entry.translations.effectDescription());
                String potionPath = entry.potionId().method_12832();
                String tippedArrowKey = "item.minecraft.tipped_arrow.effect." + potionPath;
                translationBuilder.add(tippedArrowKey, "Arrow of " + entry.translations.effectName());
                String potionKey = "item.minecraft.potion.effect." + potionPath;
                translationBuilder.add(potionKey, "Potion of " + entry.translations.effectName());
                String splashPotionKey = "item.minecraft.splash_potion.effect." + potionPath;
                translationBuilder.add(splashPotionKey, "Splash Potion of " + entry.translations.effectName());
                String lingeringPotionKey = "item.minecraft.lingering_potion.effect." + potionPath;
                translationBuilder.add(lingeringPotionKey, "Lingering Potion of " + entry.translations.effectName());
            }
            for (Enchantments.Entry entry : Enchantments.entries) {
                String key = class_156.method_646((String)"enchantment", (class_2960)entry.id());
                translationBuilder.add(key, entry.name());
                translationBuilder.add(key + ".description", entry.description());
            }
        }
    }
}

