/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.util.config;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.item.StandDiscItem;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.config.AdvancedConfig;
import net.hydra.jojomod.util.config.ClientConfig;
import net.hydra.jojomod.util.config.Config;
import net.hydra.jojomod.util.config.ConfigParser;
import net.hydra.jojomod.util.config.annotation.BooleanOption;
import net.hydra.jojomod.util.config.annotation.FloatOption;
import net.hydra.jojomod.util.config.annotation.IntOption;
import net.hydra.jojomod.util.config.annotation.NestedOption;
import net.hydra.jojomod.util.option.ConfigOptionReference;
import net.hydra.jojomod.util.option.Reflection;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.zetalasis.hjson.JsonValue;

public abstract class ConfigManager {
    public static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    private static Path clientConfigPath;
    private static Path localConfigPath;
    private static Path serverConfigPath;
    private static Path advancedConfigPath;
    private static boolean loaded;
    private static ClientConfig DEFAULT_CLIENT_CONFIG;
    private static Config DEFAULT_LOCAL_CONFIG;
    private static Config DEFAULT_SERVER_CONFIG;
    private static AdvancedConfig DEFAULT_ADVANCED_CONFIG;

    public static Config getConfig() {
        return Config.getLocalInstance();
    }

    public static AdvancedConfig getAdvancedConfig() {
        return AdvancedConfig.getInstance();
    }

    public static ClientConfig getClientConfig() {
        return ClientConfig.getLocalInstance();
    }

    public static void loadConfigs(Path client, Path advanced, Path actualClient) {
        clientConfigPath = actualClient;
        localConfigPath = client;
        serverConfigPath = client;
        advancedConfigPath = advanced;
        ConfigManager.loadClientConfig();
        ConfigManager.loadLocalConfig();
        ConfigManager.loadServerConfig();
        ConfigManager.loadAdvancedConfig();
        loaded = true;
    }

    public static void loadBlacklists() {
        if (ConfigManager.getAdvancedConfig().walkingHeartWalkOnBlockBlacklist != null) {
            MainUtil.walkableBlocks.clear();
            MainUtil.walkableBlocks.addAll(ConfigManager.getAdvancedConfig().walkingHeartWalkOnBlockBlacklist);
        }
        if (ConfigManager.getAdvancedConfig().standBlockGrabBlacklist != null) {
            MainUtil.standBlockGrabBlacklist.clear();
            MainUtil.standBlockGrabBlacklist.addAll(ConfigManager.getAdvancedConfig().standBlockGrabBlacklist);
        }
        if (ConfigManager.getAdvancedConfig().naturalStandUserMobBlacklist != null) {
            MainUtil.naturalStandUserMobBlacklist.clear();
            MainUtil.naturalStandUserMobBlacklist.addAll(ConfigManager.getAdvancedConfig().naturalStandUserMobBlacklist);
        }
        if (ConfigManager.getAdvancedConfig().hypnotismMobBlackList != null) {
            MainUtil.hypnotismMobBlackList.clear();
            MainUtil.hypnotismMobBlackList.addAll(ConfigManager.getAdvancedConfig().hypnotismMobBlackList);
        }
        if (ConfigManager.getAdvancedConfig().foodThatGivesBloodListV3 != null) {
            MainUtil.foodMap = MainUtil.parseFoodList(ConfigManager.getAdvancedConfig().foodThatGivesBloodListV3);
        }
    }

    public static void loadStandArrowPool() {
        StandDiscItem SDI;
        class_2960 identifier;
        class_1792 i;
        String[] split;
        if (ConfigManager.getAdvancedConfig().standArrowPoolv4 != null) {
            ModItems.STAND_ARROW_POOL.clear();
            for (String disc : ConfigManager.getAdvancedConfig().standArrowPoolv4) {
                split = disc.split(":");
                if (split.length != 2 || (i = (class_1792)class_7923.field_41178.method_10223(identifier = new class_2960(split[0], split[1]))).getClass() != StandDiscItem.class || !(i instanceof StandDiscItem)) continue;
                SDI = (StandDiscItem)i;
                if (!SDI.standPowers.isStandEnabled()) continue;
                ModItems.STAND_ARROW_POOL.add(SDI);
            }
        }
        if (ConfigManager.getAdvancedConfig().naturalStandUserMobPoolv5 != null) {
            ModItems.STAND_ARROW_POOL_FOR_MOBS.clear();
            for (String disc : ConfigManager.getAdvancedConfig().naturalStandUserMobPoolv5) {
                split = disc.split(":");
                if (split.length != 2 || (i = (class_1792)class_7923.field_41178.method_10223(identifier = new class_2960(split[0], split[1]))).getClass() != StandDiscItem.class || !(i instanceof StandDiscItem)) continue;
                SDI = (StandDiscItem)i;
                if (!SDI.standPowers.isStandEnabled()) continue;
                ModItems.STAND_ARROW_POOL_FOR_MOBS.add(SDI);
            }
        }
        if (ConfigManager.getAdvancedConfig().humanoidOnlyStandUserMobPoolv2 != null) {
            ModItems.STAND_ARROW_POOL_FOR_HUMANOID_MOBS.clear();
            if (ModItems.STAND_ARROW_POOL_FOR_MOBS != null && !ModItems.STAND_ARROW_POOL_FOR_MOBS.isEmpty()) {
                ModItems.STAND_ARROW_POOL_FOR_HUMANOID_MOBS.addAll(ModItems.STAND_ARROW_POOL_FOR_MOBS);
            }
            for (String disc : ConfigManager.getAdvancedConfig().humanoidOnlyStandUserMobPoolv2) {
                split = disc.split(":");
                if (split.length != 2 || (i = (class_1792)class_7923.field_41178.method_10223(identifier = new class_2960(split[0], split[1]))).getClass() != StandDiscItem.class || !(i instanceof StandDiscItem)) continue;
                SDI = (StandDiscItem)i;
                if (!SDI.standPowers.isStandEnabled()) continue;
                ModItems.STAND_ARROW_POOL_FOR_HUMANOID_MOBS.add(SDI);
            }
        }
        if (ConfigManager.getAdvancedConfig().standArrowSecondaryPoolv5 != null) {
            ModItems.STAND_ARROW_SECONDARY_STAND_POOL.clear();
            for (String disc : ConfigManager.getAdvancedConfig().standArrowSecondaryPoolv5) {
                split = disc.split(":");
                if (split.length != 2 || (i = (class_1792)class_7923.field_41178.method_10223(identifier = new class_2960(split[0], split[1]))).getClass() != StandDiscItem.class || !(i instanceof StandDiscItem)) continue;
                SDI = (StandDiscItem)i;
                if (!SDI.standPowers.isStandEnabled()) continue;
                ModItems.STAND_ARROW_SECONDARY_STAND_POOL.add(SDI);
            }
        }
    }

    public static void saveServerConfig() {
        ConfigManager.save(Config.getServerInstance(), serverConfigPath);
    }

    private static void loadClientConfig() {
        ClientConfig config = ConfigManager.loadClient();
        ConfigManager.validateFields(config);
        ClientConfig.updateLocal(config);
        ConfigManager.saveClientConfig();
        Roundabout.LOGGER.info("Loaded local config");
    }

    private static void loadLocalConfig() {
        Config config = ConfigManager.loadLocal();
        ConfigManager.validateFields(config);
        Config.updateLocal(config);
        ConfigManager.saveLocalConfig();
        Roundabout.LOGGER.info("Loaded local config");
    }

    private static void loadServerConfig() {
        Config config = ConfigManager.loadServer();
        ConfigManager.validateFields(config);
        Config.updateServer(config);
        Roundabout.LOGGER.info("Loaded server config");
    }

    private static void loadAdvancedConfig() {
        AdvancedConfig config = ConfigManager.loadAdvanced();
        ConfigManager.validateFields(config);
        AdvancedConfig.updateServer(config);
        ConfigManager.saveAdvacedConfig();
        Roundabout.LOGGER.info("Loaded advanced config");
    }

    public static void validateFields(Object instance) {
        ConfigManager.validateFloatFields(instance);
        ConfigManager.validateIntFields(instance);
        ConfigManager.validateBooleanFields(instance);
        ConfigManager.validateNestedFields(instance);
    }

    private static void validateFloatFields(Object instance) {
        Reflection.forEachFieldByAnnotation(instance, FloatOption.class, (field, annotation) -> {
            ConfigOptionReference reference = ConfigOptionReference.of(instance, field);
            ConfigManager.setIfNull(reference, Float.valueOf(annotation.value()));
            if (reference.floatValue().floatValue() < annotation.min()) {
                reference.floatValue(Float.valueOf(annotation.min()));
            }
            if (reference.floatValue().floatValue() > annotation.max()) {
                reference.floatValue(Float.valueOf(annotation.max()));
            }
        });
    }

    private static void validateIntFields(Object instance) {
        Reflection.forEachFieldByAnnotation(instance, IntOption.class, (field, annotation) -> {
            ConfigOptionReference reference = ConfigOptionReference.of(instance, field);
            ConfigManager.setIfNull(reference, annotation.value());
            if (reference.intValue() < annotation.min()) {
                reference.intValue(annotation.min());
            }
            if (reference.intValue() > annotation.max()) {
                reference.intValue(annotation.max());
            }
        });
    }

    private static void validateBooleanFields(Object instance) {
        Reflection.forEachFieldByAnnotation(instance, BooleanOption.class, (field, annotation) -> {
            ConfigOptionReference reference = ConfigOptionReference.of(instance, field);
            ConfigManager.setIfNull(reference, annotation.value());
        });
    }

    private static void validateNestedFields(Object instance) {
        Reflection.forEachFieldByAnnotation(instance, NestedOption.class, (field, annotation) -> {
            Object nestedOption = Reflection.accessField(field, instance, Object.class);
            if (nestedOption == null) {
                nestedOption = Reflection.newInstance(field.getType());
                Reflection.setField(field, instance, nestedOption);
            }
            ConfigManager.validateFields(nestedOption);
        });
    }

    private static void setIfNull(ConfigOptionReference reference, Object value) {
        if (reference.isValueNull()) {
            reference.setConfigValue(value);
        }
    }

    public static String serializeConfig() {
        return GSON.toJson((Object)Config.getLocalInstance());
    }

    public static void deserializeConfig(String serialized) {
        Config.updateServer((Config)GSON.fromJson(serialized, Config.class));
    }

    private static ClientConfig loadClient() {
        ClientConfig loaded = ConfigManager.loadClient(new ClientConfig(), clientConfigPath);
        ConfigManager.validateFields(loaded);
        ClientConfig.updateLocal(loaded);
        DEFAULT_CLIENT_CONFIG = loaded.clone();
        ConfigManager.saveClientConfig();
        return loaded;
    }

    private static AdvancedConfig loadAdvanced() {
        AdvancedConfig loaded = ConfigManager.loadAdvanced(new AdvancedConfig(), advancedConfigPath);
        ConfigManager.validateFields(loaded);
        AdvancedConfig.updateServer(loaded);
        DEFAULT_ADVANCED_CONFIG = loaded.clone();
        ConfigManager.saveAdvacedConfig();
        return loaded;
    }

    private static Config loadLocal() {
        Config loaded = ConfigManager.load(new Config(), localConfigPath);
        ConfigManager.validateFields(loaded);
        Config.updateLocal(loaded);
        ConfigManager.saveLocalConfig();
        return loaded;
    }

    private static Config loadServer() {
        Config loaded = ConfigManager.load(new Config(), serverConfigPath);
        ConfigManager.validateFields(loaded);
        Config.updateServer(loaded);
        DEFAULT_SERVER_CONFIG = loaded.clone();
        return loaded;
    }

    private static Config load(Config defaultConfig, Path path) {
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.createFile(path, new FileAttribute[0]);
                return defaultConfig;
            }
            try {
                String fileContent = String.join((CharSequence)System.lineSeparator(), Files.readAllLines(path));
                JsonValue hjson = JsonValue.readHjson(fileContent);
                return (Config)GSON.fromJson(hjson.toString(), Config.class);
            }
            catch (Exception e) {
                Roundabout.LOGGER.error("Failed to parse defaultConfig file, using default config");
            }
        }
        catch (IOException e) {
            Roundabout.LOGGER.error("Failed to load config", (Throwable)e);
        }
        return defaultConfig;
    }

    private static AdvancedConfig loadAdvanced(AdvancedConfig defaultConfig, Path path) {
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.createFile(path, new FileAttribute[0]);
                return defaultConfig;
            }
            try {
                String fileContent = String.join((CharSequence)System.lineSeparator(), Files.readAllLines(path));
                JsonValue hjson = JsonValue.readHjson(fileContent);
                return (AdvancedConfig)GSON.fromJson(hjson.toString(), AdvancedConfig.class);
            }
            catch (Exception e) {
                Roundabout.LOGGER.error("Failed to parse defaultConfig file, using default config");
            }
        }
        catch (IOException e) {
            Roundabout.LOGGER.error("Failed to load config", (Throwable)e);
        }
        return defaultConfig;
    }

    private static ClientConfig loadClient(ClientConfig defaultConfig, Path path) {
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.createFile(path, new FileAttribute[0]);
                return defaultConfig;
            }
            try {
                String fileContent = String.join((CharSequence)System.lineSeparator(), Files.readAllLines(path));
                JsonValue hjson = JsonValue.readHjson(fileContent);
                return (ClientConfig)GSON.fromJson(hjson.toString(), ClientConfig.class);
            }
            catch (Exception e) {
                Roundabout.LOGGER.error("Failed to parse client config file, using default config");
            }
        }
        catch (IOException e) {
            Roundabout.LOGGER.error("Failed to load config", (Throwable)e);
        }
        return defaultConfig;
    }

    public static boolean loaded() {
        return loaded;
    }

    public static void saveClientConfig() {
        ConfigManager.validateFields(ClientConfig.getLocalInstance());
        ConfigManager.saveClient(ClientConfig.getLocalInstance(), clientConfigPath);
    }

    public static void saveAdvacedConfig() {
        ConfigManager.saveAdvanced(AdvancedConfig.getInstance(), advancedConfigPath);
    }

    public static void saveLocalConfig() {
        ConfigManager.validateFields(Config.getLocalInstance());
        ConfigManager.save(Config.getLocalInstance(), localConfigPath);
    }

    private static void save(Config config, Path path) {
        try {
            Files.write(path, GSON.toJson((Object)config).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            Roundabout.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    private static void saveClient(ClientConfig config, Path path) {
        try {
            String parsed = String.join((CharSequence)System.lineSeparator(), ConfigParser.parse(config));
            Files.write(path, parsed.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            Roundabout.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    private static void saveAdvanced(AdvancedConfig config, Path path) {
        try {
            String parsed = String.join((CharSequence)System.lineSeparator(), ConfigParser.parse(config));
            Files.write(path, parsed.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            Roundabout.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public static void resetLocal() {
        Config.updateLocal(Config.getDefaultInstance().clone());
    }

    public static void resetClient() {
        ClientConfig.updateLocal(ClientConfig.getDefaultInstance().clone());
    }

    public static void resetServer() {
    }

    static {
        loaded = false;
    }
}

