/*
 * Decompiled with CFR 0.152.
 */
package net.zetalasis.hjson;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import net.zetalasis.hjson.HjsonDsf;
import net.zetalasis.hjson.HjsonOptions;
import net.zetalasis.hjson.IHjsonDsfProvider;
import net.zetalasis.hjson.JsonArray;
import net.zetalasis.hjson.JsonNumber;
import net.zetalasis.hjson.JsonObject;
import net.zetalasis.hjson.JsonString;
import net.zetalasis.hjson.JsonValue;
import net.zetalasis.hjson.ParseException;

class HjsonParser {
    private static final int MIN_BUFFER_SIZE = 10;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private final String buffer;
    private Reader reader;
    private int index;
    private int line;
    private int lineOffset;
    private int current;
    private StringBuilder captureBuffer;
    private StringBuilder peek;
    private boolean capture;
    private boolean legacyRoot;
    private static final int MAX_DEPTH = 1000;
    private IHjsonDsfProvider[] dsfProviders;

    HjsonParser(String string, HjsonOptions options) {
        this.buffer = string;
        this.reset();
        if (options != null) {
            this.dsfProviders = options.getDsfProviders();
            this.legacyRoot = options.getParseLegacyRoot();
        } else {
            this.dsfProviders = new IHjsonDsfProvider[0];
            this.legacyRoot = true;
        }
    }

    HjsonParser(Reader reader, HjsonOptions options) throws IOException {
        this(HjsonParser.readToEnd(reader), options);
    }

    static String readToEnd(Reader reader) throws IOException {
        int n;
        char[] part = new char[8192];
        StringBuilder sb = new StringBuilder();
        while ((n = reader.read(part, 0, part.length)) != -1) {
            sb.append(part, 0, n);
        }
        return sb.toString();
    }

    void reset() {
        this.current = 0;
        this.lineOffset = 0;
        this.index = 0;
        this.line = 1;
        this.peek = new StringBuilder();
        this.reader = new StringReader(this.buffer);
        this.capture = false;
        this.captureBuffer = null;
    }

    JsonValue parse() throws IOException {
        this.read();
        this.skipWhiteSpace();
        if (this.legacyRoot) {
            switch (this.current) {
                case 91: 
                case 123: {
                    return this.checkTrailing(this.readValue());
                }
            }
            try {
                return this.checkTrailing(this.readObject(true));
            }
            catch (Exception exception) {
                this.reset();
                this.read();
                this.skipWhiteSpace();
                try {
                    return this.checkTrailing(this.readValue());
                }
                catch (Exception exception2) {
                    throw exception;
                }
            }
        }
        return this.checkTrailing(this.readValue());
    }

    JsonValue checkTrailing(JsonValue v) throws ParseException, IOException {
        this.skipWhiteSpace();
        if (!this.isEndOfText()) {
            throw this.error("Extra characters in input: " + this.current);
        }
        return v;
    }

    private JsonValue readValue() throws IOException, ParseException {
        return this.readValue(0);
    }

    private JsonValue readValue(int depth) throws IOException, ParseException {
        if (depth > 1000) {
            throw this.error("The passed json has exhausted the depth supported of 1000.");
        }
        switch (this.current) {
            case 34: 
            case 39: {
                return this.readString();
            }
            case 91: {
                return this.readArray(depth + 1);
            }
            case 123: {
                return this.readObject(false, depth + 1);
            }
        }
        return this.readTfnns();
    }

    private JsonValue readTfnns() throws IOException {
        StringBuilder value = new StringBuilder();
        int first = this.current;
        if (JsonValue.isPunctuatorChar(first)) {
            throw this.error("Found a punctuator character '" + (char)first + "' when expecting a quoteless string (check your syntax)");
        }
        value.append((char)this.current);
        while (true) {
            boolean isEol;
            this.read();
            boolean bl = isEol = this.current < 0 || this.current == 13 || this.current == 10;
            if (isEol || this.current == 44 || this.current == 125 || this.current == 93 || this.current == 35 || this.current == 47 && (this.peek() == 47 || this.peek() == 42)) {
                switch (first) {
                    case 102: 
                    case 110: 
                    case 116: {
                        String svalue = value.toString().trim();
                        if (svalue.equals("false")) {
                            return JsonValue.FALSE;
                        }
                        if (svalue.equals("null")) {
                            return JsonValue.NULL;
                        }
                        if (!svalue.equals("true")) break;
                        return JsonValue.TRUE;
                    }
                    default: {
                        JsonValue n;
                        if (first != 45 && (first < 48 || first > 57) || (n = HjsonParser.tryParseNumber(value, false)) == null) break;
                        return n;
                    }
                }
                if (isEol) {
                    return HjsonDsf.parse(this.dsfProviders, value.toString().trim());
                }
            }
            value.append((char)this.current);
        }
    }

    private JsonArray readArray(int depth) throws IOException {
        JsonArray array;
        block3: {
            this.read();
            array = new JsonArray();
            this.skipWhiteSpace();
            if (this.readIf(']')) {
                return array;
            }
            do {
                this.skipWhiteSpace();
                array.add(this.readValue(depth));
                this.skipWhiteSpace();
                if (this.readIf(',')) {
                    this.skipWhiteSpace();
                }
                if (this.readIf(']')) break block3;
            } while (!this.isEndOfText());
            throw this.error("End of input while parsing an array (did you forget a closing ']'?)");
        }
        return array;
    }

    private JsonObject readObject(boolean objectWithoutBraces) throws IOException {
        return this.readObject(objectWithoutBraces, 0);
    }

    private JsonObject readObject(boolean objectWithoutBraces, int depth) throws IOException, ParseException {
        if (!objectWithoutBraces) {
            this.read();
        }
        JsonObject object = new JsonObject();
        this.skipWhiteSpace();
        while (true) {
            if (objectWithoutBraces) {
                if (this.isEndOfText()) {
                    break;
                }
            } else {
                if (this.isEndOfText()) {
                    throw this.error("End of input while parsing an object (did you forget a closing '}'?)");
                }
                if (this.readIf('}')) break;
            }
            String name = this.readName();
            this.skipWhiteSpace();
            if (!this.readIf(':')) {
                throw this.expected("':'");
            }
            this.skipWhiteSpace();
            object.add(name, this.readValue(depth));
            this.skipWhiteSpace();
            if (!this.readIf(',')) continue;
            this.skipWhiteSpace();
        }
        return object;
    }

    private String readName() throws IOException {
        if (this.current == 34 || this.current == 39) {
            return this.readStringInternal(false);
        }
        StringBuilder name = new StringBuilder();
        int space = -1;
        int start = this.index;
        while (true) {
            if (this.current == 58) {
                if (name.length() == 0) {
                    throw this.error("Found ':' but no key name (for an empty key name use quotes)");
                }
                if (space >= 0 && space != name.length()) {
                    this.index = start + space;
                    throw this.error("Found whitespace in your key name (use quotes to include)");
                }
                return name.toString();
            }
            if (HjsonParser.isWhiteSpace(this.current)) {
                if (space < 0) {
                    space = name.length();
                }
            } else {
                if (this.current < 32) {
                    throw this.error("Name is not closed");
                }
                if (JsonValue.isPunctuatorChar(this.current)) {
                    throw this.error("Found '" + (char)this.current + "' where a key name was expected (check your syntax or use quotes if the key name includes {}[],: or whitespace)");
                }
                name.append((char)this.current);
            }
            this.read();
        }
    }

    private String readMlString() throws IOException {
        StringBuilder sb = new StringBuilder();
        int triple = 0;
        int indent = this.index - this.lineOffset - 4;
        while (HjsonParser.isWhiteSpace(this.current) && this.current != 10) {
            this.read();
        }
        if (this.current == 10) {
            this.read();
            this.skipIndent(indent);
        }
        while (true) {
            if (this.current < 0) {
                throw this.error("Bad multiline string");
            }
            if (this.current == 39) {
                this.read();
                if (++triple != 3) continue;
                if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '\n') {
                    sb.deleteCharAt(sb.length() - 1);
                }
                return sb.toString();
            }
            while (triple > 0) {
                sb.append('\'');
                --triple;
            }
            if (this.current == 10) {
                sb.append('\n');
                this.read();
                this.skipIndent(indent);
                continue;
            }
            if (this.current != 13) {
                sb.append((char)this.current);
            }
            this.read();
        }
    }

    private void skipIndent(int indent) throws IOException {
        while (indent-- > 0 && HjsonParser.isWhiteSpace(this.current) && this.current != 10) {
            this.read();
        }
    }

    private JsonValue readString() throws IOException {
        return new JsonString(this.readStringInternal(true));
    }

    private String readStringInternal(boolean allowML) throws IOException {
        int exitCh = this.current;
        this.read();
        this.startCapture();
        while (this.current != exitCh) {
            if (this.current == 92) {
                this.readEscape();
                continue;
            }
            if (this.current < 32) {
                throw this.expected("valid string character");
            }
            this.read();
        }
        String string = this.endCapture();
        this.read();
        if (allowML && exitCh == 39 && this.current == 39 && string.length() == 0) {
            this.read();
            return this.readMlString();
        }
        return string;
    }

    private void readEscape() throws IOException {
        this.pauseCapture();
        this.read();
        switch (this.current) {
            case 34: 
            case 39: 
            case 47: 
            case 92: {
                this.captureBuffer.append((char)this.current);
                break;
            }
            case 98: {
                this.captureBuffer.append('\b');
                break;
            }
            case 102: {
                this.captureBuffer.append('\f');
                break;
            }
            case 110: {
                this.captureBuffer.append('\n');
                break;
            }
            case 114: {
                this.captureBuffer.append('\r');
                break;
            }
            case 116: {
                this.captureBuffer.append('\t');
                break;
            }
            case 117: {
                char[] hexChars = new char[4];
                for (int i = 0; i < 4; ++i) {
                    this.read();
                    if (!this.isHexDigit()) {
                        throw this.expected("hexadecimal digit");
                    }
                    hexChars[i] = (char)this.current;
                }
                this.captureBuffer.append((char)Integer.parseInt(new String(hexChars), 16));
                break;
            }
            default: {
                throw this.expected("valid escape sequence");
            }
        }
        this.capture = true;
        this.read();
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    static JsonValue tryParseNumber(StringBuilder value, boolean stopAtNext) throws IOException {
        char ch;
        char first;
        int idx = 0;
        int len = value.length();
        if (idx < len && value.charAt(idx) == '-') {
            ++idx;
        }
        if (idx >= len) {
            return null;
        }
        if (!HjsonParser.isDigit(first = value.charAt(idx++))) {
            return null;
        }
        if (first == '0' && idx < len && HjsonParser.isDigit(value.charAt(idx))) {
            return null;
        }
        while (idx < len && HjsonParser.isDigit(value.charAt(idx))) {
            ++idx;
        }
        if (idx < len && value.charAt(idx) == '.') {
            if (++idx >= len || !HjsonParser.isDigit(value.charAt(idx++))) {
                return null;
            }
            while (idx < len && HjsonParser.isDigit(value.charAt(idx))) {
                ++idx;
            }
        }
        if (idx < len && Character.toLowerCase(value.charAt(idx)) == 'e') {
            if (++idx < len && (value.charAt(idx) == '+' || value.charAt(idx) == '-')) {
                ++idx;
            }
            if (idx >= len || !HjsonParser.isDigit(value.charAt(idx++))) {
                return null;
            }
            while (idx < len && HjsonParser.isDigit(value.charAt(idx))) {
                ++idx;
            }
        }
        int last = idx;
        while (idx < len && HjsonParser.isWhiteSpace(value.charAt(idx))) {
            ++idx;
        }
        boolean foundStop = false;
        if (idx < len && stopAtNext && ((ch = value.charAt(idx)) == ',' || ch == '}' || ch == ']' || ch == '#' || ch == '/' && len > idx + 1 && (value.charAt(idx + 1) == '/' || value.charAt(idx + 1) == '*'))) {
            foundStop = true;
        }
        if (idx < len && !foundStop) {
            return null;
        }
        return new JsonNumber(Double.parseDouble(value.substring(0, last)));
    }

    static JsonValue tryParseNumber(String value, boolean stopAtNext) throws IOException {
        return HjsonParser.tryParseNumber(new StringBuilder(value), stopAtNext);
    }

    private boolean readIf(char ch) throws IOException {
        if (this.current != ch) {
            return false;
        }
        this.read();
        return true;
    }

    private void skipWhiteSpace() throws IOException {
        while (!this.isEndOfText()) {
            while (this.isWhiteSpace()) {
                this.read();
            }
            if (this.current == 35 || this.current == 47 && this.peek() == 47) {
                do {
                    this.read();
                } while (this.current >= 0 && this.current != 10);
                continue;
            }
            if (this.current != 47 || this.peek() != 42) break;
            this.read();
            do {
                this.read();
            } while (this.current >= 0 && (this.current != 42 || this.peek() != 47));
            this.read();
            this.read();
        }
    }

    private int peek(int idx) throws IOException {
        while (idx >= this.peek.length()) {
            int c = this.reader.read();
            if (c < 0) {
                return c;
            }
            this.peek.append((char)c);
        }
        return this.peek.charAt(idx);
    }

    private int peek() throws IOException {
        return this.peek(0);
    }

    private boolean read() throws IOException {
        if (this.current == 10) {
            ++this.line;
            this.lineOffset = this.index;
        }
        if (this.peek.length() > 0) {
            this.current = this.peek.charAt(0);
            this.peek.deleteCharAt(0);
        } else {
            this.current = this.reader.read();
        }
        if (this.current < 0) {
            return false;
        }
        ++this.index;
        if (this.capture) {
            this.captureBuffer.append((char)this.current);
        }
        return true;
    }

    private void startCapture() {
        if (this.captureBuffer == null) {
            this.captureBuffer = new StringBuilder();
        }
        this.capture = true;
        this.captureBuffer.append((char)this.current);
    }

    private void pauseCapture() {
        int len = this.captureBuffer.length();
        if (len > 0) {
            this.captureBuffer.deleteCharAt(len - 1);
        }
        this.capture = false;
    }

    private String endCapture() {
        String captured;
        this.pauseCapture();
        if (this.captureBuffer.length() > 0) {
            captured = this.captureBuffer.toString();
            this.captureBuffer.setLength(0);
        } else {
            captured = "";
        }
        this.capture = false;
        return captured;
    }

    private ParseException expected(String expected) {
        if (this.isEndOfText()) {
            return this.error("Unexpected end of input");
        }
        return this.error("Expected " + expected);
    }

    private ParseException error(String message) {
        int column = this.index - this.lineOffset;
        int offset = this.isEndOfText() ? this.index : this.index - 1;
        return new ParseException(message, offset, this.line, column - 1);
    }

    static boolean isWhiteSpace(int ch) {
        return ch == 32 || ch == 9 || ch == 10 || ch == 13;
    }

    private boolean isWhiteSpace() {
        return HjsonParser.isWhiteSpace((char)this.current);
    }

    private boolean isHexDigit() {
        return this.current >= 48 && this.current <= 57 || this.current >= 97 && this.current <= 102 || this.current >= 65 && this.current <= 70;
    }

    private boolean isEndOfText() {
        return this.current == -1;
    }
}

