/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.compilers.utils;

import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.compilers.utils.CompileException;
import io.github.ngspace.hudder.compilers.utils.HudderJavaScriptWrapFactory;
import io.github.ngspace.hudder.compilers.utils.IScriptingLanguageEngine;
import io.github.ngspace.hudder.utils.ObjectWrapper;
import java.io.IOException;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;

public class JavaScriptEngine
implements IScriptingLanguageEngine {
    protected static class_310 mc = class_310.method_1551();
    Context cx = Context.enter();
    ScriptableObject scope;

    public JavaScriptEngine() {
        this.cx.setWrapFactory(new HudderJavaScriptWrapFactory());
        this.cx.setInterpretedMode(false);
        this.scope = this.cx.initSafeStandardObjects();
        JavaScriptIO JavaScriptIO2 = new JavaScriptIO();
        this.insertObject(JavaScriptIO2, "console");
        this.insertObject(JavaScriptIO2, "hudder");
    }

    @Override
    public void bindFunction(final IScriptingLanguageEngine.ScriptFunction function, String ... names) {
        BaseFunction func = new BaseFunction(this){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ JavaScriptEngine this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object call(Context con, Scriptable scope, Scriptable thisObj, Object[] args) {
                try {
                    ObjectWrapper[] vals = new ObjectWrapper[args.length];
                    for (int i = 0; i < args.length; ++i) {
                        vals[i] = new JavaScriptValue(this.this$0, args[i]);
                    }
                    return this.this$0.cx.getWrapFactory().wrap(this.this$0.cx, scope, function.exec(vals), null);
                }
                catch (Exception e) {
                    throw new WrappedException(e);
                }
            }
        };
        for (String name : names) {
            this.scope.put(name, (Scriptable)this.scope, (Object)func);
        }
    }

    @Override
    public void bindConsumer(IScriptingLanguageEngine.ScriptConsumer consumer, String ... names) {
        this.bindFunction(e -> {
            consumer.exec(e);
            return Undefined.instance;
        }, names);
    }

    @Override
    public ObjectWrapper readVariable(String name) {
        Object val = this.scope.get(name, (Scriptable)this.scope);
        if (val == Scriptable.NOT_FOUND) {
            return null;
        }
        return new JavaScriptValue(this, val);
    }

    @Override
    public ObjectWrapper readVariableSafe(String name, Object t) {
        Object val = this.scope.get(name, (Scriptable)this.scope);
        if (val == null || val == Scriptable.NOT_FOUND) {
            return new JavaScriptValue(this, t);
        }
        return new JavaScriptValue(this, val);
    }

    @Override
    public void evaluateCode(String code, String name) {
        this.cx.evaluateString(this.scope, code, name, 1, null);
    }

    private void insertObject(Object obj, String name) {
        Object wrappedObj = Context.javaToJS(obj, this.scope);
        ScriptableObject.defineProperty(this.scope, name, wrappedObj, 5);
    }

    @Override
    public ObjectWrapper callFunction(String name, String ... args) throws IOException {
        Object func = this.scope.get(name, (Scriptable)this.scope);
        if (func instanceof Function) {
            Function f = (Function)func;
            return new JavaScriptValue(this, f.call(this.cx, this.scope, this.scope, args));
        }
        throw new IOException(name + " is not a function or is not defined!");
    }

    @Override
    public ObjectWrapper callFunctionSafe(String name, Object defualt, String ... args) throws IOException {
        Object func = this.scope.get(name, (Scriptable)this.scope);
        if (func == null || func == Scriptable.NOT_FOUND) {
            return new JavaScriptValue(this, defualt);
        }
        if (func instanceof Function) {
            Function f = (Function)func;
            return new JavaScriptValue(this, f.call(this.cx, this.scope, this.scope, args));
        }
        throw new IOException(name + " is not a function!");
    }

    @Override
    public void close() throws IOException {
        this.cx.close();
    }

    @Override
    public CompileException processException(Exception e) {
        if (e instanceof RhinoException) {
            String string;
            RhinoException ex = (RhinoException)e;
            if (ex instanceof WrappedException) {
                WrappedException wex = (WrappedException)ex;
                string = wex.getWrappedException().getMessage();
            } else {
                string = ex.getMessage();
            }
            String msg = "\u00a74" + string + "\n\u00a7bat Line " + ex.lineNumber() + " at col " + ex.columnNumber();
            return new CompileException(msg, -1, -1, ex);
        }
        if (e instanceof CompileException) {
            CompileException ex = (CompileException)e;
            return ex;
        }
        WrappedException ex = new WrappedException(e);
        String msg = "\u00a74" + e.getMessage() + "\n\u00a7bat Line " + ex.lineNumber() + " at col " + ex.columnNumber();
        return new CompileException(msg, -1, -1, ex);
    }

    public static class JavaScriptIO {
        public void log(Object str) {
            Hudder.log(str);
        }

        public void warn(Object str) {
            Hudder.warn(str);
        }

        public void error(Object str) {
            Hudder.error(str);
        }

        public void debug(Object str) {
            Hudder.debug(str);
        }

        public void alert(Object str) {
            Hudder.alert(str);
        }

        public void showToast(String title, String content) {
            Hudder.showToast((class_2561)class_2561.method_43470((String)title).method_27692(class_124.field_1067), (class_2561)class_2561.method_43470((String)content));
        }
    }

    private class JavaScriptValue
    implements ObjectWrapper {
        private Object value;

        private JavaScriptValue(JavaScriptEngine javaScriptEngine, Object value) {
            this.value = value;
            if (value instanceof NativeJavaObject) {
                NativeJavaObject o = (NativeJavaObject)value;
                this.value = o.unwrap();
            }
        }

        @Override
        public Object get() throws CompileException {
            return this.value == Undefined.instance ? null : this.value;
        }

        @Override
        public String asString() {
            return Context.toString(this.value);
        }

        @Override
        public double asDouble() {
            return Context.toNumber(this.value);
        }

        @Override
        public boolean asBoolean() {
            return Context.toBoolean(this.value);
        }

        @Override
        public Object[] asArray() {
            return ((NativeArray)this.value).toArray();
        }

        @Override
        public String toString() {
            return this.value.toString();
        }

        @Override
        public <T> T asType(Class<T> clazz) throws CompileException {
            return clazz.cast(this.get());
        }
    }
}

