/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.utils;

import io.github.ngspace.hudder.utils.CachedReader;
import io.github.ngspace.hudder.utils.ERunnable;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import javax.imageio.ImageIO;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import org.apache.commons.io.FileUtils;

public class HudFileUtils {
    private static CachedReader reader = new CachedReader();
    private static List<ERunnable<IOException>> reloadResourcesListeners = new ArrayList<ERunnable<IOException>>();
    public static final String FABRIC_CONFIG_FOLDER = FabricLoader.getInstance().getConfigDir().toString();
    public static final String FOLDER = FABRIC_CONFIG_FOLDER + File.separator + "hudder" + File.separator;
    public static final String ASSETS = "/assets/hudder/";
    public static final String[] DEFAULT_HUDS = new String[]{"tutorial", "hand", "armorside", "hud", "basic", "hud.js", "hotbar.js", "worldtime.js"};
    public static final String[] DEFAULT_TEXTURES = new String[]{"pointer.png", "selection.png"};

    private HudFileUtils() {
    }

    public static String readFile(String file) {
        return reader.getCachedFileAsString(HudFileUtils.sanitize(FOLDER + file));
    }

    public static byte[] readFileBytes(String file) {
        return reader.getCachedFile(HudFileUtils.sanitize(FOLDER + file));
    }

    public static String readFileWithoutCache(String file) throws IOException {
        return new String(HudFileUtils.reader.reader.readFile(new File(HudFileUtils.sanitize(FOLDER + file))));
    }

    public static String readFileUnsanitized(File file) throws IOException {
        return new String(HudFileUtils.reader.reader.readFile(file));
    }

    public static void addReloadResourcesListener(ERunnable<IOException> listener) {
        reloadResourcesListeners.add(listener);
    }

    public static String sanitize(String f) throws SecurityException {
        if (!new File(f).getAbsolutePath().startsWith(FOLDER)) {
            HudFileUtils.throwError(f);
        }
        int j = 0;
        int k = 0;
        for (int i = 0; i < f.length(); ++i) {
            char c = f.charAt(i);
            if (c == '.') {
                ++j;
                continue;
            }
            if (c == '/' || c == '\\') {
                if (j == 2 && k == 0) {
                    HudFileUtils.throwError(f);
                }
                k = 0;
                continue;
            }
            j = 0;
            ++k;
        }
        return f;
    }

    private static final void throwError(String file) {
        throw new SecurityException(file + " (No such file or directory)");
    }

    public static boolean exists(String file) {
        if ("".equals(file)) {
            return false;
        }
        return new File(HudFileUtils.sanitize(FOLDER + file)).exists();
    }

    public static void makeDefaultHud() {
        File dest;
        for (String file : DEFAULT_HUDS) {
            dest = new File(FOLDER, file);
            if (dest.exists()) continue;
            try {
                FileUtils.copyURLToFile((URL)HudFileUtils.class.getResource("/assets/hudder/huds/" + file), (File)dest);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!new File(FOLDER + "Textures").exists()) {
            new File(FOLDER + "Textures").mkdir();
        }
        for (String file : DEFAULT_TEXTURES) {
            dest = new File(FOLDER + "Textures", file);
            if (dest.exists()) continue;
            try {
                FileUtils.copyURLToFile((URL)HudFileUtils.class.getResource("/assets/hudder/Textures/" + file), (File)dest);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class_2960 getTexture(String filename) {
        HudFileUtils.sanitize(FOLDER + filename);
        return class_2960.method_60655((String)"hudder", (String)String.valueOf(HudFileUtils.getCRC32Checksum(filename.trim().toLowerCase())));
    }

    private static long getCRC32Checksum(String str) {
        return HudFileUtils.getCRC32Checksum(str.getBytes());
    }

    private static long getCRC32Checksum(byte[] bytes) {
        CRC32 crc32 = new CRC32();
        crc32.update(bytes, 0, bytes.length);
        return crc32.getValue();
    }

    public static void reloadResources() throws IOException {
        reader.clearCache();
        HudFileUtils.loadResources(new File(FOLDER), "");
        for (ERunnable<IOException> listener : reloadResourcesListeners) {
            listener.run();
        }
    }

    public static void loadResources(File folder, String prefix) throws IOException {
        for (File resource : folder.listFiles()) {
            String path = prefix + ("".equals(prefix) ? "" : "/") + resource.getName();
            if (resource.isDirectory()) {
                HudFileUtils.loadResources(resource, path);
                continue;
            }
            try {
                BufferedImage image = ImageIO.read(resource);
                if (image != null) {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)image, "PNG", output);
                    reader.loadImageToCache(new ByteArrayInputStream(output.toByteArray()), HudFileUtils.getTexture(path));
                    continue;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            reader.loadFileToCache(resource);
        }
    }

    public static boolean imageLoaded(class_2960 id) {
        return HudFileUtils.reader.savedImages.containsKey(id);
    }
}

