/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.v2runtime.values.constants;

import io.github.ngspace.hudder.compilers.abstractions.AV2Compiler;
import io.github.ngspace.hudder.compilers.utils.CompileException;
import io.github.ngspace.hudder.v2runtime.values.AV2Value;

public class V2Number
extends AV2Value {
    double doubleVal;

    public V2Number(String value, int line, int charpos, AV2Compiler compiler) {
        super(line, charpos, value, compiler);
        this.doubleVal = value.startsWith("0x") || value.startsWith("#") ? (double)Long.decode(value).longValue() : Double.parseDouble(value);
    }

    @Override
    public Double get() throws CompileException {
        return this.doubleVal;
    }

    @Override
    public boolean asBoolean() throws CompileException {
        throw new CompileException(V2Number.invalidTypeMessage("Boolean", this.value, 0.0), this.line, this.charpos);
    }

    @Override
    public double asDouble() throws CompileException {
        return this.get();
    }

    @Override
    public int asInt() throws CompileException {
        return this.get().intValue();
    }

    @Override
    public String asString() throws CompileException {
        throw new CompileException(V2Number.invalidTypeMessage("String", this.value, 0.0), this.line, this.charpos);
    }

    @Override
    public void setValue(AV2Compiler compiler, Object value) throws CompileException {
        throw new CompileException("Can't change the value of a number constant", this.line, this.charpos);
    }

    @Override
    public boolean isConstant() throws CompileException {
        return true;
    }
}

