/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.utils.testing;

import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.compilers.abstractions.ATextCompiler;
import io.github.ngspace.hudder.compilers.abstractions.AV2Compiler;
import io.github.ngspace.hudder.main.config.HudderConfig;
import io.github.ngspace.hudder.v2runtime.V2Runtime;
import java.util.HashMap;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class HudderUnitTest {
    public final ATextCompiler compiler;
    public final String texttocompile;
    public final String expectation;

    public HudderUnitTest(String texttocompile, ATextCompiler compiler, String topleftexpectation) {
        this.compiler = compiler;
        this.texttocompile = texttocompile;
        this.expectation = topleftexpectation.replace('&', '\u00a7');
    }

    public HudderUnitTestResult test(HudderConfig info) {
        String text = null;
        Hudder.log("Running unit test: " + this.texttocompile);
        try {
            ATextCompiler aTextCompiler = this.compiler;
            if (aTextCompiler instanceof AV2Compiler) {
                AV2Compiler v2comp = (AV2Compiler)aTextCompiler;
                v2comp.runtimes = new HashMap<String, V2Runtime>();
                v2comp.tempVariables = new HashMap<String, Object>();
            }
            ATextCompiler.variables.clear();
            text = this.compiler.compile((HudderConfig)info, (String)this.texttocompile, (String)"Unit Tests").TopLeftText;
        }
        catch (Exception e) {
            e.printStackTrace();
            text = e.getMessage();
        }
        return new HudderUnitTestResult(this.expectation.equals(text), this.expectation.replaceAll("(^ )|( $)", "~"), text.replaceAll("(^ )|( $)", "~"));
    }

    public static class HudderUnitTestResult {
        public final boolean isSucessful;
        public final String expectation;
        public final String result;

        public HudderUnitTestResult(boolean isSucessful, String expectation, String result) {
            this.isSucessful = isSucessful;
            this.expectation = expectation;
            this.result = result;
        }

        public class_5250 toText(String name) {
            class_5250 message = class_2561.method_43470((String)(name + ": ")).method_54663(1024508).method_10852((class_2561)class_2561.method_43470((String)(this.isSucessful ? "Passed" : "Failed")).method_54663(this.isSucessful ? 1048383 : 0xFF0000));
            Hudder.log("Test name: " + name);
            Hudder.log("Expectation: " + this.expectation);
            Hudder.log("Result: " + this.result);
            Hudder.log("Success: " + this.isSucessful);
            Hudder.log("");
            if (!this.isSucessful) {
                message.method_10852((class_2561)this.getFailureMessage());
            }
            return message;
        }

        public class_5250 getFailureMessage() {
            class_5250 message = class_2561.method_43470((String)"");
            message.method_10852((class_2561)class_2561.method_43470((String)"\n  Expected:\n").method_54663(3327));
            message.method_10852((class_2561)class_2561.method_43470((String)("    " + this.expectation.replace("\n", "\n    "))).method_54663(0xFFFFFF));
            message.method_10852((class_2561)class_2561.method_43470((String)"\n  Got:\n").method_54663(3327));
            message.method_10852((class_2561)class_2561.method_43470((String)("    " + this.result.replace("\n", "\n    "))).method_54663(0xFFFFFF));
            return message;
        }
    }
}

