/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.v2runtime.runtime_elements;

import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.compilers.abstractions.AV2Compiler;
import io.github.ngspace.hudder.compilers.utils.CompileException;
import io.github.ngspace.hudder.compilers.utils.CompileState;
import io.github.ngspace.hudder.main.config.HudderConfig;
import io.github.ngspace.hudder.v2runtime.V2Runtime;
import io.github.ngspace.hudder.v2runtime.methods.IMethod;
import io.github.ngspace.hudder.v2runtime.runtime_elements.AV2RuntimeElement;
import io.github.ngspace.hudder.v2runtime.values.AV2Value;
import java.util.Arrays;
import net.minecraft.class_124;
import net.minecraft.class_2561;

public class MethodV2RuntimeElement
extends AV2RuntimeElement {
    private AV2Value[] values = new AV2Value[0];
    private String type;
    private AV2Compiler compiler;
    private HudderConfig info;
    private IMethod method;
    private int line;
    private int charpos;

    public MethodV2RuntimeElement(String[] args, AV2Compiler compiler, HudderConfig info, V2Runtime runtime, int line, int charpos) throws CompileException {
        this.compiler = compiler;
        this.info = info;
        this.type = args[0];
        for (int i = 1; i < args.length; ++i) {
            this.values = Arrays.copyOf(this.values, this.values.length + 1);
            this.values[this.values.length - 1] = compiler.getV2Value(runtime, args[i], line, charpos);
        }
        this.method = compiler.methodHandler.getMethodFromName(this.type);
        if (this.method.isDeprecated(this.type)) {
            Hudder.showWarningToast((class_2561)class_2561.method_43470((String)(this.type + " method is Deprecated!")).method_27692(class_124.field_1067), (class_2561)class_2561.method_43470((String)("\u00a7a" + this.method.getDeprecationWarning(this.type))));
        }
        this.line = line;
        this.charpos = charpos;
    }

    @Override
    public boolean execute(CompileState meta, StringBuilder builder) throws CompileException {
        this.method.invoke(this.info, meta, this.compiler, this.type, this.line, this.charpos, this.values);
        return true;
    }
}

