/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.v2runtime.values.modifiable;

import io.github.ngspace.hudder.compilers.abstractions.AV2Compiler;
import io.github.ngspace.hudder.compilers.utils.CompileException;
import io.github.ngspace.hudder.v2runtime.V2Runtime;
import io.github.ngspace.hudder.v2runtime.values.AV2Value;

public class V2DynamicVar
extends AV2Value {
    private V2Runtime runtime;

    public V2DynamicVar(String value, V2Runtime runtime, int line, int charpos) {
        super(line, charpos, value.toLowerCase(), runtime.compiler);
        this.runtime = runtime;
    }

    @Override
    public Object get() throws CompileException {
        return this.runtime.getVariable(this.value);
    }

    @Override
    public boolean hasValue() {
        return this.runtime.getScoped(this.value) != null || this.compiler.get(this.value) != null;
    }

    @Override
    public void setValue(AV2Compiler compiler, Object value) throws CompileException {
        compiler.put(this.value, value);
    }

    @Override
    public boolean isConstant() throws CompileException {
        return false;
    }

    @Override
    public double asDouble() throws CompileException {
        if (!this.hasValue()) {
            throw new CompileException("\"" + this.value + "\" has no set value!", this.line, this.charpos);
        }
        return super.asDouble();
    }
}

