/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.toms_mobs.util;

import de.tomalbrc.bil.core.holder.entity.living.LivingEntityHolder;
import de.tomalbrc.bil.core.holder.wrapper.Bone;
import de.tomalbrc.bil.core.holder.wrapper.DisplayWrapper;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.core.model.Node;
import de.tomalbrc.bil.core.model.Pose;
import de.tomalbrc.bil.util.Utils;
import de.tomalbrc.toms_mobs.mixins.LivingEntityAccessor;
import eu.pb4.polymer.virtualentity.api.elements.InteractionElement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2781;
import net.minecraft.class_2940;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_5134;
import net.minecraft.class_8042;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ElephantHolder<T extends class_1309>
extends LivingEntityHolder<T> {
    public ElephantHolder(T parent, Model model) {
        super(parent, model);
    }

    public void updateElement(class_3222 serverPlayer, DisplayWrapper<?> display, @Nullable Pose pose) {
        display.element().setYaw(((class_1309)this.parent).method_36454());
        super.updateElement(serverPlayer, display, pose);
    }

    @Nullable
    private Node getRotationParent(Node node) {
        for (Node currentNode = node; currentNode != null; currentNode = currentNode.parent()) {
            if (!currentNode.headTag()) continue;
            return currentNode;
        }
        return null;
    }

    protected void applyPose(class_3222 serverPlayer, Pose pose, DisplayWrapper<?> display) {
        boolean isDead;
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.translate((Vector3fc)pose.readOnlyTranslation().sub(0.0f, ((class_1309)this.parent).method_17682() / this.entityScale, 0.0f, new Vector3f()));
        matrix4f.rotate(pose.readOnlyLeftRotation());
        matrix4f.scale((Vector3fc)new Vector3f(1.0f));
        matrix4f.rotate(pose.readOnlyRightRotation());
        Node node = this.getRotationParent(display.node());
        boolean isHead = node != null;
        boolean bl = isDead = ((class_1309)this.parent).field_6213 > 0;
        if (isHead) {
            float y = (float)Math.PI / 180 * class_3532.method_17821((float)0.5f, (float)(-((class_1309)this.parent).field_6259 + ((class_1309)this.parent).field_6220), (float)(-((class_1309)this.parent).field_6241 + ((class_1309)this.parent).field_6283));
            float x = (float)Math.PI / 180 * class_3532.method_16439((float)0.5f, (float)((class_1309)this.parent).field_6004, (float)((class_1309)this.parent).method_36455());
            Vector3f pivotOffset = node.transform().origin().get(new Vector3f()).mul(1.0f, 0.0f, 1.0f);
            matrix4f.translateLocal((Vector3fc)pivotOffset);
            matrix4f.rotateLocalX(x);
            matrix4f.rotateLocalY(y);
            matrix4f.translateLocal((Vector3fc)pivotOffset.negate());
        }
        if (isDead) {
            matrix4f.translateLocal(0.0f, ((class_1309)this.parent).method_17682(), 0.0f);
            matrix4f.rotateLocalZ(-this.deathAngle * 1.5707964f);
            matrix4f.translateLocal(0.0f, -((class_1309)this.parent).method_17682(), 0.0f);
        }
        matrix4f.scaleLocal(this.entityScale);
        matrix4f.scale(pose.readOnlyScale());
        display.element().setTransformation(serverPlayer, matrix4f);
        display.element().startInterpolationIfDirty(serverPlayer);
    }

    protected void startWatchingExtraPackets(class_3244 player, Consumer<class_2596<class_2602>> consumer) {
        class_1324 health;
        super.startWatchingExtraPackets(player, consumer);
        ArrayList<class_1324> attributeInstances = new ArrayList<class_1324>();
        class_1324 cameraDist = ((class_1309)this.parent).method_5996(class_5134.field_59674);
        if (cameraDist != null) {
            attributeInstances.add(cameraDist);
        }
        if ((health = ((class_1309)this.parent).method_5996(class_5134.field_23716)) != null) {
            attributeInstances.add(health);
        }
        class_1324 scaleAttr = new class_1324(class_5134.field_47760, instance -> {});
        scaleAttr.method_6192(((class_1309)this.parent).method_6109() ? 1.795 : 1.449);
        attributeInstances.add(scaleAttr);
        class_2781 attributesPacket = new class_2781(this.getVehicleId(), attributeInstances);
        consumer.accept((class_2596<class_2602>)attributesPacket);
    }

    public int getVehicleId() {
        return this.collisionElement.getEntityId();
    }

    public int getDisplayVehicleId() {
        return this.getVehicleId();
    }

    public void onDimensionsUpdated(class_4048 dimensions) {
        this.updateEntityScale(this.scale);
        this.dimensions = dimensions;
        this.updateCullingBox();
        class_1324 attributeInstance = new class_1324(class_5134.field_47760, instance -> {});
        attributeInstance.method_6192(((class_1309)this.parent).method_6109() ? 1.795 : 1.449);
        class_2781 attributesPacket = new class_2781(this.collisionElement.getEntityId(), List.of(attributeInstance));
        this.sendPacket((class_2596)attributesPacket);
        int size = Utils.toSlimeSize((float)Math.min(dimensions.comp_2185(), dimensions.comp_2186()));
        this.collisionElement.setSize(size);
        this.sendPacket((class_2596)new class_8042((Iterable)Utils.updateClientInteraction((InteractionElement)this.hitboxInteraction, (class_4048)dimensions.method_19539(1.275f, 1.05f))));
    }

    public void onSyncedDataUpdated(class_2940<?> key, Object object) {
        super.onSyncedDataUpdated(key, object);
        if (key.equals(LivingEntityAccessor.getDATA_HEALTH_ID())) {
            this.collisionElement.getDataTracker().set(LivingEntityAccessor.getDATA_HEALTH_ID(), (Object)((Float)object));
        }
    }

    protected void onDataLoaded() {
        super.onDataLoaded();
        this.collisionElement.getDataTracker().set(LivingEntityAccessor.getDATA_HEALTH_ID(), (Object)((Float)((class_1309)this.parent).method_5841().method_12789(LivingEntityAccessor.getDATA_HEALTH_ID())));
    }

    public void slowRot() {
        for (Bone bone : this.bones) {
            bone.element().setTeleportDuration(null, 3);
        }
    }

    public void fastRot() {
        for (Bone bone : this.bones) {
            bone.element().setTeleportDuration(null, 1);
        }
    }
}

