/*
 * Decompiled with CFR 0.152.
 */
package com.danpan1232.sporadicscreenshot;

import com.danpan1232.sporadicscreenshot.Config;
import com.danpan1232.sporadicscreenshot.SporadicScreenshot;
import com.mojang.blaze3d.pipeline.RenderTarget;
import java.io.File;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

@Mod(value="sporadicscreenshot", dist={Dist.CLIENT})
@EventBusSubscriber(modid="sporadicscreenshot", value={Dist.CLIENT})
public class SporadicScreenshotClient {
    private static int intervalTicks = 200;
    private static boolean showChatMessage = true;
    private static boolean hideHudWhenScreenshotting = false;
    private static int tickCounter = 0;

    public SporadicScreenshotClient(ModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    @SubscribeEvent
    static void onClientSetup(FMLClientSetupEvent event) {
        SporadicScreenshot.LOGGER.info("HELLO FROM CLIENT SETUP");
        SporadicScreenshot.LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.getInstance().getUser().getName());
    }

    @SubscribeEvent
    static void onConfigLoad(ModConfigEvent event) {
        intervalTicks = (Integer)Config.SCREENSHOT_INTERVAL_TICKS.get();
        showChatMessage = (Boolean)Config.SHOW_CHAT_MESSAGE.get();
        hideHudWhenScreenshotting = (Boolean)Config.HIDE_HUD_WHEN_SCREENSHOTTING.get();
        SporadicScreenshot.LOGGER.info("Screenshot config updated: interval={} showChat={} hideHud={}", new Object[]{intervalTicks, showChatMessage, hideHudWhenScreenshotting});
    }

    @SubscribeEvent
    static void onClientTick(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (mc.isPaused() || player == null || mc.level == null) {
            return;
        }
        if (++tickCounter >= intervalTicks) {
            tickCounter = 0;
            Path screenshotsDir = mc.gameDirectory.toPath().resolve("screenshots");
            File file = screenshotsDir.toFile();
            file.mkdirs();
            mc.execute(() -> {
                boolean prevHideHud = mc.options.hideGui;
                if (hideHudWhenScreenshotting) {
                    mc.options.hideGui = true;
                }
                mc.tell(() -> Screenshot.grab((File)mc.gameDirectory, (RenderTarget)mc.getMainRenderTarget(), msg -> {
                    String text = msg.getString();
                    SporadicScreenshot.LOGGER.info("Screenshot saved: {}", (Object)text);
                    if (showChatMessage && mc.player != null) {
                        mc.player.displayClientMessage((Component)Component.literal((String)text), false);
                    }
                    mc.options.hideGui = prevHideHud;
                }));
            });
        }
    }
}

