/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.map.tool;

import foundry.veil.api.client.render.rendertype.VeilRenderType;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.Rendering;
import wawa.mapwright.data.PageManager;
import wawa.mapwright.map.tool.Tool;
import wawa.mapwright.map.widgets.MapWidget;

public class DrawTool
extends Tool {
    private final class_2960 icon;
    protected final int internal_color;
    protected final int visual_color;
    protected int r = 0;
    private static final class_2960 id = MapwrightClient.id("draw");
    private static class_1043 preview = new class_1043(1, 1, false);

    public DrawTool(class_2960 icon, int color, int visual_color) {
        this.icon = icon;
        this.internal_color = color;
        this.visual_color = visual_color;
    }

    public int getRadius() {
        return this.r;
    }

    private void rebuildPixels() {
        preview.close();
        int wh = this.r * 2 + 1;
        class_1011 im = new class_1011(wh, wh, false);
        if (this.internal_color == 0) {
            im.method_4326(0, 0, wh, wh, -16777216);
            if (wh >= 3) {
                im.method_4326(1, 1, wh - 2, wh - 2, 0);
            }
        } else {
            im.method_4326(0, 0, wh, wh, this.internal_color);
        }
        preview = new class_1043(im);
        preview.method_4524();
        class_310.method_1551().method_1531().method_4616(id, (class_1044)preview);
    }

    @Override
    public void mouseMove(PageManager activePage, MapWidget.MouseType mouseType, Vector2dc oldWorld, Vector2dc world) {
        switch (mouseType) {
            case LEFT: {
                this.pixelLine(oldWorld.floor(new Vector2d()), world.floor(new Vector2d()), pos -> this.putSquare(activePage, (Vector2ic)pos, this.internal_color));
                break;
            }
            case RIGHT: {
                this.pixelLine(oldWorld.floor(new Vector2d()), world.floor(new Vector2d()), pos -> this.removeSquare(activePage, (Vector2ic)pos, 0));
            }
        }
    }

    public void putSquare(PageManager activePage, Vector2ic pos, int targetColor) {
        activePage.startSnapshot();
        activePage.putSquare(pos.x(), pos.y(), targetColor, this.r);
    }

    public void removeSquare(PageManager activePage, Vector2ic pos, int targetColor) {
        activePage.startSnapshot();
        activePage.putSquare(pos.x(), pos.y(), targetColor, this.r);
    }

    @Override
    public void mouseRelease(PageManager activePage, MapWidget.MouseType mouseType, Vector2d world) {
        activePage.endSnapshot();
    }

    private void pixelLine(Vector2d point1, Vector2d point2, Consumer<Vector2i> perPixel) {
        Vector2d delta = new Vector2d((Vector2dc)point1).sub((Vector2dc)point2);
        int steps = (int)Math.max(1.0, Math.ceil(Math.max(Math.abs(delta.x), Math.abs(delta.y))));
        delta.div((double)steps);
        Vector2d pos = new Vector2d((Vector2dc)point2);
        for (int i = 0; i < steps + 1; ++i) {
            perPixel.accept(new Vector2i(pos.x + 0.5, pos.y + 0.5, 2));
            pos.add((Vector2dc)delta);
        }
    }

    @Override
    public void controlScroll(PageManager activePage, double mouseX, double mouseY, double scrollY) {
        this.r = class_3532.method_15340((int)(this.r + (int)scrollY), (int)0, (int)(this.internal_color == 0 ? 12 : 6));
        this.rebuildPixels();
    }

    @Override
    public void renderWorld(class_332 graphics, int worldX, int worldY, double xOff, double yOff) {
        class_1921 renderType = VeilRenderType.get((class_2960)Rendering.RenderTypes.PALETTE_SWAP, (Object[])new Object[]{id});
        if (renderType == null) {
            return;
        }
        int wh = this.r * 2 + 1;
        double x = (double)(worldX - this.r) + xOff;
        double y = (double)(worldY - this.r) + yOff;
        Rendering.renderTypeBlit(graphics, renderType, x, y, 0, 0.0f, 0.0f, wh, wh, wh, wh, 1.0f);
    }

    @Override
    public void renderScreen(class_332 graphics, double mouseX, double mouseY) {
        graphics.method_52706(this.icon, (int)mouseX - 16, (int)mouseY - 16, 32, 32);
    }

    @Override
    public void onSelect() {
        this.rebuildPixels();
    }

    public int getVisualColor() {
        return this.visual_color;
    }

    public int getInternalColor() {
        return this.internal_color;
    }

    static {
        preview.method_4525().method_4305(0, 0, -16777216);
        preview.method_4524();
        class_310.method_1551().method_1531().method_4616(id, (class_1044)preview);
    }
}

