/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.map.tool;

import foundry.veil.api.client.render.rendertype.VeilRenderType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.Rendering;
import wawa.mapwright.data.PageManager;
import wawa.mapwright.map.stamp_bag.StampInformation;
import wawa.mapwright.map.stamp_bag.StampTexture;
import wawa.mapwright.map.tool.Tool;

public class StampBagDebuggerTool
extends Tool {
    private final List<InfoAndID> idList = new ArrayList<InfoAndID>();
    private int pointer;
    public static final class_2960 backgroundID = MapwrightClient.id("stamp_browser_background");

    @Override
    public void onSelect() {
        ArrayList<StampInformation> collection = new ArrayList<StampInformation>();
        MapwrightClient.STAMP_HANDLER.requestAllStamps(collection, false);
        for (int i = 0; i < collection.size(); ++i) {
            StampInformation si = collection.get(i);
            si.getTextureManager().addUser();
            this.idList.add(new InfoAndID(MapwrightClient.id("stamp_debugger_" + i), si, new AtomicBoolean()));
        }
    }

    @Override
    public void onDeselect() {
        for (InfoAndID id : this.idList) {
            class_310.method_1551().method_1531().method_4615(id.id);
            id.info.getTextureManager().removeUser();
            id.textureRegistered.set(false);
        }
        this.idList.clear();
        this.pointer = 0;
    }

    @Override
    public void controlScroll(PageManager activePage, double mouseX, double mouseY, double scrollY) {
        this.pointer += (int)scrollY;
        this.pointer = class_3532.method_15340((int)this.pointer, (int)0, (int)(this.idList.size() - 1));
    }

    @Override
    public void renderWorld(class_332 graphics, int worldX, int worldY, double xOff, double yOff) {
        if (!this.idList.isEmpty()) {
            class_1921 renderType;
            InfoAndID infoAndID = this.idList.get(this.pointer);
            class_1011 texture = infoAndID.info.getTextureManager().getTexture();
            if (texture == null) {
                return;
            }
            if (!infoAndID.textureRegistered.get()) {
                infoAndID.textureRegistered.set(true);
                class_310.method_1551().method_1531().method_4616(infoAndID.id, (class_1044)infoAndID.info().getTextureManager());
            }
            if ((renderType = VeilRenderType.get((class_2960)Rendering.RenderTypes.PALETTE_SWAP, (Object[])new Object[]{infoAndID.id})) == null) {
                return;
            }
            StampTexture renderable = infoAndID.info.getTextureManager();
            double x = (double)worldX + xOff - (double)(renderable.getTexture().method_4307() / 2);
            double y = (double)worldY + yOff - (double)(renderable.getTexture().method_4323() / 2);
            class_4587 ps = graphics.method_51448();
            ps.method_22903();
            ps.method_22904(x, y, 0.0);
            graphics.method_52706(backgroundID, -2, -32, Math.max(renderable.getTexture().method_4307() + 4, 98), renderable.getTexture().method_4323() + 34);
            Rendering.renderTypeBlit(graphics, renderType, 0.0, 0.0, 0, 0.0f, 0.0f, renderable.getTexture().method_4307(), renderable.getTexture().method_4323(), renderable.getTexture().method_4307(), renderable.getTexture().method_4323(), 1.0f);
            graphics.method_25303(class_310.method_1551().field_1772, infoAndID.info.getCustomName(), 0, -4, Color.GREEN.getRGB());
            graphics.method_25303(class_310.method_1551().field_1772, infoAndID.info.getFileName(), 0, -16, Color.GREEN.getRGB());
            graphics.method_25303(class_310.method_1551().field_1772, "is favorited: " + infoAndID.info.isFavorited(), 0, -26, Color.GREEN.getRGB());
            ps.method_22909();
        }
    }

    public record InfoAndID(class_2960 id, StampInformation info, AtomicBoolean textureRegistered) {
    }
}

