/*
 * Decompiled with CFR 0.152.
 */
package net.critical_strike.fx;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class CriticalStrikeSounds {
    public static final List<Entry> entries = new ArrayList<Entry>();
    public static final Entry CRITICAL_HIT = CriticalStrikeSounds.add(new Entry("critical_hit").variants(2));

    public static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    public static void register() {
        for (Entry entry : entries) {
            entry.entry = Registry.registerForHolder((Registry)BuiltInRegistries.SOUND_EVENT, (ResourceLocation)entry.id(), (Object)entry.soundEvent());
        }
    }

    public static final class Entry {
        private final ResourceLocation id;
        private final SoundEvent soundEvent;
        private Holder<SoundEvent> entry;
        private int variants = 1;

        public Entry(ResourceLocation id, SoundEvent soundEvent) {
            this.id = id;
            this.soundEvent = soundEvent;
        }

        public Entry(String name) {
            this(ResourceLocation.fromNamespaceAndPath((String)"critical_strike", (String)name));
        }

        public Entry(ResourceLocation id) {
            this(id, SoundEvent.createVariableRangeEvent((ResourceLocation)id));
        }

        public Entry travelDistance(float distance) {
            return new Entry(this.id, SoundEvent.createFixedRangeEvent((ResourceLocation)this.id, (float)distance));
        }

        public Entry variants(int variants) {
            this.variants = variants;
            return this;
        }

        public ResourceLocation id() {
            return this.id;
        }

        public SoundEvent soundEvent() {
            return this.soundEvent;
        }

        public Holder<SoundEvent> entry() {
            return this.entry;
        }

        public int variants() {
            return this.variants;
        }

        public void register() {
            if (this.entry == null) {
                this.entry = Registry.registerForHolder((Registry)BuiltInRegistries.SOUND_EVENT, (ResourceLocation)this.id(), (Object)this.soundEvent());
            }
        }
    }
}

