/*
 * Decompiled with CFR 0.152.
 */
package net.tiny_config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import net.tiny_config.Platform;
import net.tiny_config.versioning.Versionable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager<Config> {
    static final Logger LOGGER = LoggerFactory.getLogger((String)"tiny-config");
    public volatile Config value;
    private volatile boolean loaded = false;
    public String configName;
    public String directory;
    public boolean isLoggingEnabled = false;
    public boolean sanitize = false;
    public int requiredSchemaVersion = 0;
    public Function<Config, Boolean> validator;
    public Function<Config, Config> constraint;
    private final Object ioLock = new Object();

    public ConfigManager(String configName, Config defaultConfig) {
        this.configName = configName;
        this.value = defaultConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Path filePath = this.getConfigFilePath();
        ConfigManager configManager = this;
        synchronized (configManager) {
            this.load();
            if (this.sanitize || this.isVersioned() || !Files.exists(filePath, new LinkOption[0])) {
                this.save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Config safeValue() {
        if (!this.loaded) {
            ConfigManager configManager = this;
            synchronized (configManager) {
                if (!this.loaded) {
                    this.refresh();
                }
            }
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Object object = this.ioLock;
        synchronized (object) {
            block10: {
                Path filePath = this.getConfigFilePath();
                try {
                    Gson gson = new Gson();
                    if (Files.exists(filePath, new LinkOption[0])) {
                        Config Config;
                        boolean isValid;
                        BufferedReader reader = Files.newBufferedReader(filePath);
                        Object newValue = gson.fromJson((Reader)reader, this.value.getClass());
                        boolean meetsRequiredVersion = true;
                        if (newValue instanceof Versionable) {
                            Versionable versionable = (Versionable)newValue;
                            meetsRequiredVersion = versionable.getSchemaVersion() >= this.requiredSchemaVersion;
                        }
                        boolean bl = isValid = (this.validator == null || this.validator.apply(newValue) != false) && meetsRequiredVersion;
                        if (isValid) {
                            if (this.constraint != null) {
                                newValue = this.constraint.apply(newValue);
                            }
                            this.value = newValue;
                        }
                        if ((Config = this.value) instanceof Versionable) {
                            Versionable versionable = (Versionable)Config;
                            versionable.setSchemaVersion(this.requiredSchemaVersion);
                        }
                        ((Reader)reader).close();
                    }
                }
                catch (Exception e) {
                    if (!this.isLoggingEnabled) break block10;
                    LOGGER.error("Failed loading " + this.configName + " config: " + e.getMessage());
                }
            }
            this.loaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        Config config = this.value;
        Object object = this.ioLock;
        synchronized (object) {
            block7: {
                Path filePath = this.getConfigFilePath();
                Path configDir = Platform.util().getConfigDir();
                try {
                    if (this.directory != null && !this.directory.isEmpty()) {
                        Path directoryPath = configDir.resolve(this.directory);
                        Files.createDirectories(directoryPath, new FileAttribute[0]);
                    }
                    Gson prettyGson = new GsonBuilder().setPrettyPrinting().create();
                    BufferedWriter writer = Files.newBufferedWriter(filePath, new OpenOption[0]);
                    writer.write(prettyGson.toJson(config));
                    ((Writer)writer).close();
                    if (this.isLoggingEnabled) {
                        Gson gson = new Gson();
                        LOGGER.info(this.configName + " config written: " + gson.toJson(config));
                    }
                }
                catch (Exception e) {
                    if (!this.isLoggingEnabled) break block7;
                    LOGGER.error("Failed writing " + this.configName + " config: " + e.getMessage());
                }
            }
        }
    }

    private boolean isVersioned() {
        return this.value instanceof Versionable && this.requiredSchemaVersion > 0;
    }

    private Path getConfigFilePath() {
        String configFilePath = this.configName + ".json";
        if (this.directory != null && !this.directory.isEmpty()) {
            configFilePath = this.directory + "/" + configFilePath;
        }
        Path configDir = Platform.util().getConfigDir();
        return configDir.resolve(configFilePath);
    }

    private int schemaVersion(Config config) {
        if (config instanceof Versionable) {
            Versionable versionable = (Versionable)config;
            return versionable.getSchemaVersion();
        }
        return 0;
    }

    public Builder builder() {
        return new Builder(this, this);
    }

    public class Builder {
        ConfigManager<Config> manager;

        Builder(ConfigManager this$0, ConfigManager<Config> manager) {
            this.manager = manager;
        }

        public Builder enableLogging(boolean enable) {
            this.manager.isLoggingEnabled = enable;
            return this;
        }

        public Builder setDirectory(String directory) {
            this.manager.directory = directory;
            return this;
        }

        public Builder sanitize(boolean sanitize) {
            this.manager.sanitize = sanitize;
            return this;
        }

        public Builder schemaVersion(int required) {
            if (!(this.manager.value instanceof Versionable)) {
                throw new ExceptionInInitializerError("To use `schemaVersion` your config type has to extend `VersionableConfig` or provide a custom implementation for `Versionable`.");
            }
            this.manager.requiredSchemaVersion = required;
            return this;
        }

        public Builder validate(Function<Config, Boolean> validator) {
            this.manager.validator = validator;
            return this;
        }

        public Builder constrain(Function<Config, Config> constraint) {
            this.manager.constraint = constraint;
            return this;
        }

        public ConfigManager<Config> build() {
            return this.manager;
        }
    }
}

