/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rareice;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import me.shedaniel.rareice.blocks.RareIceBlock;
import me.shedaniel.rareice.blocks.entities.RareIceBlockEntity;
import me.shedaniel.rareice.world.gen.feature.RareIceConfig;
import me.shedaniel.rareice.world.gen.feature.RareIceCountPlacement;
import me.shedaniel.rareice.world.gen.feature.RareIceFeature;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6798;
import net.minecraft.class_7924;

public class RareIce {
    public static final String MOD_ID = "rare_ice";
    public static final DeferredRegister<class_2248> BLOCKS = DeferredRegister.create((String)"rare_ice", (class_5321)class_7924.field_41254);
    public static final RegistrySupplier<class_2248> RARE_ICE_BLOCK = BLOCKS.register("rare_ice", () -> new RareIceBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10295).method_26235((state, world, pos, type) -> type == class_1299.field_6042)));
    public static final DeferredRegister<class_2591<?>> BLOCK_ENTITIES = DeferredRegister.create((String)"rare_ice", (class_5321)class_7924.field_41255);
    public static final RegistrySupplier<class_2591<RareIceBlockEntity>> RARE_ICE_BLOCK_ENTITY_TYPE = BLOCK_ENTITIES.register("rare_ice", () -> class_2591.class_2592.method_20528(RareIceBlockEntity::new, (class_2248[])new class_2248[]{(class_2248)RARE_ICE_BLOCK.get()}).method_11034(null));
    public static final DeferredRegister<class_3031<?>> FEATURES = DeferredRegister.create((String)"rare_ice", (class_5321)class_7924.field_41267);
    public static final RegistrySupplier<class_3031<RareIceConfig>> RARE_ICE_FEATURE = FEATURES.register("rare_ice", () -> new RareIceFeature(RareIceConfig.CODEC));
    public static final DeferredRegister<class_6798<?>> PLACEMENTS = DeferredRegister.create((String)"rare_ice", (class_5321)class_7924.field_41211);
    public static final RegistrySupplier<class_6798<RareIceCountPlacement>> COUNT_PLACEMENT = PLACEMENTS.register("rare_ice_count", () -> () -> RareIceCountPlacement.CODEC);
    public static boolean allowInsertingItemsToIce = true;
    public static int probabilityOfRareIce = 3;

    private static void loadConfig(Path file) {
        allowInsertingItemsToIce = true;
        probabilityOfRareIce = 3;
        if (Files.exists(file, new LinkOption[0])) {
            try {
                Properties properties = new Properties();
                properties.load(Files.newBufferedReader(file));
                allowInsertingItemsToIce = properties.getProperty("allowInsertingItemsToIce", "true").equals("true");
                probabilityOfRareIce = Integer.parseInt(properties.getProperty("probabilityOfRareIce", "3"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        RareIce.saveConfig(file);
    }

    private static void saveConfig(Path file) {
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Properties properties = new Properties();
            properties.setProperty("allowInsertingItemsToIce", String.valueOf(allowInsertingItemsToIce));
            properties.setProperty("probabilityOfRareIce", String.valueOf(probabilityOfRareIce));
            properties.store(Files.newBufferedWriter(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE), "Rare Ice Configuration");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void onInitialize() {
        RareIce.loadConfig(Platform.getConfigFolder().resolve("rare_ice.properties"));
        BLOCKS.register();
        BLOCK_ENTITIES.register();
        FEATURES.register();
        PLACEMENTS.register();
        InteractionEvent.RIGHT_CLICK_BLOCK.register((player, interactionHand, pos, direction) -> {
            if (!allowInsertingItemsToIce) {
                return EventResult.pass();
            }
            class_1937 world = player.method_37908();
            class_2680 state = world.method_8320(pos);
            if (player == null || player.method_5715()) {
                return EventResult.pass();
            }
            if (state.method_26204() == class_2246.field_10295 || state.method_26204() == RARE_ICE_BLOCK) {
                class_2586 blockEntity = world.method_8321(pos);
                if (blockEntity == null) {
                    world.method_8501(pos, ((class_2248)RARE_ICE_BLOCK.get()).method_9564());
                    blockEntity = world.method_8321(pos);
                }
                if (blockEntity instanceof RareIceBlockEntity) {
                    RareIceBlockEntity rareIceBlockEntity = (RareIceBlockEntity)blockEntity;
                    class_1799 itemStack = player.method_5998(interactionHand);
                    itemStack = player.method_31549().field_7477 ? itemStack.method_7972() : itemStack;
                    return rareIceBlockEntity.addItem(world, itemStack, player, !world.method_8608());
                }
            }
            return EventResult.pass();
        });
    }
}

