/*
 * Decompiled with CFR 0.152.
 */
package com.kr3akz.blocktracker;

import com.kr3akz.blocktracker.BlockTrackerData;
import com.kr3akz.blocktracker.BlockTrackerOverlay;
import com.kr3akz.blocktracker.Blocktracker;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class BlockTrackerConfig {
    private static final Path CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("blocktracker.txt");
    private static final String DATA_SEPARATOR = "###DATA###";

    public static void save() {
        try {
            String settings = "overlayVisible:" + BlockTrackerOverlay.isVisible + "\n";
            String data = BlockTrackerData.serialize();
            String fileContent = settings + "###DATA###\n" + data;
            Files.writeString(CONFIG_FILE, (CharSequence)fileContent, new OpenOption[0]);
            Blocktracker.LOGGER.info("BlockTracker Daten und Einstellungen gespeichert");
        }
        catch (IOException e) {
            Blocktracker.LOGGER.error("Fehler beim Speichern der BlockTracker Daten", (Throwable)e);
        }
    }

    public static void load() {
        try {
            if (Files.exists(CONFIG_FILE, new LinkOption[0])) {
                String fileContent = Files.readString(CONFIG_FILE);
                String settingsPart = "";
                String dataPart = "";
                if (fileContent.contains(DATA_SEPARATOR)) {
                    String[] parts = fileContent.split("###DATA###\n", 2);
                    if (parts.length == 2) {
                        settingsPart = parts[0];
                        dataPart = parts[1];
                    }
                } else {
                    dataPart = fileContent;
                }
                if (!settingsPart.isEmpty()) {
                    String[] lines;
                    for (String line : lines = settingsPart.split("\n")) {
                        if (!line.startsWith("overlayVisible:")) continue;
                        BlockTrackerOverlay.isVisible = Boolean.parseBoolean(line.split(":", 2)[1]);
                    }
                }
                BlockTrackerData.deserialize(dataPart);
                Blocktracker.LOGGER.info("BlockTracker Daten und Einstellungen geladen");
            }
        }
        catch (IOException e) {
            Blocktracker.LOGGER.error("Fehler beim Laden der BlockTracker Daten", (Throwable)e);
        }
    }
}

