/*
 * Decompiled with CFR 0.152.
 */
package com.kr3akz.blocktracker;

import com.kr3akz.blocktracker.BlockTrackerConfig;
import com.kr3akz.blocktracker.BlockTrackerData;
import com.kr3akz.blocktracker.Blocktracker;
import com.kr3akz.blocktracker.ItemCounter;
import com.kr3akz.blocktracker.ItemGridSlotWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class BlockTrackerScreen
extends class_437 {
    private class_342 itemIdField;
    private class_342 amountField;
    private static final List<class_1799> allItems = new ArrayList<class_1799>();
    private List<class_1799> filteredItems = new ArrayList<class_1799>();
    private List<class_339> gridPaginationWidgets = new ArrayList<class_339>();
    private List<ItemGridSlotWidget> gridItemWidgets = new ArrayList<ItemGridSlotWidget>();
    private boolean isUpdatingFromClick = false;
    private int gridPage = 0;
    private int itemsPerGridPage = 0;
    private int gridRows = 0;
    private int itemsPerGridRow = 0;
    private static final int GRID_ITEM_SIZE = 18;
    private int gridLeftX = 0;
    private int gridRightX = 0;
    private int gridTopY = 0;
    private int gridBottomY = 0;
    private int listLeftX = 0;
    private int listRightX = 0;
    private int listTopY = 0;
    private int listBottomY = 0;
    private int trackedListScrollOffset = 0;
    private static final int TRACKED_ITEM_HEIGHT = 30;

    public BlockTrackerScreen() {
        super((class_2561)class_2561.method_43471((String)"gui.blocktracker.screen.title"));
    }

    private void populateAllItems() {
        if (allItems.isEmpty() && this.field_22787 != null) {
            for (class_1792 item : class_7923.field_41178) {
                if (item == class_1802.field_8162) continue;
                allItems.add(new class_1799((class_1935)item));
            }
            Blocktracker.LOGGER.info("BlockTracker: Alle " + allItems.size() + " Items geladen.");
        }
    }

    private void filterItems(String searchText) {
        this.filteredItems.clear();
        String lowerSearch = searchText.toLowerCase().trim();
        if (lowerSearch.isEmpty()) {
            this.filteredItems.addAll(allItems);
            return;
        }
        for (class_1799 stack : allItems) {
            String name = stack.method_7964().getString().toLowerCase();
            String id = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString().toLowerCase();
            if (!name.contains(lowerSearch) && !id.contains(lowerSearch)) continue;
            this.filteredItems.add(stack);
        }
    }

    protected void method_25426() {
        if (this.field_22787 == null) {
            return;
        }
        this.populateAllItems();
        String currentSearch = this.itemIdField != null ? this.itemIdField.method_1882() : "";
        String currentAmount = this.amountField != null ? this.amountField.method_1882() : "";
        this.filterItems(currentSearch);
        int gridWidth = 184;
        this.gridLeftX = this.field_22789 / 2 - gridWidth - 10;
        this.gridRightX = this.gridLeftX + gridWidth;
        this.gridTopY = 65;
        this.gridBottomY = this.field_22790 - 30;
        int listWidth = 180;
        this.listLeftX = this.field_22789 / 2 + 10;
        this.listRightX = this.listLeftX + listWidth;
        this.listTopY = 65;
        this.listBottomY = this.field_22790 - 30;
        int searchBarX = this.gridLeftX + 50;
        int searchBarWidth = gridWidth - 50;
        this.itemIdField = new class_342(this.field_22793, searchBarX, 40, searchBarWidth, 20, (class_2561)class_2561.method_43471((String)"gui.blocktracker.screen.search.narration"));
        this.itemIdField.method_47404((class_2561)class_2561.method_43471((String)"gui.blocktracker.screen.search.placeholder"));
        this.itemIdField.method_1880(100);
        this.itemIdField.method_1852(currentSearch);
        this.itemIdField.method_1863(this::onSearchTextChanged);
        this.method_37063((class_364)this.itemIdField);
        this.method_48265((class_364)this.itemIdField);
        this.amountField = new class_342(this.field_22793, this.listLeftX, 40, 40, 20, (class_2561)class_2561.method_43471((String)"gui.blocktracker.screen.amount.narration"));
        this.amountField.method_47404((class_2561)class_2561.method_43471((String)"gui.blocktracker.screen.amount.placeholder"));
        this.amountField.method_1880(6);
        this.amountField.method_1852(currentAmount);
        this.method_37063((class_364)this.amountField);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.blocktracker.screen.button.add"), button -> this.addItem()).method_46434(this.listLeftX + 45, 40, 65, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.blocktracker.screen.button.clear_all"), button -> {
            BlockTrackerData.clearAll();
            BlockTrackerConfig.save();
            this.field_22787.method_1507((class_437)this);
        }).method_46434(this.listLeftX + 115, 40, 65, 20).method_46431());
        this.itemsPerGridRow = (this.gridRightX - this.gridLeftX) / 18;
        this.gridRows = (this.gridBottomY - this.gridTopY) / 18;
        this.itemsPerGridPage = this.itemsPerGridRow * this.gridRows;
        this.rebuildGridWidgets();
        int maxVisibleTracked = (this.listBottomY - this.listTopY) / 30;
        Map<class_1792, Integer> items = BlockTrackerData.getTrackedItems();
        int totalItems = items.size();
        class_4185 upButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.blocktracker.screen.button.up"), button -> {
            this.trackedListScrollOffset = Math.max(0, this.trackedListScrollOffset - 1);
            this.field_22787.method_1507((class_437)this);
        }).method_46434(this.listRightX + 5, this.listTopY, 20, 20).method_46431();
        class_4185 downButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.blocktracker.screen.button.down"), button -> {
            this.trackedListScrollOffset = Math.min(totalItems - maxVisibleTracked, this.trackedListScrollOffset + 1);
            this.field_22787.method_1507((class_437)this);
        }).method_46434(this.listRightX + 5, this.listTopY + 22, 20, 20).method_46431();
        upButton.field_22763 = this.trackedListScrollOffset > 0;
        downButton.field_22763 = this.trackedListScrollOffset + maxVisibleTracked < totalItems;
        this.method_37063((class_364)upButton);
        this.method_37063((class_364)downButton);
        this.createControlButtons(this.listTopY, this.listBottomY, this.listLeftX, listWidth);
    }

    private void onSearchTextChanged(String newText) {
        if (this.isUpdatingFromClick) {
            this.isUpdatingFromClick = false;
            return;
        }
        this.filterItems(newText);
        this.gridPage = 0;
        this.rebuildGridWidgets();
    }

    private void rebuildGridWidgets() {
        for (class_339 class_3392 : this.gridPaginationWidgets) {
            this.method_37066((class_364)class_3392);
        }
        this.gridPaginationWidgets.clear();
        for (ItemGridSlotWidget itemGridSlotWidget : this.gridItemWidgets) {
            this.method_37066((class_364)itemGridSlotWidget);
        }
        this.gridItemWidgets.clear();
        int maxPage = Math.max(0, (this.filteredItems.size() - 1) / this.itemsPerGridPage);
        int n = 40;
        if (this.gridPage > 0) {
            class_4185 prevButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.blocktracker.screen.button.prev"), button -> {
                this.gridPage = Math.max(0, this.gridPage - 1);
                this.rebuildGridWidgets();
            }).method_46434(this.gridLeftX, n, 20, 20).method_46431();
            this.gridPaginationWidgets.add((class_339)this.method_37063((class_364)prevButton));
        }
        if (this.gridPage < maxPage) {
            class_4185 nextButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.blocktracker.screen.button.next"), button -> {
                this.gridPage = Math.min(maxPage, this.gridPage + 1);
                this.rebuildGridWidgets();
            }).method_46434(this.gridLeftX + 25, n, 20, 20).method_46431();
            this.gridPaginationWidgets.add((class_339)this.method_37063((class_364)nextButton));
        }
        int x = this.gridLeftX;
        int y = this.gridTopY;
        int startIndex = this.gridPage * this.itemsPerGridPage;
        if (startIndex >= this.filteredItems.size()) {
            return;
        }
        for (int i = startIndex; i < this.filteredItems.size() && i < startIndex + this.itemsPerGridPage; ++i) {
            class_1799 stack = this.filteredItems.get(i);
            class_2960 itemIdIdent = class_7923.field_41178.method_10221((Object)stack.method_7909());
            String itemId = itemIdIdent.toString().split(":")[1];
            ItemGridSlotWidget slotWidget = new ItemGridSlotWidget(x, y, 18, 18, stack, itemId, this.itemIdField);
            this.gridItemWidgets.add((ItemGridSlotWidget)this.method_37063((class_364)slotWidget));
            if ((x += 18) + 18 <= this.gridRightX) continue;
            x = this.gridLeftX;
            if ((y += 18) + 18 > this.gridBottomY) break;
        }
    }

    private void createControlButtons(int startY, int bottomY, int listX, int listWidth) {
        Map<class_1792, Integer> items = BlockTrackerData.getTrackedItems();
        int y = startY;
        int index = 0;
        for (class_1792 item : items.keySet()) {
            if (index < this.trackedListScrollOffset) {
                ++index;
                continue;
            }
            if (y + 30 > bottomY + 5) break;
            int buttonY = y + 5;
            boolean isCompleted = BlockTrackerData.isCompleted(item);
            int deleteButtonX = listX + listWidth - 25;
            int resetButtonX = listX + listWidth - 50;
            class_1792 itemToDelete = item;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.blocktracker.screen.button.delete"), button -> {
                BlockTrackerData.removeTrackedItem(itemToDelete);
                BlockTrackerConfig.save();
                this.field_22787.method_1507((class_437)this);
            }).method_46434(deleteButtonX, buttonY, 20, 20).method_46431());
            if (isCompleted) {
                class_1792 itemToReset = item;
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.blocktracker.screen.button.reset"), button -> {
                    BlockTrackerData.unmarkCompleted(itemToReset);
                    BlockTrackerConfig.save();
                    this.field_22787.method_1507((class_437)this);
                }).method_46434(resetButtonX, buttonY, 20, 20).method_46431());
            }
            y += 30;
            ++index;
        }
    }

    private void addItem() {
        String itemId = this.itemIdField.method_1882();
        String amountText = this.amountField.method_1882();
        if (itemId.isEmpty()) {
            return;
        }
        try {
            class_1792 item = null;
            class_2960 id = class_2960.method_12829((String)itemId);
            if (id != null) {
                item = (class_1792)class_7923.field_41178.method_63535(id);
            } else {
                String lowerId = itemId.toLowerCase();
                for (class_1799 stack : allItems) {
                    if (!stack.method_7964().getString().toLowerCase().equals(lowerId)) continue;
                    item = stack.method_7909();
                    break;
                }
            }
            if (item == null || item == class_1802.field_8162) {
                return;
            }
            int amount = 64;
            if (!amountText.isEmpty()) {
                amount = Integer.parseInt(amountText);
            }
            BlockTrackerData.addTrackedItem(item, amount);
            BlockTrackerConfig.save();
            this.itemIdField.method_1852("");
            this.amountField.method_1852("");
            this.field_22787.method_1507((class_437)this);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, 0xFFFFFF);
        int maxPage = Math.max(0, (this.filteredItems.size() - 1) / this.itemsPerGridPage);
        class_5250 pageText = class_2561.method_43469((String)"gui.blocktracker.screen.page_indicator", (Object[])new Object[]{this.gridPage + 1, maxPage + 1});
        context.method_27535(this.field_22793, (class_2561)pageText, this.gridLeftX, 28, 0xAAAAAA);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.blocktracker.screen.amount.label"), this.listLeftX, 28, 0xAAAAAA);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.blocktracker.screen.list.title"), this.listLeftX, 53, 0xAAAAAA);
        context.method_25294(this.gridLeftX - 2, this.gridTopY - 2, this.gridRightX + 2, this.gridBottomY + 2, 0x40000000);
        context.method_25294(this.listLeftX - 2, this.listTopY - 2, this.listRightX + 2, this.listBottomY + 2, 0x40000000);
        this.renderTrackedItems(context, mouseX, mouseY, this.listTopY, this.listBottomY, this.listLeftX, this.listRightX - this.listLeftX);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void renderTrackedItems(class_332 context, int mouseX, int mouseY, int startY, int bottomY, int listX, int listWidth) {
        Map<class_1792, Integer> items = BlockTrackerData.getTrackedItems();
        int y = startY;
        int index = 0;
        for (Map.Entry<class_1792, Integer> entry : items.entrySet()) {
            if (index < this.trackedListScrollOffset) {
                ++index;
                continue;
            }
            if (y + 30 > bottomY + 5) break;
            class_1792 item = entry.getKey();
            int target = entry.getValue();
            int current = ItemCounter.getItemCount(item);
            boolean completed = BlockTrackerData.isCompleted(item);
            int boxY1 = y + 1;
            int boxY2 = y + 29;
            int itemY = y + 7;
            int textY = y + 11;
            int bgColor = completed || current >= target ? 0x4000FF00 : 0x40808080;
            context.method_25294(listX, boxY1, listX + listWidth, boxY2, bgColor);
            context.method_51427(new class_1799((class_1935)item), listX + 5, itemY);
            String progress = current + "/" + target;
            int color = completed ? -8355712 : (current >= target ? -16711936 : -1);
            context.method_25303(this.field_22793, progress, listX + 28, textY, color);
            y += 30;
            ++index;
        }
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25419() {
        this.filterItems("");
        super.method_25419();
    }
}

