/*
 * Decompiled with CFR 0.152.
 */
package com.kr3akz.blocktracker;

import com.kr3akz.blocktracker.Blocktracker;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class BlockTrackerData {
    private static final Map<class_1792, Integer> trackedItems = new LinkedHashMap<class_1792, Integer>();
    private static final Set<class_1792> completedItems = new HashSet<class_1792>();

    public static void addTrackedItem(class_1792 item, int targetAmount) {
        if (item != null && item != class_1802.field_8162) {
            trackedItems.put(item, targetAmount);
            completedItems.remove(item);
        }
    }

    public static void removeTrackedItem(class_1792 item) {
        trackedItems.remove(item);
        completedItems.remove(item);
    }

    public static Map<class_1792, Integer> getTrackedItems() {
        return new LinkedHashMap<class_1792, Integer>(trackedItems);
    }

    public static boolean isCompleted(class_1792 item) {
        return completedItems.contains(item);
    }

    public static void markCompleted(class_1792 item, boolean completed) {
        if (completed) {
            completedItems.add(item);
        } else {
            completedItems.remove(item);
        }
    }

    public static void unmarkCompleted(class_1792 item) {
        completedItems.remove(item);
    }

    public static void clearAll() {
        trackedItems.clear();
        completedItems.clear();
    }

    public static void setTargetAmount(class_1792 item, int amount) {
        if (trackedItems.containsKey(item)) {
            trackedItems.put(item, amount);
        }
    }

    public static int getTargetAmount(class_1792 item) {
        return trackedItems.getOrDefault(item, 0);
    }

    public static String serialize() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<class_1792, Integer> entry : trackedItems.entrySet()) {
            class_2960 id = class_7923.field_41178.method_10221((Object)entry.getKey());
            boolean completed = completedItems.contains(entry.getKey());
            sb.append(id).append(":").append(entry.getValue()).append(":").append(completed).append("\n");
        }
        return sb.toString();
    }

    public static void deserialize(String data) {
        String[] lines;
        trackedItems.clear();
        completedItems.clear();
        if (data == null || data.isEmpty()) {
            return;
        }
        for (String line : lines = data.split("\n")) {
            String[] parts = line.split(":");
            if (parts.length < 2) continue;
            try {
                class_2960 id = class_2960.method_12829((String)parts[0]);
                if (id == null) continue;
                class_1792 item = (class_1792)class_7923.field_41178.method_63535(id);
                int amount = Integer.parseInt(parts[1]);
                boolean completed = parts.length > 2 && Boolean.parseBoolean(parts[2]);
                trackedItems.put(item, amount);
                if (!completed) continue;
                completedItems.add(item);
            }
            catch (Exception e) {
                Blocktracker.LOGGER.error("Fehler beim Laden von Tracking-Daten: " + line, (Throwable)e);
            }
        }
    }
}

