/*
 * Decompiled with CFR 0.152.
 */
package com.hxzhitang.tongdarailway.blocks;

import com.hxzhitang.tongdarailway.Config;
import com.hxzhitang.tongdarailway.blocks.ModBlockEntities;
import com.hxzhitang.tongdarailway.structure.TrackPutInfo;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.redstone.RoseQuartzLampBlock;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackMaterial;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.createmod.catnip.data.Couple;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class TrackSpawnerBlockEntity
extends BlockEntity {
    private static final int SPAWN_RANGE = 20;
    protected boolean spawnedTrack = false;
    private final List<TrackPutInfo> trackPutInfos = new ArrayList<TrackPutInfo>();

    public TrackSpawnerBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.TRACK_SPAWNER.get(), pos, blockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TrackSpawnerBlockEntity entity) {
        if (entity.spawnedTrack || !entity.anyPlayerInRange(level)) {
            return;
        }
        if (!level.isClientSide()) {
            if (!Config.enableTrackSpawner) {
                return;
            }
            if (level instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)level;
                for (TrackPutInfo track : entity.trackPutInfos) {
                    if (track.bezier() != null) {
                        if (Math.abs(track.bezier().endOffset().y) > 15.0) continue;
                        TrackSpawnerBlockEntity.placeCurveTrack(world, track);
                        Objects.requireNonNull(level.getServer()).execute(() -> TrackSpawnerBlockEntity.placeCurveTrackEntity((WorldGenLevel)world, track));
                        continue;
                    }
                    if (world.getBlockState(track.pos()).equals(AllBlocks.TRACK.getDefaultState())) continue;
                    BlockState trackState = (BlockState)((BlockState)AllBlocks.TRACK.getDefaultState().setValue((Property)TrackBlock.SHAPE, (Comparable)track.shape())).setValue((Property)TrackBlock.HAS_BE, (Comparable)Boolean.valueOf(true));
                    world.setBlock(track.pos(), trackState, 3);
                }
            }
            level.destroyBlock(pos, false);
            level.setBlock(pos, (BlockState)AllBlocks.ROSE_QUARTZ_LAMP.getDefaultState().setValue((Property)RoseQuartzLampBlock.POWERING, (Comparable)Boolean.valueOf(true)), 3);
            entity.spawnedTrack = true;
        }
    }

    public void addTrackPutInfo(List<TrackPutInfo> trackPutInfos) {
        this.trackPutInfos.addAll(trackPutInfos);
    }

    public boolean anyPlayerInRange(Level level) {
        return level.hasNearbyAlivePlayer((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5, (double)this.getRange());
    }

    protected int getRange() {
        return 20;
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider p_331864_) {
        ListTag tracksTag = new ListTag();
        for (TrackPutInfo track : this.trackPutInfos) {
            tracksTag.add((Object)track.toNBT());
        }
        nbt.put("tracks", (Tag)tracksTag);
        super.saveAdditional(nbt, p_331864_);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider p_335164_) {
        super.loadAdditional(nbt, p_335164_);
        ListTag tracksTag = nbt.getList("tracks", 10);
        for (int i = 0; i < tracksTag.size(); ++i) {
            TrackPutInfo track = TrackPutInfo.fromNBT(tracksTag.getCompound(i));
            this.trackPutInfos.add(track);
        }
    }

    private static void placeCurveTrack(ServerLevel world, TrackPutInfo track) {
        BlockPos startPos = track.pos();
        BlockState trackState = (BlockState)((BlockState)AllBlocks.TRACK.getDefaultState().setValue((Property)TrackBlock.SHAPE, (Comparable)track.shape())).setValue((Property)TrackBlock.HAS_BE, (Comparable)Boolean.valueOf(true));
        world.setBlock(startPos, trackState, 3);
        Vec3 offset = track.bezier().endOffset();
        BlockPos endPos = startPos.offset((int)offset.x, (int)offset.y, (int)offset.z);
        BlockState trackState2 = (BlockState)((BlockState)AllBlocks.TRACK.getDefaultState().setValue((Property)TrackBlock.SHAPE, (Comparable)track.endShape())).setValue((Property)TrackBlock.HAS_BE, (Comparable)Boolean.valueOf(true));
        world.setBlock(endPos, trackState2, 3);
    }

    private static void placeCurveTrackEntity(WorldGenLevel world, TrackPutInfo track) {
        BlockPos startPos = track.pos();
        Vec3 offset = track.bezier().endOffset();
        BlockPos endPos = startPos.offset((int)offset.x, (int)offset.y, (int)offset.z);
        TrackBlockEntity tbe1 = (TrackBlockEntity)world.getBlockEntity(startPos);
        TrackBlockEntity tbe2 = (TrackBlockEntity)world.getBlockEntity(endPos);
        if (tbe1 != null && tbe2 != null) {
            Vec3 start1 = track.bezier().start().add(TrackSpawnerBlockEntity.getStartVec(track.bezier().startAxis()));
            Vec3 start2 = track.bezier().start().add(track.bezier().endOffset()).add(TrackSpawnerBlockEntity.getStartVec(track.bezier().endAxis()));
            Vec3 axis1 = track.bezier().startAxis();
            Vec3 axis2 = track.bezier().endAxis();
            Vec3 normal1 = new Vec3(0.0, 1.0, 0.0);
            Vec3 normal2 = new Vec3(0.0, 1.0, 0.0);
            BezierConnection connection = new BezierConnection(Couple.create((Object)startPos, (Object)endPos), Couple.create((Object)start1, (Object)start2), Couple.create((Object)axis1, (Object)axis2), Couple.create((Object)normal1, (Object)normal2), true, false, TrackMaterial.ANDESITE);
            tbe1.setLevel((Level)world.getLevel());
            tbe2.setLevel((Level)world.getLevel());
            tbe1.addConnection(connection);
            tbe2.addConnection(connection.secondary());
        }
    }

    private static Vec3 getStartVec(Vec3 dir) {
        double offX = Math.abs(dir.x) < 1.0E-6 ? 0.5 : (dir.x < 0.0 ? 0.0 : 1.0);
        double offZ = Math.abs(dir.z) < 1.0E-6 ? 0.5 : (dir.z < 0.0 ? 0.0 : 1.0);
        return new Vec3(offX, 0.0, offZ);
    }
}

