/*
 * Decompiled with CFR 0.152.
 */
package com.hxzhitang.tongdarailway.datagen;

import com.hxzhitang.tongdarailway.datagen.ModBiomeModifiers;
import com.hxzhitang.tongdarailway.datagen.ModBlockLootProvider;
import com.hxzhitang.tongdarailway.datagen.ModBlockStateProvider;
import com.hxzhitang.tongdarailway.datagen.ModFeatures;
import com.hxzhitang.tongdarailway.datagen.ModLanguageProviderENUS;
import com.hxzhitang.tongdarailway.datagen.ModLanguageProviderZHCN;
import com.hxzhitang.tongdarailway.datagen.ModLootTableProvider;
import com.hxzhitang.tongdarailway.datagen.ModPlacements;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ModDataGen
extends DatapackBuiltinEntriesProvider {
    public static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.CONFIGURED_FEATURE, ModFeatures::bootstrap).add(Registries.PLACED_FEATURE, ModPlacements::bootstrap).add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, ModBiomeModifiers::bootstrap);

    public ModDataGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, BUILDER, Set.of("tongdarailway"));
    }

    public static void gatherData(GatherDataEvent event) {
        CompletableFuture lp = event.getLookupProvider();
        ExistingFileHelper efh = event.getExistingFileHelper();
        event.getGenerator().addProvider(event.includeServer(), pOutput -> new ModDataGen(pOutput, lp));
        event.getGenerator().addProvider(event.includeClient(), ModLanguageProviderENUS::new);
        event.getGenerator().addProvider(event.includeClient(), ModLanguageProviderZHCN::new);
        event.getGenerator().addProvider(event.includeClient(), pOutput -> new ModBlockStateProvider(pOutput, "tongdarailway", efh));
        event.getGenerator().addProvider(event.includeServer(), pOutput -> new ModLootTableProvider(pOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ModBlockLootProvider::new, LootContextParamSets.BLOCK)), event.getLookupProvider()));
    }
}

