/*
 * Decompiled with CFR 0.152.
 */
package com.hxzhitang.tongdarailway.railway;

import com.hxzhitang.tongdarailway.Tongdarailway;
import com.hxzhitang.tongdarailway.railway.RailwayMap;
import com.hxzhitang.tongdarailway.railway.RegionPos;
import com.hxzhitang.tongdarailway.util.ModSaveData;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.Level;

public class RailwayBuilder {
    private static RailwayBuilder instance;
    private static long seed;
    private final Map<RegionPos, Future<?>> regionFutures = new ConcurrentHashMap();
    public final Map<RegionPos, RailwayMap> regionRailways = new ConcurrentHashMap<RegionPos, RailwayMap>();
    public final Map<RegionPos, int[][]> regionHeightMap = new ConcurrentHashMap<RegionPos, int[][]>();
    private final LinkedBlockingQueue<Runnable> regionRailwayLoadQueue = new LinkedBlockingQueue();
    private final ThreadPoolExecutor regionRailwayLoadPoolExecutor = new ThreadPoolExecutor(64, 1024, 1L, TimeUnit.DAYS, this.regionRailwayLoadQueue);
    private final WorldGenRegion level;

    private RailwayBuilder(WorldGenRegion level) {
        this.level = level;
    }

    public static synchronized RailwayBuilder getInstance(long seed, WorldGenRegion level) {
        if (instance == null || RailwayBuilder.seed != seed) {
            instance = new RailwayBuilder(level);
            RailwayBuilder.seed = seed;
        }
        return instance;
    }

    public static synchronized RailwayBuilder getInstance(long seed) {
        if (instance == null || RailwayBuilder.seed != seed) {
            return null;
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateRailway(RegionPos regionPos) {
        if (this.regionRailways.containsKey(regionPos)) {
            return;
        }
        ModSaveData data = ModSaveData.get((Level)Objects.requireNonNull(this.level.getServer()).getLevel(ServerLevel.OVERWORLD));
        RailwayMap savedData = data.getRailwayMap(regionPos);
        if (savedData != null) {
            this.regionRailways.put(regionPos, savedData);
            Tongdarailway.LOGGER.info("Region {} Done! Read From Local Data", (Object)regionPos);
            return;
        }
        try {
            if (!this.regionFutures.containsKey(regionPos)) {
                Future<?> f = this.regionRailwayLoadPoolExecutor.submit(() -> {
                    RailwayMap railwayMap = new RailwayMap(regionPos);
                    railwayMap.startPlanningRoutes(this.level);
                    this.regionRailways.put(regionPos, railwayMap);
                    data.putRailwayMap(regionPos, railwayMap);
                });
                this.regionFutures.put(regionPos, f);
            }
            this.regionFutures.get(regionPos).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Tongdarailway.LOGGER.error(e.getMessage());
        }
        finally {
            this.regionFutures.remove(regionPos);
        }
    }
}

