/*
 * Decompiled with CFR 0.152.
 */
package com.hxzhitang.tongdarailway.railway;

import com.hxzhitang.tongdarailway.railway.RegionPos;
import com.hxzhitang.tongdarailway.railway.planner.RoutePlanner;
import com.hxzhitang.tongdarailway.railway.planner.StationPlanner;
import com.hxzhitang.tongdarailway.structure.TrackPutInfo;
import com.hxzhitang.tongdarailway.util.AStarPathfinder;
import com.hxzhitang.tongdarailway.util.CurveRoute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class RailwayMap {
    public static final int samplingNum = 2;
    public final RegionPos regionPos;
    public final Map<ChunkPos, Set<CurveRoute.CompositeCurve>> routeMap = new ConcurrentHashMap<ChunkPos, Set<CurveRoute.CompositeCurve>>();
    public final List<StationPlanner.StationGenInfo> stations = new ArrayList<StationPlanner.StationGenInfo>();
    public final Map<ChunkPos, List<TrackPutInfo>> trackMap = new ConcurrentHashMap<ChunkPos, List<TrackPutInfo>>();

    public RailwayMap(RegionPos regionPos) {
        this.regionPos = regionPos;
    }

    public void startPlanningRoutes(WorldGenRegion level) {
        RoutePlanner routePlanner = new RoutePlanner(this.regionPos);
        int[][] costMap = routePlanner.getCostMap(level);
        StationPlanner stationPlanner = new StationPlanner(this.regionPos);
        this.stations.addAll(StationPlanner.generateStation(this.regionPos, level.getLevel(), level.getSeed()));
        List<StationPlanner.ConnectionGenInfo> connections = stationPlanner.generateConnections(level.getLevel(), level.getSeed());
        for (StationPlanner.ConnectionGenInfo connection : connections) {
            int[] picStart = AStarPathfinder.world2PicPos(connection.connectStart(), this.regionPos);
            int[] picEnd = AStarPathfinder.world2PicPos(connection.connectEnd(), this.regionPos);
            List<int[]> way = AStarPathfinder.findPath(costMap, picStart, picEnd, (x, y) -> {
                int scopeLimit = RailwayMap.scopeLimit(x, y, picStart, picEnd);
                int heightLimit = costMap[x][y] < level.getSeaLevel() + 2 ? 100 : 0;
                return scopeLimit + heightLimit;
            });
            RoutePlanner.ResultWay route = routePlanner.getWay(way, costMap, connection, level.getLevel());
            this.putChunk(route);
        }
    }

    private void putChunk(RoutePlanner.ResultWay route) {
        for (CurveRoute.CurveSegment segment : route.way().getSegments()) {
            for (CurveRoute.Point3D p : segment.rasterize(16)) {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        int cx = (int)Math.floor(p.x) + i;
                        int cz = (int)Math.floor(p.z) + j;
                        if (cx < this.regionPos.x() * 128 || cx >= (this.regionPos.x() + 1) * 128 || cz < this.regionPos.z() * 128 || cz >= (this.regionPos.z() + 1) * 128) continue;
                        this.routeMap.computeIfAbsent(new ChunkPos(cx, cz), k -> new HashSet()).add(route.way());
                    }
                }
            }
        }
        for (TrackPutInfo track : route.trackPutInfos()) {
            BlockPos pos = track.pos();
            this.trackMap.computeIfAbsent(new ChunkPos(Math.floorDiv(pos.getX(), 16), Math.floorDiv(pos.getZ(), 16)), k -> new ArrayList()).add(track);
        }
    }

    public static int scopeLimit(int x, int z, int[] picStart, int[] picEnd) {
        double py;
        int maxCost = 10000;
        int A = 64;
        double length = new Vec2((float)(picEnd[0] - picStart[0]), (float)(picEnd[1] - picStart[1])).length();
        Vec3 p = new Vec3((double)x, 0.0, (double)z);
        Vec3 va = new Vec3((double)(picEnd[0] - picStart[0]), 0.0, (double)(picEnd[1] - picStart[1])).normalize();
        Vec3 vert = new Vec3(0.0, 1.0, 0.0);
        Vec3 vb = va.cross(vert);
        double a = p.dot(va) / length;
        if (a < 0.0 || a > 1.0) {
            return maxCost;
        }
        double b = Math.abs(p.dot(vb));
        if (b > (py = (double)A * Math.sin(Math.PI * a))) {
            return maxCost;
        }
        return 0;
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.put("RegionPos", (Tag)this.regionPos.toNBT());
        ListTag stationTag = new ListTag();
        this.stations.forEach(station -> stationTag.add((Object)station.toNBT()));
        nbt.put("Stations", (Tag)stationTag);
        ArrayList palette = new ArrayList();
        ListTag routeMapTag = new ListTag();
        this.routeMap.forEach((pos, routes) -> {
            CompoundTag chunkNbt = new CompoundTag();
            chunkNbt.putInt("ChunkPosX", pos.x);
            chunkNbt.putInt("ChunkPosZ", pos.z);
            ListTag routesTag = new ListTag();
            for (CurveRoute.CompositeCurve route : routes) {
                int index;
                if (palette.contains(route)) {
                    index = palette.indexOf(route);
                } else {
                    palette.add(route);
                    index = palette.size() - 1;
                }
                routesTag.add((Object)IntTag.valueOf((int)index));
            }
            chunkNbt.put("Routes", (Tag)routesTag);
            routeMapTag.add((Object)chunkNbt);
        });
        ListTag paletteTag = new ListTag();
        for (CurveRoute.CompositeCurve route : palette) {
            paletteTag.add((Object)route.toNBT());
        }
        nbt.put("RouteMap", (Tag)routeMapTag);
        nbt.put("RoutePalette", (Tag)paletteTag);
        ListTag trackMapTag = new ListTag();
        this.trackMap.forEach((pos, tracks) -> {
            CompoundTag chunkNbt = new CompoundTag();
            chunkNbt.putInt("ChunkPosX", pos.x);
            chunkNbt.putInt("ChunkPosZ", pos.z);
            ListTag tracksTag = new ListTag();
            for (TrackPutInfo track : tracks) {
                tracksTag.add((Object)track.toNBT());
            }
            chunkNbt.put("Tracks", (Tag)tracksTag);
            trackMapTag.add((Object)chunkNbt);
        });
        nbt.put("TrackMap", (Tag)trackMapTag);
        return nbt;
    }

    public static RailwayMap fromNBT(CompoundTag nbt) {
        ListTag trackTag;
        RegionPos regionPos = RegionPos.fromNBT((ListTag)nbt.get("RegionPos"));
        RailwayMap railwayMap = new RailwayMap(regionPos);
        ListTag stationTag = (ListTag)nbt.get("Stations");
        if (stationTag != null) {
            for (Tag tag : stationTag) {
                StationPlanner.StationGenInfo station = StationPlanner.StationGenInfo.fromNBT((CompoundTag)tag);
                railwayMap.stations.add(station);
            }
        }
        ListTag routeTag = (ListTag)nbt.get("RouteMap");
        ListTag paletteTag = (ListTag)nbt.get("RoutePalette");
        ArrayList<CurveRoute.CompositeCurve> palette = new ArrayList<CurveRoute.CompositeCurve>();
        if (paletteTag != null && routeTag != null) {
            for (Tag tag : paletteTag) {
                palette.add(CurveRoute.CompositeCurve.fromNBT((ListTag)tag));
            }
            for (Tag tag : routeTag) {
                CompoundTag chunkNbt = (CompoundTag)tag;
                ChunkPos chunkPos = new ChunkPos(chunkNbt.getInt("ChunkPosX"), chunkNbt.getInt("ChunkPosZ"));
                if (!chunkNbt.contains("Routes")) continue;
                HashSet<CurveRoute.CompositeCurve> routes = new HashSet<CurveRoute.CompositeCurve>();
                for (Tag tag1 : chunkNbt.getList("Routes", 3)) {
                    int index = ((IntTag)tag1).getAsInt();
                    CurveRoute.CompositeCurve route = (CurveRoute.CompositeCurve)palette.get(index);
                    routes.add(route);
                }
                railwayMap.routeMap.put(chunkPos, routes);
            }
        }
        if ((trackTag = (ListTag)nbt.get("TrackMap")) != null) {
            for (Tag tag : trackTag) {
                CompoundTag chunkNbt = (CompoundTag)tag;
                ChunkPos chunkPos = new ChunkPos(chunkNbt.getInt("ChunkPosX"), chunkNbt.getInt("ChunkPosZ"));
                if (!chunkNbt.contains("Tracks")) continue;
                ArrayList<TrackPutInfo> tracks = new ArrayList<TrackPutInfo>();
                for (Tag tag1 : chunkNbt.getList("Tracks", 10)) {
                    TrackPutInfo track = TrackPutInfo.fromNBT((CompoundTag)tag1);
                    tracks.add(track);
                }
                railwayMap.trackMap.put(chunkPos, tracks);
            }
        }
        return railwayMap;
    }
}

