/*
 * Decompiled with CFR 0.152.
 */
package com.hxzhitang.tongdarailway.railway.planner;

import com.hxzhitang.tongdarailway.railway.RegionPos;
import com.hxzhitang.tongdarailway.structure.StationManager;
import com.hxzhitang.tongdarailway.structure.StationStructure;
import com.hxzhitang.tongdarailway.util.MyMth;
import com.hxzhitang.tongdarailway.util.MyRandom;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.phys.Vec3;

public class StationPlanner {
    private final RegionPos regionPos;

    public StationPlanner(RegionPos regionPos) {
        this.regionPos = regionPos;
    }

    public static List<StationGenInfo> generateStation(RegionPos regionPos, ServerLevel level, long seed) {
        int placeH;
        StationStructure station;
        ChunkGenerator gen = level.getChunkSource().getGenerator();
        RandomState cfg = level.getChunkSource().randomState();
        long regionSeed = seed + (long)regionPos.hashCode();
        ArrayList<StationGenInfo> result = new ArrayList<StationGenInfo>();
        int[] pos = MyRandom.generatePoints(regionSeed, 128);
        ChunkPos chunkPos = new ChunkPos(MyMth.chunkPosXFromRegionPos(regionPos, pos[0]), MyMth.chunkPosZFromRegionPos(regionPos, pos[1]));
        int x = chunkPos.getBlockX(0);
        int z = chunkPos.getBlockZ(0);
        int y = gen.getBaseHeight(x, z, Heightmap.Types.WORLD_SURFACE, (LevelHeightAccessor)level, cfg);
        int h = Math.max(y, level.getSeaLevel());
        if ((h = Math.min(h, level.getSeaLevel() + 100)) < y - 10) {
            station = StationManager.getRandomUnderGroundStation(regionSeed);
            placeH = h;
        } else {
            station = StationManager.getRandomNormalStation(regionSeed);
            placeH = h - 10;
        }
        result.add(new StationGenInfo(station, new BlockPos(x, placeH, z)));
        return result;
    }

    public List<ConnectionGenInfo> generateConnections(ServerLevel level, long seed) {
        ArrayList<ConnectionGenInfo> result = new ArrayList<ConnectionGenInfo>();
        List<StationGenInfo> thisStations = StationPlanner.generateStation(this.regionPos, level, seed);
        List<StationGenInfo> north = StationPlanner.generateStation(new RegionPos(this.regionPos.x(), this.regionPos.z() - 1), level, seed);
        List<StationGenInfo> south = StationPlanner.generateStation(new RegionPos(this.regionPos.x(), this.regionPos.z() + 1), level, seed);
        List<StationGenInfo> east = StationPlanner.generateStation(new RegionPos(this.regionPos.x() + 1, this.regionPos.z()), level, seed);
        List<StationGenInfo> west = StationPlanner.generateStation(new RegionPos(this.regionPos.x() - 1, this.regionPos.z()), level, seed);
        List<StationStructure.Exit> thisAssignedExits = this.assignExits(this.getExitsPos(thisStations));
        List<StationStructure.Exit> northAssignedExits = this.assignExits(this.getExitsPos(north));
        List<StationStructure.Exit> southAssignedExits = this.assignExits(this.getExitsPos(south));
        List<StationStructure.Exit> eastAssignedExits = this.assignExits(this.getExitsPos(east));
        List<StationStructure.Exit> westAssignedExits = this.assignExits(this.getExitsPos(west));
        result.add(ConnectionGenInfo.getConnectionInfo(thisAssignedExits.get(3), eastAssignedExits.get(2), new Vec3(1.0, 0.0, 0.0)));
        result.add(ConnectionGenInfo.getConnectionInfo(westAssignedExits.get(3), thisAssignedExits.get(2), new Vec3(1.0, 0.0, 0.0)));
        result.add(ConnectionGenInfo.getConnectionInfo(northAssignedExits.get(1), thisAssignedExits.get(0), new Vec3(0.0, 0.0, 1.0)));
        result.add(ConnectionGenInfo.getConnectionInfo(thisAssignedExits.get(1), southAssignedExits.get(0), new Vec3(0.0, 0.0, 1.0)));
        return result;
    }

    private List<StationStructure.Exit> getExitsPos(List<StationGenInfo> stations) {
        ArrayList<StationStructure.Exit> exits = new ArrayList<StationStructure.Exit>();
        for (StationGenInfo station : stations) {
            BlockPos placePos = station.placePos;
            for (StationStructure.Exit exit : station.stationStructure.getExits()) {
                BlockPos offset = exit.exitPos();
                exits.add(new StationStructure.Exit(placePos.offset((Vec3i)offset), exit.dir()));
            }
        }
        return exits;
    }

    private List<StationStructure.Exit> assignExits(List<StationStructure.Exit> exits) {
        if (exits.size() < 4) {
            return exits;
        }
        ArrayList<StationStructure.Exit> copy = new ArrayList<StationStructure.Exit>(exits);
        ArrayList<StationStructure.Exit> result = new ArrayList<StationStructure.Exit>();
        copy.sort(Comparator.comparingDouble(e -> {
            int z = e.exitPos().getZ();
            Random random = new Random(751049 + z);
            double off = random.nextDouble() * 2.0 - 1.0;
            return (double)z + off;
        }));
        result.add((StationStructure.Exit)copy.removeFirst());
        result.add((StationStructure.Exit)copy.removeLast());
        copy.sort(Comparator.comparingDouble(e -> {
            int x = e.exitPos().getX();
            Random random = new Random(751052 + x);
            double off = random.nextDouble() * 2.0 - 1.0;
            return (double)x + off;
        }));
        result.add((StationStructure.Exit)copy.removeFirst());
        result.add((StationStructure.Exit)copy.removeLast());
        HashSet addedExits = new HashSet(result);
        for (StationStructure.Exit exit : exits) {
            if (addedExits.contains(exit)) continue;
            result.add(exit);
        }
        return result;
    }

    private static int[] getConnectStart(BlockPos exitPos, Vec3 dir, Vec3 offset, Vec3 exitDir) {
        Vec3 pos = Vec3.atCenterOf((Vec3i)exitPos);
        Vec3 addOff = exitDir.scale(15.0);
        Vec3 start = pos.add(dir.scale(15.0).add(addOff));
        return new int[]{(int)start.x, (int)start.z, exitPos.getY()};
    }

    public record StationGenInfo(StationStructure stationStructure, BlockPos placePos) {
        public CompoundTag toNBT() {
            CompoundTag tag = new CompoundTag();
            tag.putInt("id", this.stationStructure.getId());
            tag.putString("type", this.stationStructure.getType().name());
            tag.putInt("x", this.placePos.getX());
            tag.putInt("y", this.placePos.getY());
            tag.putInt("z", this.placePos.getZ());
            return tag;
        }

        public static StationGenInfo fromNBT(CompoundTag tag) {
            int id = tag.getInt("id");
            int x = tag.getInt("x");
            int y = tag.getInt("y");
            int z = tag.getInt("z");
            StationStructure.StationType type = StationStructure.StationType.valueOf(tag.getString("type"));
            StationStructure stationStructure = null;
            switch (type) {
                case NORMAL: {
                    if (!StationManager.normalStation.containsKey(id)) break;
                    stationStructure = StationManager.normalStation.get(id);
                    break;
                }
                case UNDER_GROUND: {
                    if (!StationManager.undergroundStation.containsKey(id)) break;
                    stationStructure = StationManager.undergroundStation.get(id);
                }
            }
            return new StationGenInfo(stationStructure, new BlockPos(x, y, z));
        }
    }

    public record ConnectionGenInfo(Vec3 start, Vec3 startDir, Vec3 end, Vec3 endDir, int[] connectStart, int[] connectEnd) {
        public static ConnectionGenInfo getConnectionInfo(StationStructure.Exit A, StationStructure.Exit B, Vec3 exitDir) {
            Vec3 APos = new Vec3((double)A.exitPos().getX(), (double)A.exitPos().getY(), (double)A.exitPos().getZ());
            Vec3 BPos = new Vec3((double)B.exitPos().getX(), (double)B.exitPos().getY(), (double)B.exitPos().getZ());
            return new ConnectionGenInfo(APos, A.dir(), BPos, B.dir(), StationPlanner.getConnectStart(A.exitPos(), A.dir(), BPos.subtract(APos), exitDir), StationPlanner.getConnectStart(B.exitPos(), B.dir(), APos.subtract(BPos), exitDir.reverse()));
        }
    }
}

