/*
 * Decompiled with CFR 0.152.
 */
package com.hxzhitang.tongdarailway.structure;

import com.hxzhitang.tongdarailway.Tongdarailway;
import com.hxzhitang.tongdarailway.structure.VoxelGrid;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RailwayTemplate {
    private VoxelGrid voxelGrid;
    private int roadbedHeight = 0;
    private int dataVersion;

    public RailwayTemplate(Path path) {
        try (DataInputStream stream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(Files.newInputStream(path, StandardOpenOption.READ))));){
            CompoundTag rootTag = NbtIo.read((DataInput)stream, (NbtAccounter)NbtAccounter.create((long)0x20000000L));
            this.voxelGrid = this.parseStructureNBT(rootTag);
        }
        catch (Exception e) {
            Tongdarailway.LOGGER.error(e.getMessage());
        }
    }

    public RailwayTemplate(CompoundTag nbt) {
        this.voxelGrid = this.parseStructureNBT(nbt);
    }

    public int getWidth() {
        return this.voxelGrid.getWidth();
    }

    public int getHeight() {
        return this.voxelGrid.getHeight();
    }

    public int getDepth() {
        return this.voxelGrid.getDepth();
    }

    public int getUpperBound() {
        return this.voxelGrid.getHeight() - this.roadbedHeight + 1;
    }

    public int getLowerBound() {
        return -(this.roadbedHeight + 1);
    }

    public BlockState getBlockState(double x, double y, double z) {
        int originalX = (int)Math.floor(x) % this.getWidth();
        int originalY = (int)Math.round(y + (double)this.roadbedHeight + 1.0);
        int originalZ = (int)Math.floor(z + (double)this.getDepth() / 2.0);
        return this.voxelGrid.getBlockState(originalX, originalY, originalZ);
    }

    private VoxelGrid parseStructureNBT(CompoundTag rootTag) {
        if (rootTag == null) {
            return null;
        }
        this.dataVersion = rootTag.getInt("DataVersion");
        ListTag sizeTag = rootTag.getList("size", 3);
        int x = sizeTag.getInt(0);
        int y = sizeTag.getInt(1);
        int z = sizeTag.getInt(2);
        BlockPos size = new BlockPos(x, y, z);
        List<BlockState> palette = this.parsePalette(rootTag.getList("palette", 10));
        int cornerStructureBlockIndex = -1;
        ListTag paletteTag = rootTag.getList("palette", 10);
        for (int i = 0; i < paletteTag.size(); ++i) {
            CompoundTag propertiesTag;
            CompoundTag blockTag = paletteTag.getCompound(i);
            if (!blockTag.contains("Name") || !blockTag.getString("Name").equals("minecraft:structure_block") || !blockTag.contains("Properties", 10) || !(propertiesTag = blockTag.getCompound("Properties")).contains("mode") || !propertiesTag.getString("mode").equals("corner")) continue;
            cornerStructureBlockIndex = i;
            break;
        }
        if (cornerStructureBlockIndex == -1) {
            Tongdarailway.LOGGER.warn("The road position cannot be determined, and no corner structure block has been found.");
        }
        int[][][] voxelGrid = this.parseBlocks(rootTag.getList("blocks", 10), size, palette, cornerStructureBlockIndex);
        return new VoxelGrid(palette, voxelGrid, size);
    }

    private List<BlockState> parsePalette(ListTag paletteTag) {
        ArrayList<BlockState> palette = new ArrayList<BlockState>();
        palette.add(Blocks.STRUCTURE_VOID.defaultBlockState());
        for (int i = 0; i < paletteTag.size(); ++i) {
            CompoundTag blockTag = paletteTag.getCompound(i);
            BlockState blockState = this.parseBlockState(blockTag);
            palette.add(blockState);
        }
        return palette;
    }

    private BlockState parseBlockState(CompoundTag blockTag) {
        try {
            String blockName = blockTag.getString("Name");
            ResourceLocation blockId = ResourceLocation.parse((String)blockName);
            Block block = (Block)BuiltInRegistries.BLOCK.get(blockId);
            BlockState blockState = block.defaultBlockState();
            if (blockTag.contains("Properties", 10)) {
                CompoundTag propertiesTag = blockTag.getCompound("Properties");
                blockState = this.applyProperties(blockState, propertiesTag);
            }
            return blockState;
        }
        catch (Exception e) {
            Tongdarailway.LOGGER.error(e.getMessage());
            return Blocks.STONE.defaultBlockState();
        }
    }

    private BlockState applyProperties(BlockState blockState, CompoundTag propertiesTag) {
        BlockState resultState = blockState;
        for (String propertyName : propertiesTag.getAllKeys()) {
            String propertyValue = propertiesTag.getString(propertyName);
            Optional<Property<?>> property = this.findProperty(blockState, propertyName);
            if (!property.isPresent()) continue;
            resultState = this.setPropertyValue(resultState, property.get(), propertyValue);
        }
        return resultState;
    }

    private Optional<Property<?>> findProperty(BlockState blockState, String propertyName) {
        return blockState.getProperties().stream().filter(prop -> prop.getName().equals(propertyName)).findFirst();
    }

    private <T extends Comparable<T>> BlockState setPropertyValue(BlockState blockState, Property<T> property, String value) {
        Optional propertyValue = property.getValue(value);
        if (propertyValue.isPresent()) {
            return (BlockState)blockState.setValue(property, (Comparable)propertyValue.get());
        }
        throw new IllegalArgumentException("\u65e0\u6548\u7684\u5c5e\u6027\u503c: " + value + " \u5bf9\u4e8e\u5c5e\u6027: " + property.getName());
    }

    private int[][][] parseBlocks(ListTag blocksTag, BlockPos size, List<BlockState> palette, int cornerStructureBlockIndex) {
        int[][][] voxelGrid = new int[size.getX()][size.getY()][size.getZ()];
        for (int x = 0; x < size.getX(); ++x) {
            for (int y = 0; y < size.getY(); ++y) {
                for (int z = 0; z < size.getZ(); ++z) {
                    voxelGrid[x][y][z] = 0;
                }
            }
        }
        for (int i = 0; i < blocksTag.size(); ++i) {
            CompoundTag blockTag = blocksTag.getCompound(i);
            ListTag posTag = blockTag.getList("pos", 3);
            int x = posTag.getInt(0);
            int y = posTag.getInt(1);
            int z = posTag.getInt(2);
            int state = blockTag.getInt("state");
            if (x < 0 || x >= size.getX() || y < 0 || y >= size.getY() || z < 0 || z >= size.getZ()) continue;
            if (state == cornerStructureBlockIndex) {
                int airState;
                this.roadbedHeight = y - 1;
                if (palette.contains(Blocks.AIR.defaultBlockState())) {
                    airState = palette.indexOf(Blocks.AIR.defaultBlockState());
                } else {
                    palette.add(Blocks.AIR.defaultBlockState());
                    airState = palette.size() - 1;
                }
                voxelGrid[x][y][z] = airState;
                continue;
            }
            voxelGrid[x][y][z] = state + 1;
        }
        return voxelGrid;
    }

    public int getDataVersion() {
        return this.dataVersion;
    }
}

