/*
 * Decompiled with CFR 0.152.
 */
package com.hxzhitang.tongdarailway.structure;

import com.hxzhitang.tongdarailway.Tongdarailway;
import com.hxzhitang.tongdarailway.structure.RailwayTemplate;
import com.hxzhitang.tongdarailway.util.MyRandom;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;

@EventBusSubscriber
public class RoadbedManager {
    private static final Map<ResourceLocation, CompoundTag> LOADED_STRUCTURES = new HashMap<ResourceLocation, CompoundTag>();
    public static final Map<Integer, RailwayTemplate> ground = new HashMap<Integer, RailwayTemplate>();
    public static final Map<Integer, RailwayTemplate> tunnel = new HashMap<Integer, RailwayTemplate>();
    public static final Map<Integer, RailwayTemplate> bridge = new HashMap<Integer, RailwayTemplate>();

    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new NBTResourceReloadListener());
    }

    public static RailwayTemplate getRandomGround(long seed) {
        if (ground.isEmpty()) {
            return null;
        }
        return MyRandom.getRandomValueFromMap(ground, 84270L + seed * 10000L);
    }

    public static RailwayTemplate getRandomTunnel(long seed) {
        if (tunnel.isEmpty()) {
            return null;
        }
        return MyRandom.getRandomValueFromMap(tunnel, 711553L + seed * 10000L);
    }

    public static RailwayTemplate getRandomBridge(long seed) {
        if (bridge.isEmpty()) {
            return null;
        }
        return MyRandom.getRandomValueFromMap(bridge, 90318L + seed * 10000L);
    }

    private static class NBTResourceReloadListener
    extends SimplePreparableReloadListener<Map<ResourceLocation, CompoundTag>> {
        private NBTResourceReloadListener() {
        }

        protected Map<ResourceLocation, CompoundTag> prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
            HashMap<ResourceLocation, CompoundTag> nbtData = new HashMap<ResourceLocation, CompoundTag>();
            resourceManager.listResources("structure/railway", location -> location.getPath().endsWith(".nbt")).forEach((location, resource) -> {
                try {
                    InputStream resourceStream = ((Resource)resourceManager.getResource(location).orElseThrow()).open();
                    try (DataInputStream stream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(resourceStream)));){
                        CompoundTag rootTag = NbtIo.read((DataInput)stream, (NbtAccounter)NbtAccounter.create((long)0x20000000L));
                        nbtData.put((ResourceLocation)location, rootTag);
                    }
                    catch (Exception e) {
                        Tongdarailway.LOGGER.error(e.getMessage());
                    }
                }
                catch (Exception e) {
                    Tongdarailway.LOGGER.error(e.getMessage());
                }
            });
            return nbtData;
        }

        protected void apply(Map<ResourceLocation, CompoundTag> prepared, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
            LOADED_STRUCTURES.clear();
            LOADED_STRUCTURES.putAll(prepared);
            this.init();
            Tongdarailway.LOGGER.info("Loaded {} NBT structures from resources", (Object)LOADED_STRUCTURES.size());
        }

        private void init() {
            LOADED_STRUCTURES.forEach((location, compoundTag) -> {
                Tongdarailway.LOGGER.info("Loading railway template: {}", (Object)location.getPath());
                int id = location.getPath().hashCode();
                String[] subString = location.getPath().split("structure/railway/");
                if (subString.length == 2) {
                    switch (subString[1].split("/")[0]) {
                        case "ground": {
                            ground.put(id, new RailwayTemplate((CompoundTag)compoundTag));
                            break;
                        }
                        case "tunnel": {
                            tunnel.put(id, new RailwayTemplate((CompoundTag)compoundTag));
                            break;
                        }
                        case "bridge": {
                            bridge.put(id, new RailwayTemplate((CompoundTag)compoundTag));
                        }
                    }
                }
            });
        }
    }
}

