/*
 * Decompiled with CFR 0.152.
 */
package com.hxzhitang.tongdarailway.structure;

import com.hxzhitang.tongdarailway.Tongdarailway;
import com.hxzhitang.tongdarailway.structure.StationStructure;
import com.hxzhitang.tongdarailway.util.MyRandom;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;

@EventBusSubscriber
public class StationManager {
    private static final Map<ResourceLocation, CompoundTag> LOADED_STRUCTURES = new HashMap<ResourceLocation, CompoundTag>();
    public static final Map<Integer, StationStructure> normalStation = new HashMap<Integer, StationStructure>();
    public static final Map<Integer, StationStructure> undergroundStation = new HashMap<Integer, StationStructure>();

    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new NBTResourceReloadListener());
    }

    public static StationStructure getRandomNormalStation(long seed) {
        if (normalStation.isEmpty()) {
            return null;
        }
        return MyRandom.getRandomValueFromMap(normalStation, 84269L + seed * 10000L);
    }

    public static StationStructure getRandomUnderGroundStation(long seed) {
        if (undergroundStation.isEmpty()) {
            return null;
        }
        return MyRandom.getRandomValueFromMap(undergroundStation, 711551L + seed * 10000L);
    }

    private static class NBTResourceReloadListener
    extends SimplePreparableReloadListener<Map<ResourceLocation, CompoundTag>> {
        private NBTResourceReloadListener() {
        }

        protected Map<ResourceLocation, CompoundTag> prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
            HashMap<ResourceLocation, CompoundTag> nbtData = new HashMap<ResourceLocation, CompoundTag>();
            resourceManager.listResources("structure/station", location -> location.getPath().endsWith(".nbt")).forEach((location, resource) -> {
                try {
                    InputStream resourceStream = ((Resource)resourceManager.getResource(location).orElseThrow()).open();
                    try (DataInputStream stream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(resourceStream)));){
                        CompoundTag rootTag = NbtIo.read((DataInput)stream, (NbtAccounter)NbtAccounter.create((long)0x20000000L));
                        nbtData.put((ResourceLocation)location, rootTag);
                    }
                    catch (Exception e) {
                        Tongdarailway.LOGGER.error(e.getMessage());
                    }
                }
                catch (Exception e) {
                    Tongdarailway.LOGGER.error(e.getMessage());
                }
            });
            return nbtData;
        }

        protected void apply(Map<ResourceLocation, CompoundTag> prepared, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
            LOADED_STRUCTURES.clear();
            LOADED_STRUCTURES.putAll(prepared);
            this.init();
            Tongdarailway.LOGGER.info("Loaded {} NBT structures from resources", (Object)LOADED_STRUCTURES.size());
        }

        private void init() {
            LOADED_STRUCTURES.forEach((location, compoundTag) -> {
                Tongdarailway.LOGGER.info("Loading station template: {}", (Object)location.getPath());
                int id = location.getPath().hashCode();
                String[] subString = location.getPath().split("structure/station/");
                if (subString.length == 2) {
                    switch (subString[1].split("/")[0]) {
                        case "normal": {
                            StationStructure normalStation = new StationStructure((CompoundTag)compoundTag, id, StationStructure.StationType.NORMAL);
                            if (normalStation.getExitCount() == 4) {
                                normalStation.put(id, normalStation);
                                break;
                            }
                            Tongdarailway.LOGGER.warn("Invalid station structure. Exits count must 4: {} (exit count: {})", (Object)location.getPath(), (Object)normalStation.getExitCount());
                            break;
                        }
                        case "underground": {
                            StationStructure undergroundStation = new StationStructure((CompoundTag)compoundTag, id, StationStructure.StationType.UNDER_GROUND);
                            if (undergroundStation.getExitCount() == 4) {
                                undergroundStation.put(id, undergroundStation);
                                break;
                            }
                            Tongdarailway.LOGGER.warn("Invalid station structure. Exits count must 4: {} (exit count: {})", (Object)location.getPath(), (Object)undergroundStation.getExitCount());
                        }
                    }
                }
            });
        }
    }
}

