/*
 * Decompiled with CFR 0.152.
 */
package com.hxzhitang.tongdarailway.structure;

import com.hxzhitang.tongdarailway.Tongdarailway;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;

public class StationStructure {
    private ListTag palette = null;
    private BlockPos size = null;
    private final Map<ChunkPos, CompoundTag> segments = new HashMap<ChunkPos, CompoundTag>();
    private int dataVersion = 0;
    private final List<Exit> exits = new ArrayList<Exit>();
    private final int id;
    private final StationType type;

    public List<Exit> getExits() {
        return this.exits;
    }

    public int getExitCount() {
        return this.exits.size();
    }

    public StationType getType() {
        return this.type;
    }

    private StationStructure(ResourceManager resourceManager, String nameSpace, String path, int id, StationType type) {
        this.id = id;
        this.type = type;
        try {
            ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)nameSpace, (String)path);
            InputStream resourceStream = ((Resource)resourceManager.getResource(location).orElseThrow()).open();
            try (DataInputStream stream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(resourceStream)));){
                CompoundTag rootTag = NbtIo.read((DataInput)stream, (NbtAccounter)NbtAccounter.create((long)0x20000000L));
                this.parseStructureNBT(rootTag);
            }
            catch (Exception e) {
                Tongdarailway.LOGGER.error(e.getMessage());
            }
        }
        catch (Exception e) {
            Tongdarailway.LOGGER.error(e.getMessage());
        }
    }

    public StationStructure(CompoundTag rootTag, int id, StationType type) {
        this.id = id;
        this.type = type;
        this.parseStructureNBT(rootTag);
    }

    public void putSegment(WorldGenLevel level, ChunkPos thisChunkPos, BlockPos putPos) {
        ChunkPos putChunkPos = new ChunkPos(putPos);
        ChunkPos indexChunkPos = new ChunkPos(thisChunkPos.x - putChunkPos.x, thisChunkPos.z - putChunkPos.z);
        BlockPos pos = new BlockPos(thisChunkPos.getBlockX(0), putPos.getY(), thisChunkPos.getBlockZ(0));
        CompoundTag rootTag = this.segments.get(indexChunkPos);
        if (rootTag == null) {
            return;
        }
        StructurePlaceSettings placementSettings = new StructurePlaceSettings();
        StructureTemplate template = new StructureTemplate();
        template.load((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), rootTag);
        template.placeInWorld((ServerLevelAccessor)level, pos, pos, placementSettings, level.getLevel().random, 2);
    }

    public int getId() {
        return this.id;
    }

    private void parseStructureNBT(CompoundTag rootTag) {
        if (rootTag == null) {
            return;
        }
        ListTag sizeTag = rootTag.getList("size", 3);
        int x = sizeTag.getInt(0);
        int y = sizeTag.getInt(1);
        int z = sizeTag.getInt(2);
        this.size = new BlockPos(x, y, z);
        this.palette = rootTag.getList("palette", 10);
        this.dataVersion = rootTag.getInt("DataVersion");
        List<CompoundTag> blocks = this.parseBlocks(rootTag.getList("blocks", 10));
        for (CompoundTag blockTag : blocks) {
            ListTag posTag = blockTag.getList("pos", 3);
            int bx = posTag.getInt(0);
            int by = posTag.getInt(1);
            int bz = posTag.getInt(2);
            ChunkPos chunkPos = new ChunkPos(Math.floorDiv(bx, 16), Math.floorDiv(bz, 16));
            CompoundTag newNBT = this.segments.computeIfAbsent(chunkPos, k -> {
                CompoundTag tag = new CompoundTag();
                ListTag size = new ListTag();
                size.add((Object)IntTag.valueOf((int)16));
                size.add((Object)IntTag.valueOf((int)this.size.getY()));
                size.add((Object)IntTag.valueOf((int)16));
                tag.put("size", (Tag)size);
                tag.put("entities", (Tag)new ListTag());
                tag.put("palette", (Tag)this.palette);
                tag.put("blocks", (Tag)new ListTag());
                tag.putInt("DataVersion", this.dataVersion);
                return tag;
            });
            CompoundTag tag = new CompoundTag();
            ListTag pos = new ListTag();
            pos.add((Object)IntTag.valueOf((int)Math.floorMod(bx, 16)));
            pos.add((Object)IntTag.valueOf((int)by));
            pos.add((Object)IntTag.valueOf((int)Math.floorMod(bz, 16)));
            tag.put("pos", (Tag)pos);
            tag.putInt("state", blockTag.getInt("state"));
            ListTag bTag = (ListTag)newNBT.get("blocks");
            if (bTag == null) continue;
            bTag.add((Object)tag);
            newNBT.put("blocks", (Tag)bTag);
        }
    }

    private List<CompoundTag> parseBlocks(ListTag blocksTag) {
        ArrayList<CompoundTag> blocks = new ArrayList<CompoundTag>();
        for (int i = 0; i < blocksTag.size(); ++i) {
            CompoundTag blockTag = blocksTag.getCompound(i);
            int index = blockTag.getInt("state");
            CompoundTag tag = (CompoundTag)this.palette.get(index);
            if (tag.getString("Name").equals("minecraft:jigsaw")) {
                CompoundTag properties = (CompoundTag)tag.get("Properties");
                if (properties == null) continue;
                String orientation = properties.getString("orientation");
                ListTag posTag = blockTag.getList("pos", 3);
                int bx = posTag.getInt(0);
                int by = posTag.getInt(1);
                int bz = posTag.getInt(2);
                BlockPos offsetPos = new BlockPos(bx, by, bz);
                switch (orientation) {
                    case "north_up": {
                        this.exits.add(new Exit(offsetPos, new Vec3(0.0, 0.0, -1.0)));
                        break;
                    }
                    case "south_up": {
                        this.exits.add(new Exit(offsetPos, new Vec3(0.0, 0.0, 1.0)));
                        break;
                    }
                    case "east_up": {
                        this.exits.add(new Exit(offsetPos, new Vec3(1.0, 0.0, 0.0)));
                        break;
                    }
                    case "west_up": {
                        this.exits.add(new Exit(offsetPos, new Vec3(-1.0, 0.0, 0.0)));
                    }
                }
                continue;
            }
            blocks.add(blockTag);
        }
        return blocks;
    }

    public static enum StationType {
        NORMAL,
        UNDER_GROUND;

    }

    public record Exit(BlockPos exitPos, Vec3 dir) {
    }
}

