/*
 * Decompiled with CFR 0.152.
 */
package com.hxzhitang.tongdarailway.structure;

import com.simibubi.create.content.trains.track.TrackShape;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec3;

public record TrackPutInfo(BlockPos pos, TrackShape shape, BezierInfo bezier, TrackShape endShape) {
    public static TrackPutInfo getByDir(BlockPos pos, Vec3 dir, BezierInfo bezier) {
        if (bezier != null) {
            return new TrackPutInfo(pos, TrackPutInfo.getShape(dir), bezier, TrackPutInfo.getShape(bezier.endAxis));
        }
        return new TrackPutInfo(pos, TrackPutInfo.getShape(dir), null, null);
    }

    private static TrackShape getShape(Vec3 dir) {
        TrackShape shape = TrackShape.XO;
        if (Math.abs(dir.x) < 1.0E-6) {
            shape = TrackShape.ZO;
        } else if (Math.abs(dir.z) < 1.0E-6) {
            shape = TrackShape.XO;
        } else if (dir.x * dir.z > 0.0) {
            shape = TrackShape.PD;
        } else if (dir.x * dir.z < 0.0) {
            shape = TrackShape.ND;
        }
        return shape;
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("x", this.pos.getX());
        nbt.putInt("y", this.pos.getY());
        nbt.putInt("z", this.pos.getZ());
        nbt.putString("shape", this.shape.name());
        if (this.bezier != null) {
            nbt.put("bezier", (Tag)this.bezier.toNbt());
            nbt.putString("endShape", this.endShape.name());
        }
        return nbt;
    }

    public static TrackPutInfo fromNBT(CompoundTag nbt) {
        BlockPos pos = new BlockPos(nbt.getInt("x"), nbt.getInt("y"), nbt.getInt("z"));
        TrackShape shape = TrackShape.valueOf((String)nbt.getString("shape"));
        BezierInfo bezier = null;
        TrackShape endShape = null;
        boolean hasBezier = nbt.contains("bezier");
        if (hasBezier) {
            bezier = BezierInfo.fromNbt(nbt.getCompound("bezier"));
            endShape = TrackShape.valueOf((String)nbt.getString("endShape"));
        }
        return new TrackPutInfo(pos, shape, bezier, endShape);
    }

    public record BezierInfo(Vec3 start, Vec3 startAxis, Vec3 endOffset, Vec3 endAxis) {
        public CompoundTag toNbt() {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("startX", this.start.x);
            nbt.putDouble("startY", this.start.y);
            nbt.putDouble("startZ", this.start.z);
            nbt.putDouble("startAxisX", this.startAxis.x);
            nbt.putDouble("startAxisY", this.startAxis.y);
            nbt.putDouble("startAxisZ", this.startAxis.z);
            nbt.putDouble("endOffsetX", this.endOffset.x);
            nbt.putDouble("endOffsetY", this.endOffset.y);
            nbt.putDouble("endOffsetZ", this.endOffset.z);
            nbt.putDouble("endAxisX", this.endAxis.x);
            nbt.putDouble("endAxisY", this.endAxis.y);
            nbt.putDouble("endAxisZ", this.endAxis.z);
            return nbt;
        }

        public static BezierInfo fromNbt(CompoundTag nbt) {
            return new BezierInfo(new Vec3(nbt.getDouble("startX"), nbt.getDouble("startY"), nbt.getDouble("startZ")), new Vec3(nbt.getDouble("startAxisX"), nbt.getDouble("startAxisY"), nbt.getDouble("startAxisZ")), new Vec3(nbt.getDouble("endOffsetX"), nbt.getDouble("endOffsetY"), nbt.getDouble("endOffsetZ")), new Vec3(nbt.getDouble("endAxisX"), nbt.getDouble("endAxisY"), nbt.getDouble("endAxisZ")));
        }
    }
}

