/*
 * Decompiled with CFR 0.152.
 */
package com.hxzhitang.tongdarailway.structure;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.state.BlockState;

class VoxelGrid {
    private final List<BlockState> palette;
    private final int[][][] voxelGrid;
    private final BlockPos size;
    public int offsetX = 0;
    public int offsetY = 0;
    public int offsetZ = 0;

    public VoxelGrid(List<BlockState> palette, int[][][] voxelGrid, BlockPos size) {
        this.palette = palette;
        this.voxelGrid = voxelGrid;
        this.size = size;
    }

    public VoxelGrid(List<BlockState> palette, BlockPos size) {
        this.palette = palette;
        this.voxelGrid = new int[size.getX()][size.getY()][size.getZ()];
        this.size = size;
    }

    public List<BlockState> getPalette() {
        return this.palette;
    }

    public int[][][] getVoxelGrid() {
        return this.voxelGrid;
    }

    public BlockPos getSize() {
        return this.size;
    }

    public int getWidth() {
        return this.size.getX();
    }

    public int getHeight() {
        return this.size.getY();
    }

    public int getDepth() {
        return this.size.getZ();
    }

    public ListTag getBlocks() {
        ListTag blocks = new ListTag();
        for (int i = 0; i < this.size.getX(); ++i) {
            for (int j = 0; j < this.size.getY(); ++j) {
                for (int k = 0; k < this.size.getZ(); ++k) {
                    if (this.voxelGrid[i][j][k] == 0) continue;
                    CompoundTag tag = new CompoundTag();
                    ListTag pos = new ListTag();
                    pos.add((Object)IntTag.valueOf((int)(i - this.offsetX)));
                    pos.add((Object)IntTag.valueOf((int)(j - this.offsetY)));
                    pos.add((Object)IntTag.valueOf((int)(k - this.offsetZ)));
                    tag.put("pos", (Tag)pos);
                    tag.putInt("state", this.voxelGrid[i][j][k] - 1);
                    blocks.add((Object)tag);
                }
            }
        }
        return blocks;
    }

    public ListTag getPaletteTag() {
        ListTag paletteTag = new ListTag();
        if (!this.palette.isEmpty()) {
            this.palette.removeFirst();
            for (BlockState block : this.palette) {
                CompoundTag tag = new CompoundTag();
                tag.putString("Name", BuiltInRegistries.BLOCK.getKey((Object)block.getBlock()).toString());
                paletteTag.add((Object)tag);
            }
        }
        return paletteTag;
    }

    public BlockState getBlockState(int x, int y, int z) {
        int paletteIndex;
        if (x >= 0 && x < this.size.getX() && y >= 0 && y < this.size.getY() && z >= 0 && z < this.size.getZ() && (paletteIndex = this.voxelGrid[x][y][z]) > 0 && paletteIndex < this.palette.size()) {
            return this.palette.get(paletteIndex);
        }
        return null;
    }

    public void setVoxel(int x, int y, int z, int value) {
        if (x >= 0 && x < this.size.getX() && y >= 0 && y < this.size.getY() && z >= 0 && z < this.size.getZ()) {
            this.voxelGrid[x][y][z] = value;
        }
    }

    public int getVoxel(int x, int y, int z) {
        if (x >= 0 && x < this.size.getX() && y >= 0 && y < this.size.getY() && z >= 0 && z < this.size.getZ()) {
            return this.voxelGrid[x][y][z];
        }
        return -1;
    }
}

