/*
 * Decompiled with CFR 0.152.
 */
package com.hxzhitang.tongdarailway.util;

import com.hxzhitang.tongdarailway.railway.RegionPos;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;

public class AStarPathfinder {
    private static final int[][] DIRECTIONS = new int[][]{{-1, 0}, {1, 0}, {0, -1}, {0, 1}, {-1, -1}, {-1, 1}, {1, -1}, {1, 1}};
    private static final double[] MOVEMENT_COST = new double[]{1.0, 1.0, 1.0, 1.0, 1.414, 1.414, 1.414, 1.414};

    public static List<int[]> findPath(int[][] image, int[] start, int[] end, AdditionalCostFunction additionalCostFunction) {
        double[][] gScore;
        if (image == null || image.length == 0 || image[0].length == 0) {
            return new ArrayList<int[]>();
        }
        int rows = image.length;
        int cols = image[0].length;
        if (!AStarPathfinder.isValidCoordinate(start[0], start[1], rows, cols) || !AStarPathfinder.isValidCoordinate(end[0], end[1], rows, cols)) {
            return new ArrayList<int[]>();
        }
        PriorityQueue<Node> openSet = new PriorityQueue<Node>(Comparator.comparingDouble(node -> node.f));
        for (double[] row : gScore = new double[rows][cols]) {
            Arrays.fill(row, Double.MAX_VALUE);
        }
        Node[][] cameFrom = new Node[rows][cols];
        Node startNode = new Node(start[0], start[1]);
        startNode.g = 0.0;
        startNode.h = AStarPathfinder.heuristic(start, end);
        startNode.f = startNode.g + startNode.h;
        gScore[start[0]][start[1]] = 0.0;
        openSet.offer(startNode);
        boolean[][] inOpenSet = new boolean[rows][cols];
        inOpenSet[start[0]][start[1]] = true;
        while (!openSet.isEmpty()) {
            Node current = openSet.poll();
            int currentX = current.x;
            int currentY = current.y;
            if (currentX == end[0] && currentY == end[1]) {
                return AStarPathfinder.reconstructPath(cameFrom, current);
            }
            inOpenSet[currentX][currentY] = false;
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                double pixelCost;
                double movementCost;
                double tentativeG;
                int[] direction = DIRECTIONS[i];
                int newX = currentX + direction[0];
                int newY = currentY + direction[1];
                if (!AStarPathfinder.isValidCoordinate(newX, newY, rows, cols) || !((tentativeG = current.g + (movementCost = MOVEMENT_COST[i]) + (pixelCost = (double)Math.abs(image[currentX][currentY] - image[newX][newY])) + additionalCostFunction.cost(currentX, currentY)) < gScore[newX][newY])) continue;
                Node neighbor = new Node(newX, newY);
                neighbor.g = tentativeG;
                neighbor.h = AStarPathfinder.heuristic(new int[]{newX, newY}, end);
                neighbor.f = neighbor.g + neighbor.h;
                cameFrom[newX][newY] = current;
                gScore[newX][newY] = tentativeG;
                if (inOpenSet[newX][newY]) continue;
                openSet.offer(neighbor);
                inOpenSet[newX][newY] = true;
            }
        }
        return new ArrayList<int[]>();
    }

    private static boolean isValidCoordinate(int x, int y, int rows, int cols) {
        return x >= 0 && x < rows && y >= 0 && y < cols;
    }

    private static double heuristic(int[] a, int[] b) {
        int dx = Math.abs(a[0] - b[0]);
        int dy = Math.abs(a[1] - b[1]);
        return Math.sqrt(dx * dx + dy * dy);
    }

    private static List<int[]> reconstructPath(Node[][] cameFrom, Node current) {
        ArrayList<int[]> path = new ArrayList<int[]>();
        while (current != null) {
            path.add(0, new int[]{current.x, current.y});
            current = cameFrom[current.x][current.y];
        }
        return path;
    }

    public static int[] world2PicPos(int[] worldPos, RegionPos centerRegionPos) {
        int wx = worldPos[0];
        int wz = worldPos[1];
        return new int[]{(wx - (centerRegionPos.x() - 1) * 128 * 16) * 2 / 16, (wz - (centerRegionPos.z() - 1) * 128 * 16) * 2 / 16};
    }

    public static int[] pic2RegionPos(int[] picPos) {
        int px = picPos[0];
        int pz = picPos[1];
        return new int[]{px - 256, pz - 256, picPos[2]};
    }

    static class Node {
        int x;
        int y;
        double g;
        double h;
        double f;

        Node(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    @FunctionalInterface
    public static interface AdditionalCostFunction {
        public double cost(int var1, int var2);
    }
}

