/*
 * Decompiled with CFR 0.152.
 */
package com.hxzhitang.tongdarailway.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class AdaptiveHeightSampler {
    private final double threshold;
    private final int maxLevel;
    private final int samplesPerNode;
    private QuadTree root;
    private final ExecutorService executor;
    private final HeightFunction heightFunction;
    private CountDownLatch latch = null;
    int count = 0;

    public AdaptiveHeightSampler(double threshold, int maxLevel, int samplesPerNode, HeightFunction heightFunction) {
        this.threshold = threshold;
        this.maxLevel = maxLevel;
        this.samplesPerNode = samplesPerNode;
        this.heightFunction = heightFunction;
        int coreCount = Runtime.getRuntime().availableProcessors();
        this.executor = Executors.newFixedThreadPool(coreCount);
    }

    public void buildQuadTree(double regionSize) throws InterruptedException {
        this.latch = new CountDownLatch(1);
        this.addCount();
        this.root = new QuadTree(this, 0.0, 0.0, regionSize, regionSize, 0);
        this.buildNode(this.root);
        this.latch.await();
    }

    private void buildNode(QuadTree node) {
        this.sampleNode(node);
        if (this.shouldSplit(node)) {
            this.splitNode(node);
            this.processChildrenInParallel(node);
        }
        this.subCount();
    }

    private void processChildrenInParallel(QuadTree parent) {
        for (int i = 0; i < 4; ++i) {
            this.addCount();
            QuadTree child = parent.children[i];
            this.executor.submit(() -> this.buildNode(child));
        }
    }

    private void sampleNode(QuadTree node) {
        int n = this.samplesPerNode;
        node.heightSamples = new double[n][n];
        node.minHeight = Double.MAX_VALUE;
        node.maxHeight = Double.MIN_VALUE;
        double stepX = (node.maxX - node.minX) / (double)(n - 1);
        double stepZ = (node.maxZ - node.minZ) / (double)(n - 1);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double height;
                double x = node.minX + (double)i * stepX;
                double z = node.minZ + (double)j * stepZ;
                node.heightSamples[i][j] = height = this.getHeight(x, z);
                node.minHeight = Math.min(node.minHeight, height);
                node.maxHeight = Math.max(node.maxHeight, height);
            }
        }
    }

    private boolean shouldSplit(QuadTree node) {
        if (node.level >= this.maxLevel) {
            return false;
        }
        double range = node.maxHeight - node.minHeight;
        return range > this.threshold;
    }

    private void splitNode(QuadTree node) {
        node.isLeaf = false;
        node.children = new QuadTree[4];
        double midX = (node.minX + node.maxX) / 2.0;
        double midZ = (node.minZ + node.maxZ) / 2.0;
        int nextLevel = node.level + 1;
        node.children[0] = new QuadTree(this, node.minX, node.minZ, midX, midZ, nextLevel);
        node.children[1] = new QuadTree(this, midX, node.minZ, node.maxX, midZ, nextLevel);
        node.children[2] = new QuadTree(this, node.minX, midZ, midX, node.maxZ, nextLevel);
        node.children[3] = new QuadTree(this, midX, midZ, node.maxX, node.maxZ, nextLevel);
    }

    public double getHeight(double x, double z) {
        return this.heightFunction.getHeight(x, z);
    }

    public int[][] generateImage(int width, int height) {
        int[][] image = new int[width][height];
        double scaleX = this.root.maxX / (double)width;
        double scaleZ = this.root.maxZ / (double)height;
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < height; ++z) {
                double worldX = (double)x * scaleX;
                double worldZ = (double)z * scaleZ;
                image[x][z] = (int)this.getInterpolatedHeight(worldX, worldZ);
            }
        }
        return image;
    }

    private double getInterpolatedHeight(double x, double z) {
        return this.getHeightFromNode(this.root, x, z);
    }

    private double getHeightFromNode(QuadTree node, double x, double z) {
        if (node.isLeaf) {
            return this.bilinearInterpolate(node, x, z);
        }
        double midX = (node.minX + node.maxX) / 2.0;
        double midZ = (node.minZ + node.maxZ) / 2.0;
        int childIndex = x < midX ? (z < midZ ? 0 : 2) : (z < midZ ? 1 : 3);
        return this.getHeightFromNode(node.children[childIndex], x, z);
    }

    private double bilinearInterpolate(QuadTree node, double x, double z) {
        int n = this.samplesPerNode;
        double stepX = (node.maxX - node.minX) / (double)(n - 1);
        double stepZ = (node.maxZ - node.minZ) / (double)(n - 1);
        double gridX = (x - node.minX) / stepX;
        double gridZ = (z - node.minZ) / stepZ;
        int x1 = (int)Math.floor(gridX);
        int z1 = (int)Math.floor(gridZ);
        int x2 = Math.min(x1 + 1, n - 1);
        int z2 = Math.min(z1 + 1, n - 1);
        x1 = Math.max(0, x1);
        z1 = Math.max(0, z1);
        double dx = gridX - (double)x1;
        double dz = gridZ - (double)z1;
        double h1 = node.heightSamples[x1][z1];
        double h2 = node.heightSamples[x2][z1];
        double h3 = node.heightSamples[x1][z2];
        double h4 = node.heightSamples[x2][z2];
        double interpolated = h1 * (1.0 - dx) * (1.0 - dz) + h2 * dx * (1.0 - dz) + h3 * (1.0 - dx) * dz + h4 * dx * dz;
        return interpolated;
    }

    public void shutdown() {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.executor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public void printStatistics() {
        Stats stats = new Stats();
        this.collectStats(this.root, stats);
        System.out.println("QTree Statistics Info:");
        System.out.println("Node Count: " + stats.totalNodes);
        System.out.println("Leaf Node Count: " + stats.leafNodes);
        System.out.println("Deep: " + stats.maxDepth);
        System.out.println("Sample Point Count: " + stats.totalSamples);
    }

    private void collectStats(QuadTree node, Stats stats) {
        ++stats.totalNodes;
        stats.maxDepth = Math.max(stats.maxDepth, node.level);
        stats.totalSamples += this.samplesPerNode * this.samplesPerNode;
        if (node.isLeaf) {
            ++stats.leafNodes;
        } else {
            for (QuadTree child : node.children) {
                this.collectStats(child, stats);
            }
        }
    }

    private synchronized void addCount() {
        ++this.count;
    }

    private synchronized void subCount() {
        --this.count;
        if (this.count == 0) {
            this.latch.countDown();
        }
    }

    @FunctionalInterface
    public static interface HeightFunction {
        public double getHeight(double var1, double var3);
    }

    private class QuadTree {
        double minX;
        double minZ;
        double maxX;
        double maxZ;
        int level;
        double minHeight;
        double maxHeight;
        QuadTree[] children;
        boolean isLeaf;
        double[][] heightSamples;

        QuadTree(AdaptiveHeightSampler adaptiveHeightSampler, double minX, double minZ, double maxX, double maxZ, int level) {
            this.minX = minX;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxZ = maxZ;
            this.level = level;
            this.children = null;
            this.isLeaf = true;
        }
    }

    private static class Stats {
        int totalNodes = 0;
        int leafNodes = 0;
        int maxDepth = 0;
        int totalSamples = 0;

        private Stats() {
        }
    }
}

