/*
 * Decompiled with CFR 0.152.
 */
package com.hxzhitang.tongdarailway.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.Direction;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class CurveRoute {
    public static Frame adjustmentFrame(Frame inputFrame) {
        Frame outputFrame = new Frame(inputFrame.position, inputFrame.tangent, inputFrame.normal, inputFrame.binormal);
        outputFrame.position = inputFrame.position;
        Point3D worldUp = new Point3D(0.0, 1.0, 0.0);
        if (outputFrame.normal.dot(worldUp) < 0.0) {
            outputFrame = new Frame(outputFrame.position, outputFrame.tangent, outputFrame.normal.multiply(-1.0), outputFrame.binormal.multiply(-1.0));
        }
        outputFrame.tangent = new Point3D(inputFrame.tangent.x, 0.0, inputFrame.tangent.z).normalize();
        outputFrame.normal = new Point3D(0.0, 1.0, 0.0);
        outputFrame.binormal = outputFrame.tangent.cross(outputFrame.normal);
        return outputFrame;
    }

    private static double calculateRotationAngle(Point3D binormal) {
        double projectionLength = Math.sqrt(binormal.x * binormal.x + binormal.z * binormal.z);
        if (projectionLength < 1.0E-10) {
            return 1.5707963267948966;
        }
        double angle = Math.atan2(binormal.y, projectionLength);
        return -angle;
    }

    private static Point3D rotateAroundAxis(Point3D point, Point3D axis, double angle) {
        double length = Math.sqrt(axis.x * axis.x + axis.y * axis.y + axis.z * axis.z);
        double ux = axis.x / length;
        double uy = axis.y / length;
        double uz = axis.z / length;
        double cosA = Math.cos(angle);
        double sinA = Math.sin(angle);
        double oneMinusCosA = 1.0 - cosA;
        double m00 = cosA + ux * ux * oneMinusCosA;
        double m01 = ux * uy * oneMinusCosA - uz * sinA;
        double m02 = ux * uz * oneMinusCosA + uy * sinA;
        double m10 = uy * ux * oneMinusCosA + uz * sinA;
        double m11 = cosA + uy * uy * oneMinusCosA;
        double m12 = uy * uz * oneMinusCosA - ux * sinA;
        double m20 = uz * ux * oneMinusCosA - uy * sinA;
        double m21 = uz * uy * oneMinusCosA + ux * sinA;
        double m22 = cosA + uz * uz * oneMinusCosA;
        double newX = m00 * point.x + m01 * point.y + m02 * point.z;
        double newY = m10 * point.x + m11 * point.y + m12 * point.z;
        double newZ = m20 * point.x + m21 * point.y + m22 * point.z;
        return new Point3D(newX, newY, newZ);
    }

    public static class Frame {
        public Point3D position;
        public Point3D tangent;
        public Point3D normal;
        public Point3D binormal;

        public Frame(Point3D position, Point3D tangent, Point3D normal, Point3D binormal) {
            this.position = position;
            this.tangent = tangent.normalize();
            this.normal = normal.normalize();
            this.binormal = binormal.normalize();
        }

        public Frame rotateToNewTangent(Point3D newTangent, Point3D newPosition) {
            Point3D oldT = this.tangent;
            Point3D newT = newTangent.normalize();
            Point3D rotationAxis = oldT.cross(newT);
            double axisLength = rotationAxis.length();
            if (axisLength < 1.0E-10) {
                return new Frame(newPosition, newT, this.normal, this.binormal);
            }
            rotationAxis = rotationAxis.normalize();
            double cosAngle = oldT.dot(newT);
            double angle = Math.acos(Math.max(-1.0, Math.min(1.0, cosAngle)));
            Point3D rotatedNormal = this.rotateVector(this.normal, rotationAxis, angle);
            Point3D rotatedBinormal = this.rotateVector(this.binormal, rotationAxis, angle);
            return new Frame(newPosition, newT, rotatedNormal, rotatedBinormal);
        }

        private Point3D rotateVector(Point3D vector, Point3D axis, double angle) {
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            Point3D term1 = vector.multiply(cos);
            Point3D term2 = axis.cross(vector).multiply(sin);
            Point3D term3 = axis.multiply(axis.dot(vector) * (1.0 - cos));
            return term1.add(term2).add(term3).normalize();
        }

        public String toString() {
            return String.format("pos: %s, tangent: %s, normal: %s, binormal: %s", this.position, this.tangent, this.normal, this.binormal);
        }
    }

    public static class Point3D {
        public double x;
        public double y;
        public double z;

        public Point3D(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Point3D(Vec3 p) {
            this.x = p.x;
            this.y = p.y;
            this.z = p.z;
        }

        public Point3D subtract(Point3D other) {
            return new Point3D(this.x - other.x, this.y - other.y, this.z - other.z);
        }

        public Point3D add(Point3D other) {
            return new Point3D(this.x + other.x, this.y + other.y, this.z + other.z);
        }

        public Point3D multiply(double scalar) {
            return new Point3D(this.x * scalar, this.y * scalar, this.z * scalar);
        }

        public double dot(Point3D other) {
            return this.x * other.x + this.y * other.y + this.z * other.z;
        }

        public Point3D div(double n) {
            return new Point3D(this.x / n, this.y / n, this.z / n);
        }

        public Point3D cross(Point3D other) {
            return new Point3D(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
        }

        public double length() {
            return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        }

        public Point3D normalize() {
            double len = this.length();
            if (len == 0.0) {
                return new Point3D(0.0, 0.0, 0.0);
            }
            return new Point3D(this.x / len, this.y / len, this.z / len);
        }

        public double distanceTo(Point3D other) {
            double dx = this.x - other.x;
            double dy = this.y - other.y;
            double dz = this.z - other.z;
            return Math.sqrt(dx * dx + dy * dy + dz * dz);
        }

        public String toString() {
            return String.format("(%.3f, %.3f, %.3f)", this.x, this.y, this.z);
        }

        public ListTag toNBT() {
            ListTag list = new ListTag();
            list.add((Object)DoubleTag.valueOf((double)this.x));
            list.add((Object)DoubleTag.valueOf((double)this.y));
            list.add((Object)DoubleTag.valueOf((double)this.z));
            return list;
        }

        public static Point3D fromNBT(ListTag list) {
            return new Point3D(list.getDouble(0), list.getDouble(1), list.getDouble(2));
        }
    }

    public static class CompositeCurve {
        private List<CurveSegment> segments = new ArrayList<CurveSegment>();
        private List<Double> segmentLengths = new ArrayList<Double>();
        private double totalLength = 0.0;
        private List<Frame> parallelFrames;
        private boolean framesComputed = false;
        private static final int SAMPLE_COUNT = 100;

        public double getTotalLength() {
            return this.totalLength;
        }

        public void addSegment(CurveSegment segment) {
            this.segments.add(segment);
            double length = segment.getLength();
            this.segmentLengths.add(length);
            this.totalLength += length;
            this.framesComputed = false;
        }

        public List<CurveSegment> getSegments() {
            return this.segments;
        }

        public CurveSegment getSegmentAtParameter(double t) {
            t = Math.max(0.0, Math.min(1.0, t));
            double targetLength = t * this.totalLength;
            double accumulated = 0.0;
            for (int i = 0; i < this.segments.size(); ++i) {
                double segmentLength = this.segmentLengths.get(i);
                if (accumulated + segmentLength >= targetLength) {
                    return this.segments.get(i);
                }
                accumulated += segmentLength;
            }
            return this.segments.get(this.segments.size() - 1);
        }

        public double getSegmentParameter(double t) {
            t = Math.max(0.0, Math.min(1.0, t));
            double targetLength = t * this.totalLength;
            double accumulated = 0.0;
            for (int i = 0; i < this.segments.size(); ++i) {
                double segmentLength = this.segmentLengths.get(i);
                if (accumulated + segmentLength >= targetLength) {
                    double segmentT = (targetLength - accumulated) / segmentLength;
                    return Math.max(0.0, Math.min(1.0, segmentT));
                }
                accumulated += segmentLength;
            }
            return 1.0;
        }

        private void ensureFramesComputed() {
            if (!this.framesComputed || this.parallelFrames == null) {
                this.parallelFrames = ParallelTransportFrameCalculator.computeParallelTransportFrames(this, 100);
                this.framesComputed = true;
            }
        }

        public NearestPointResult findNearestPoint(Point3D point) {
            if (this.segments.isEmpty()) {
                throw new IllegalStateException("\u66f2\u7ebf\u6ca1\u6709\u5b9a\u4e49\u4efb\u4f55\u6bb5");
            }
            this.ensureFramesComputed();
            NearestPointResult bestResult = null;
            for (int i = 0; i < this.segments.size(); ++i) {
                CurveSegment segment = this.segments.get(i);
                NearestPointResult segmentResult = this.findNearestOnSegment(segment, point, i);
                if (bestResult != null && !(segmentResult.distance < bestResult.distance)) continue;
                bestResult = segmentResult;
            }
            return bestResult;
        }

        private NearestPointResult findNearestOnSegment(CurveSegment segment, Point3D point, int segmentIndex) {
            int iterations = 20;
            double low = 0.0;
            double high = 1.0;
            for (int i = 0; i < iterations; ++i) {
                double d2;
                double t1 = low + (high - low) / 3.0;
                double t2 = high - (high - low) / 3.0;
                Point3D p1 = segment.evaluate(t1);
                Point3D p2 = segment.evaluate(t2);
                double d1 = p1.distanceTo(point);
                if (d1 < (d2 = p2.distanceTo(point))) {
                    high = t2;
                    continue;
                }
                low = t1;
            }
            double bestT = (low + high) / 2.0;
            Point3D nearestPoint = segment.evaluate(bestT);
            double distance = nearestPoint.distanceTo(point);
            Frame frame = ParallelTransportFrameCalculator.getFrameAtParameter(this.parallelFrames, this.getGlobalParameter(segmentIndex, bestT), 100);
            return new NearestPointResult(nearestPoint, bestT, distance, frame, segmentIndex);
        }

        public double getGlobalParameter(int segmentIndex, double segmentT) {
            double accumulated = 0.0;
            for (int i = 0; i < segmentIndex; ++i) {
                accumulated += this.segmentLengths.get(i).doubleValue();
            }
            return (accumulated += this.segmentLengths.get(segmentIndex) * segmentT) / this.totalLength;
        }

        public ListTag toNBT() {
            ListTag curveTag = new ListTag();
            for (CurveSegment segment : this.segments) {
                ListTag parameters = new ListTag();
                if (segment instanceof LineSegment) {
                    LineSegment line = (LineSegment)segment;
                    parameters.add((Object)line.start.toNBT());
                    parameters.add((Object)line.end.toNBT());
                } else if (segment instanceof CubicBezier) {
                    CubicBezier bezier = (CubicBezier)segment;
                    parameters.add((Object)bezier.p0.toNBT());
                    parameters.add((Object)bezier.p1.toNBT());
                    parameters.add((Object)bezier.p2.toNBT());
                    parameters.add((Object)bezier.p3.toNBT());
                }
                curveTag.add((Object)parameters);
            }
            return curveTag;
        }

        public static CompositeCurve fromNBT(ListTag curveTag) {
            CompositeCurve curve = new CompositeCurve();
            for (int i = 0; i < curveTag.size(); ++i) {
                ListTag parameters = curveTag.getList(i);
                if (parameters.size() == 2) {
                    Point3D start = Point3D.fromNBT((ListTag)parameters.get(0));
                    Point3D end = Point3D.fromNBT((ListTag)parameters.get(1));
                    curve.addSegment(new LineSegment(start, end));
                    continue;
                }
                if (parameters.size() != 4) continue;
                Point3D p0 = Point3D.fromNBT((ListTag)parameters.get(0));
                Point3D p1 = Point3D.fromNBT((ListTag)parameters.get(1));
                Point3D p2 = Point3D.fromNBT((ListTag)parameters.get(2));
                Point3D p3 = Point3D.fromNBT((ListTag)parameters.get(3));
                curve.addSegment(new CubicBezier(p0, p1, p2, p3));
            }
            return curve;
        }
    }

    public static class ParallelTransportFrameCalculator {
        public static List<Frame> computeParallelTransportFrames(CompositeCurve curve, int sampleCount) {
            ArrayList<Frame> frames = new ArrayList<Frame>();
            if (curve.getSegments().isEmpty()) {
                return frames;
            }
            ArrayList<Point3D> samples = new ArrayList<Point3D>();
            ArrayList<Point3D> tangents = new ArrayList<Point3D>();
            for (int i = 0; i < sampleCount; ++i) {
                double t = (double)i / (double)(sampleCount - 1);
                CurveSegment segment = curve.getSegmentAtParameter(t);
                double segmentT = curve.getSegmentParameter(t);
                Point3D point = segment.evaluate(segmentT);
                Point3D tangent = segment.derivative(segmentT);
                samples.add(point);
                tangents.add(tangent);
            }
            Frame initialFrame = ParallelTransportFrameCalculator.computeInitialFrame((Point3D)samples.get(0), (Point3D)tangents.get(0));
            frames.add(initialFrame);
            for (int i = 1; i < samples.size(); ++i) {
                Frame prevFrame = (Frame)frames.get(i - 1);
                Point3D currentPoint = (Point3D)samples.get(i);
                Point3D currentTangent = (Point3D)tangents.get(i);
                Frame newFrame = prevFrame.rotateToNewTangent(currentTangent, currentPoint);
                frames.add(newFrame);
            }
            return frames;
        }

        public static Frame getFrameAtParameter(List<Frame> frames, double t, int sampleCount) {
            if (frames.isEmpty()) {
                return null;
            }
            double index = t * (double)(sampleCount - 1);
            int idx1 = (int)Math.floor(index);
            int idx2 = (int)Math.ceil(index);
            if (idx1 < 0) {
                idx1 = 0;
            }
            if (idx2 >= frames.size()) {
                idx2 = frames.size() - 1;
            }
            if (idx1 == idx2) {
                return frames.get(idx1);
            }
            double blend = index - (double)idx1;
            return ParallelTransportFrameCalculator.interpolateFrames(frames.get(idx1), frames.get(idx2), blend);
        }

        private static Frame interpolateFrames(Frame frame1, Frame frame2, double blend) {
            Point3D pos = ParallelTransportFrameCalculator.interpolatePoints(frame1.position, frame2.position, blend);
            Point3D tangent = ParallelTransportFrameCalculator.interpolatePoints(frame1.tangent, frame2.tangent, blend).normalize();
            Point3D normal = ParallelTransportFrameCalculator.slerp(frame1.normal, frame2.normal, blend);
            Point3D binormal = tangent.cross(normal).normalize();
            normal = binormal.cross(tangent).normalize();
            return new Frame(pos, tangent, normal, binormal);
        }

        private static Point3D interpolatePoints(Point3D p1, Point3D p2, double blend) {
            return new Point3D(p1.x + blend * (p2.x - p1.x), p1.y + blend * (p2.y - p1.y), p1.z + blend * (p2.z - p1.z));
        }

        private static Point3D slerp(Point3D v1, Point3D v2, double blend) {
            double dot = Math.max(-1.0, Math.min(1.0, v1.dot(v2)));
            double angle = Math.acos(dot);
            if (angle < 1.0E-10) {
                return ParallelTransportFrameCalculator.interpolatePoints(v1, v2, blend).normalize();
            }
            double sinAngle = Math.sin(angle);
            double w1 = Math.sin((1.0 - blend) * angle) / sinAngle;
            double w2 = Math.sin(blend * angle) / sinAngle;
            return new Point3D(w1 * v1.x + w2 * v2.x, w1 * v1.y + w2 * v2.y, w1 * v1.z + w2 * v2.z).normalize();
        }

        private static Frame computeInitialFrame(Point3D point, Point3D tangent) {
            Point3D t = tangent.normalize();
            Point3D n = Math.abs(t.x) > 0.1 || Math.abs(t.y) > 0.1 ? new Point3D(0.0, 0.0, 1.0).cross(t).normalize() : new Point3D(1.0, 0.0, 0.0).cross(t).normalize();
            Point3D b = t.cross(n).normalize();
            n = b.cross(t).normalize();
            return new Frame(point, t, n, b);
        }
    }

    public static class NearestPointResult {
        public Point3D nearestPoint;
        public double parameter;
        public double distance;
        public Frame frame;
        public int segmentIndex;

        public NearestPointResult(Point3D nearestPoint, double parameter, double distance, Frame frame, int segmentIndex) {
            this.nearestPoint = nearestPoint;
            this.parameter = parameter;
            this.distance = distance;
            this.frame = frame;
            this.segmentIndex = segmentIndex;
        }
    }

    public static class CubicBezier
    implements CurveSegment {
        private Point3D p0;
        private Point3D p1;
        private Point3D p2;
        private Point3D p3;

        public CubicBezier(Point3D p0, Point3D p1, Point3D p2, Point3D p3) {
            this.p0 = p0;
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
        }

        public static CubicBezier getCubicBezier(Vec3 startPos, Vec3 startAxis, Vec3 endOffset, Vec3 endAxis) {
            Vec3 endPos = startPos.add(endOffset);
            Vec3 axis1 = startAxis.normalize();
            Vec3 axis2 = endAxis.normalize();
            double handleLength = CubicBezier.determineHandleLength(startPos, endPos, axis1, axis2);
            Vec3 p0 = startPos;
            Vec3 p1 = startPos.add(axis1.scale(handleLength));
            Vec3 p2 = endPos.add(axis2.scale(handleLength));
            Vec3 p3 = endPos;
            return new CubicBezier(new Point3D(p0), new Point3D(p1), new Point3D(p2), new Point3D(p3));
        }

        private static double determineHandleLength(Vec3 end1, Vec3 end2, Vec3 axis1, Vec3 axis2) {
            Vec3 cross1 = axis1.cross(new Vec3(0.0, 1.0, 0.0));
            Vec3 cross2 = axis2.cross(new Vec3(0.0, 1.0, 0.0));
            double a1 = Mth.atan2((double)(-axis2.z), (double)(-axis2.x));
            double a2 = Mth.atan2((double)axis1.z, (double)axis1.x);
            double angle = a1 - a2;
            float circle = (float)Math.PI * 2;
            if (Math.abs((double)circle - (angle = (angle + (double)circle) % (double)circle)) < Math.abs(angle)) {
                angle = (double)circle - angle;
            }
            if (Mth.equal((double)angle, (double)0.0)) {
                double[] intersect = VecHelper.intersect((Vec3)end1, (Vec3)end2, (Vec3)axis1, (Vec3)cross2, (Direction.Axis)Direction.Axis.Y);
                if (intersect != null) {
                    double t = Math.abs(intersect[0]);
                    double u = Math.abs(intersect[1]);
                    double min = Math.min(t, u);
                    double max = Math.max(t, u);
                    if (min > 1.2 && max / min > 1.0 && max / min < 3.0) {
                        return max - min;
                    }
                }
                return end2.distanceTo(end1) / 3.0;
            }
            double n = (double)circle / angle;
            double factor = 1.3333333333333333 * Math.tan(Math.PI / (2.0 * n));
            double[] intersect = VecHelper.intersect((Vec3)end1, (Vec3)end2, (Vec3)cross1, (Vec3)cross2, (Direction.Axis)Direction.Axis.Y);
            if (intersect == null) {
                return end2.distanceTo(end1) / 3.0;
            }
            double radius = Math.abs(intersect[1]);
            double handleLength = radius * factor;
            if (Mth.equal((double)handleLength, (double)0.0)) {
                handleLength = 1.0;
            }
            return handleLength;
        }

        @Override
        public Point3D evaluate(double t) {
            t = Math.max(0.0, Math.min(1.0, t));
            double u = 1.0 - t;
            double u2 = u * u;
            double u3 = u2 * u;
            double t2 = t * t;
            double t3 = t2 * t;
            Point3D result = this.p0.multiply(u3).add(this.p1.multiply(3.0 * u2 * t)).add(this.p2.multiply(3.0 * u * t2)).add(this.p3.multiply(t3));
            return result;
        }

        @Override
        public Point3D derivative(double t) {
            t = Math.max(0.0, Math.min(1.0, t));
            double u = 1.0 - t;
            Point3D term1 = this.p1.subtract(this.p0).multiply(3.0 * u * u);
            Point3D term2 = this.p2.subtract(this.p1).multiply(6.0 * u * t);
            Point3D term3 = this.p3.subtract(this.p2).multiply(3.0 * t * t);
            return term1.add(term2).add(term3).normalize();
        }

        @Override
        public double getLength() {
            int steps = 100;
            double length = 0.0;
            Point3D prev = this.evaluate(0.0);
            for (int i = 1; i <= steps; ++i) {
                Point3D current = this.evaluate((double)i / (double)steps);
                length += prev.distanceTo(current);
                prev = current;
            }
            return length;
        }

        @Override
        public List<Point3D> rasterize(int n) {
            HashSet<Point3D> rasterPoints = new HashSet<Point3D>();
            this.recursiveRasterize(this.p0.div(n), this.p1.div(n), this.p2.div(n), this.p3.div(n), rasterPoints, 0);
            return new ArrayList<Point3D>(rasterPoints);
        }

        private void recursiveRasterize(Point3D p0, Point3D p1, Point3D p2, Point3D p3, Set<Point3D> rasterPoints, int depth) {
            int MAX_DEPTH = 8;
            int x0 = (int)Math.round(p0.x);
            int z0 = (int)Math.round(p0.z);
            int x1 = (int)Math.round(p1.x);
            int z1 = (int)Math.round(p1.z);
            int x2 = (int)Math.round(p2.x);
            int z2 = (int)Math.round(p2.z);
            int x3 = (int)Math.round(p3.x);
            int z3 = (int)Math.round(p3.z);
            if (x0 == x1 && x1 == x2 && x2 == x3 && z0 == z1 && z1 == z2 && z2 == z3 || depth >= 8) {
                rasterPoints.add(new Point3D(x0, 0.0, z0));
                rasterPoints.add(new Point3D(x3, 0.0, z3));
                return;
            }
            Point3D[] subdivided = this.subdivideBezier(p0, p1, p2, p3, 0.5);
            Point3D leftP0 = subdivided[0];
            Point3D leftP1 = subdivided[1];
            Point3D leftP2 = subdivided[2];
            Point3D leftP3 = subdivided[3];
            Point3D rightP0 = subdivided[3];
            Point3D rightP1 = subdivided[4];
            Point3D rightP2 = subdivided[5];
            Point3D rightP3 = subdivided[6];
            this.recursiveRasterize(leftP0, leftP1, leftP2, leftP3, rasterPoints, depth + 1);
            this.recursiveRasterize(rightP0, rightP1, rightP2, rightP3, rasterPoints, depth + 1);
        }

        private Point3D[] subdivideBezier(Point3D p0, Point3D p1, Point3D p2, Point3D p3, double t) {
            Point3D p01 = this.interpolate(p0, p1, t);
            Point3D p12 = this.interpolate(p1, p2, t);
            Point3D p23 = this.interpolate(p2, p3, t);
            Point3D p012 = this.interpolate(p01, p12, t);
            Point3D p123 = this.interpolate(p12, p23, t);
            Point3D p0123 = this.interpolate(p012, p123, t);
            return new Point3D[]{p0, p01, p012, p0123, p123, p23, p3};
        }

        private Point3D interpolate(Point3D a, Point3D b, double t) {
            return new Point3D(a.x + t * (b.x - a.x), a.y + t * (b.y - a.y), a.z + t * (b.z - a.z));
        }
    }

    public static class LineSegment
    implements CurveSegment {
        private Point3D start;
        private Point3D end;

        public LineSegment(Point3D start, Point3D end) {
            this.start = start;
            this.end = end;
        }

        public LineSegment(Vec3 start, Vec3 end) {
            this.start = new Point3D(start);
            this.end = new Point3D(end);
        }

        @Override
        public Point3D evaluate(double t) {
            t = Math.max(0.0, Math.min(1.0, t));
            return new Point3D(this.start.x + t * (this.end.x - this.start.x), this.start.y + t * (this.end.y - this.start.y), this.start.z + t * (this.end.z - this.start.z));
        }

        @Override
        public Point3D derivative(double t) {
            return this.end.subtract(this.start).normalize();
        }

        @Override
        public double getLength() {
            return this.start.distanceTo(this.end);
        }

        @Override
        public List<Point3D> rasterize(int n) {
            ArrayList<Point3D> rasterPoints = new ArrayList<Point3D>();
            int x0 = (int)Math.round(this.start.x / (double)n);
            int z0 = (int)Math.round(this.start.z / (double)n);
            int x1 = (int)Math.round(this.end.x / (double)n);
            int z1 = (int)Math.round(this.end.z / (double)n);
            int dx = Math.abs(x1 - x0);
            int dz = Math.abs(z1 - z0);
            int sx = x0 < x1 ? 1 : -1;
            int sz = z0 < z1 ? 1 : -1;
            int err = dx - dz;
            int x = x0;
            int z = z0;
            while (true) {
                rasterPoints.add(new Point3D(x, 0.0, z));
                if (x == x1 && z == z1) break;
                int e2 = 2 * err;
                if (e2 > -dz) {
                    err -= dz;
                    x += sx;
                }
                if (e2 >= dx) continue;
                err += dx;
                z += sz;
            }
            return rasterPoints;
        }
    }

    public static interface CurveSegment {
        public Point3D evaluate(double var1);

        public Point3D derivative(double var1);

        public double getLength();

        public List<Point3D> rasterize(int var1);
    }
}

