/*
 * Decompiled with CFR 0.152.
 */
package com.hxzhitang.tongdarailway.util;

import com.hxzhitang.tongdarailway.railway.RailwayMap;
import com.hxzhitang.tongdarailway.railway.RegionPos;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class ModSaveData
extends SavedData {
    public static final String NAME = "tongdarailway_mod_railway_data";
    public final Map<RegionPos, RailwayMap> regionRailways = new ConcurrentHashMap<RegionPos, RailwayMap>();

    public void putRailwayMap(RegionPos regionPos, RailwayMap railwayMap) {
        this.regionRailways.put(regionPos, railwayMap);
        this.setDirty();
    }

    public RailwayMap getRailwayMap(RegionPos regionPos) {
        this.setDirty();
        return this.regionRailways.get(regionPos);
    }

    public static ModSaveData create() {
        return new ModSaveData();
    }

    public CompoundTag save(CompoundTag pCompoundTag, HolderLookup.Provider provider) {
        ListTag listTag = new ListTag();
        this.regionRailways.forEach((pos, railwayMap) -> {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.put("RegionPos", (Tag)pos.toNBT());
            compoundTag.put("RailwayMap", (Tag)railwayMap.toNBT());
            listTag.add((Object)compoundTag);
        });
        pCompoundTag.put("RailwayData", (Tag)listTag);
        return pCompoundTag;
    }

    public static ModSaveData load(CompoundTag nbt, HolderLookup.Provider provider) {
        ModSaveData data = ModSaveData.create();
        ListTag listNBT = (ListTag)nbt.get("RailwayData");
        if (listNBT != null) {
            for (Tag value : listNBT) {
                CompoundTag tag = (CompoundTag)value;
                RegionPos regionPos = RegionPos.fromNBT((ListTag)tag.get("RegionPos"));
                CompoundTag dataTag = (CompoundTag)tag.get("RailwayMap");
                if (dataTag == null) continue;
                RailwayMap railwayMap = RailwayMap.fromNBT(dataTag);
                data.regionRailways.put(regionPos, railwayMap);
            }
        }
        return data;
    }

    public static ModSaveData get(Level worldIn) {
        if (!(worldIn instanceof ServerLevel)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        ServerLevel world = worldIn.getServer().getLevel(ServerLevel.OVERWORLD);
        DimensionDataStorage dataStorage = world.getDataStorage();
        return (ModSaveData)dataStorage.computeIfAbsent(new SavedData.Factory(ModSaveData::create, ModSaveData::load, DataFixTypes.LEVEL), NAME);
    }
}

