/*
 * Decompiled with CFR 0.152.
 */
package com.hxzhitang.tongdarailway.worldgen;

import com.hxzhitang.tongdarailway.Config;
import com.hxzhitang.tongdarailway.blocks.ModBlocks;
import com.hxzhitang.tongdarailway.blocks.TrackSpawnerBlockEntity;
import com.hxzhitang.tongdarailway.railway.RailwayBuilder;
import com.hxzhitang.tongdarailway.railway.RailwayMap;
import com.hxzhitang.tongdarailway.railway.RegionPos;
import com.hxzhitang.tongdarailway.railway.planner.StationPlanner;
import com.hxzhitang.tongdarailway.structure.RailwayTemplate;
import com.hxzhitang.tongdarailway.structure.RoadbedManager;
import com.hxzhitang.tongdarailway.structure.StationStructure;
import com.hxzhitang.tongdarailway.structure.TrackPutInfo;
import com.hxzhitang.tongdarailway.util.CurveRoute;
import com.hxzhitang.tongdarailway.util.MyMth;
import com.hxzhitang.tongdarailway.worldgen.RailwayFeatureConfig;
import com.mojang.serialization.Codec;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.jetbrains.annotations.NotNull;

public class RailwayFeature
extends Feature<RailwayFeatureConfig> {
    public RailwayFeature(Codec<RailwayFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(@NotNull FeaturePlaceContext<RailwayFeatureConfig> ctx) {
        TrackPutInfo firstInfo;
        BlockPos checkPos;
        ChunkPos cPos = new ChunkPos(ctx.origin());
        RegionPos regionPos = MyMth.regionPosFromChunkPos(cPos);
        WorldGenLevel world = ctx.level();
        ChunkAccess chunk = world.getChunk(cPos.x, cPos.z);
        RailwayBuilder builder = RailwayBuilder.getInstance(ctx.level().getSeed());
        if (builder == null) {
            return false;
        }
        RailwayMap railwayMap = builder.regionRailways.get(regionPos);
        if (railwayMap == null) {
            return false;
        }
        if (builder.regionRailways.containsKey(regionPos) && railwayMap.routeMap.containsKey(cPos)) {
            RailwayFeature.placeRoadbed(railwayMap, cPos, chunk, world);
        }
        for (StationPlanner.StationGenInfo stationPlace : railwayMap.stations) {
            StationStructure station = stationPlace.stationStructure();
            if (station == null) continue;
            BlockPos pos = stationPlace.placePos();
            station.putSegment(world, cPos, pos);
        }
        if (Config.generateTrackSpawner && builder.regionRailways.containsKey(regionPos) && railwayMap.trackMap.containsKey(cPos) && !world.getBlockState(checkPos = (firstInfo = railwayMap.trackMap.get(cPos).getFirst()).pos().offset(0, -1, 0)).equals(((Block)ModBlocks.TRACK_SPAWNER.get()).defaultBlockState())) {
            world.setBlock(checkPos, ((Block)ModBlocks.TRACK_SPAWNER.get()).defaultBlockState(), 3);
            BlockEntity blockEntity = world.getBlockEntity(checkPos);
            if (blockEntity instanceof TrackSpawnerBlockEntity) {
                TrackSpawnerBlockEntity trackSpawner = (TrackSpawnerBlockEntity)blockEntity;
                trackSpawner.addTrackPutInfo(railwayMap.trackMap.get(cPos));
            }
        }
        return true;
    }

    private static void placeRoadbed(RailwayMap railwayMap, ChunkPos cPos, ChunkAccess chunk, WorldGenLevel world) {
        Set<CurveRoute.CompositeCurve> routes = railwayMap.routeMap.get(cPos);
        for (CurveRoute.CompositeCurve route : routes) {
            int seed = route.getSegments().size();
            RailwayTemplate ground = RoadbedManager.getRandomGround(seed);
            RailwayTemplate bridge = RoadbedManager.getRandomBridge(seed);
            RailwayTemplate tunnel = RoadbedManager.getRandomTunnel(seed);
            CurveRoute.Point3D testPoint = new CurveRoute.Point3D(cPos.x * 16 + 8, 80.0, cPos.z * 16 + 8);
            CurveRoute.NearestPointResult result0 = route.findNearestPoint(testPoint);
            CurveRoute.Point3D nearestPoint0 = result0.nearestPoint;
            CurveRoute.Frame frame0 = result0.frame;
            CurveRoute.Point3D normal0 = frame0.normal;
            double x0 = nearestPoint0.x;
            double y0 = nearestPoint0.y;
            double z0 = nearestPoint0.z;
            double A = normal0.x;
            double B = normal0.y + 1.0E-5;
            double C = normal0.z;
            double D = -(A * x0 + B * y0 + C * z0);
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    boolean conditionTunnel;
                    int wx = cPos.x * 16 + x;
                    int wz = cPos.z * 16 + z;
                    double y = -(A / B) * (double)wx - C / B * (double)wz - D / B;
                    CurveRoute.Point3D worldPoint = new CurveRoute.Point3D(wx, y, wz);
                    CurveRoute.NearestPointResult result = route.findNearestPoint(worldPoint);
                    CurveRoute.Point3D nearest = result.nearestPoint;
                    CurveRoute.Frame frame = CurveRoute.adjustmentFrame(result.frame);
                    double t = route.getGlobalParameter(result.segmentIndex, result.parameter);
                    BlockPos nearestPos = new BlockPos((int)nearest.x, (int)nearest.y, (int)nearest.z);
                    int h = world.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, nearestPos.getX(), nearestPos.getZ());
                    boolean conditionBridge = nearest.y > (double)(h + 10);
                    boolean bl = conditionTunnel = nearest.y < (double)(h - 9);
                    RailwayTemplate structureTemplate = conditionBridge ? bridge : (conditionTunnel ? tunnel : ground);
                    for (int oy = structureTemplate.getLowerBound(); oy <= structureTemplate.getUpperBound(); ++oy) {
                        double localZ;
                        double localY;
                        double localX;
                        BlockState blockState;
                        double y1 = y + (double)oy;
                        CurveRoute.Point3D worldPoint1 = new CurveRoute.Point3D(wx, y1, wz);
                        CurveRoute.Point3D vec = worldPoint1.subtract(nearest);
                        if (Math.abs(vec.dot(frame.tangent)) > 3.0 || (blockState = structureTemplate.getBlockState(localX = t * route.getTotalLength(), localY = vec.dot(frame.normal), localZ = vec.dot(frame.binormal))) == null) continue;
                        BlockPos blockPos = new BlockPos(x, (int)Math.round(y1), z);
                        chunk.setBlockState(blockPos, blockState, true);
                    }
                }
            }
        }
    }
}

