/*
 * Decompiled with CFR 0.152.
 */
package me.zipestudio.tomb.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.zipestudio.tomb.config.ToolEntry;
import me.zipestudio.tomb.utils.CodecUtils;
import me.zipestudio.tomb.utils.ConfigUtils;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeafyConfig {
    public static final Codec<ToolEntry> TOOL_ENTRY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("itemId").forGetter(ToolEntry::getItemId), (App)Codec.STRING.fieldOf("group").forGetter(ToolEntry::getGroup), (App)Codec.BOOL.fieldOf("is3DModel").forGetter(ToolEntry::is3DModel), (App)Codec.FLOAT.fieldOf("scale").orElse((Object)Float.valueOf(1.0f)).forGetter(ToolEntry::getScale), (App)Codec.FLOAT.fieldOf("angle").forGetter(ToolEntry::getAngle), (App)Codec.FLOAT.fieldOf("offsetX").orElse((Object)Float.valueOf(0.0f)).forGetter(ToolEntry::getOffsetX), (App)Codec.FLOAT.fieldOf("offsetY").orElse((Object)Float.valueOf(0.0f)).forGetter(ToolEntry::getOffsetY), (App)Codec.FLOAT.fieldOf("offsetZ").orElse((Object)Float.valueOf(0.0f)).forGetter(ToolEntry::getOffsetZ)).apply((Applicative)instance, ToolEntry::new));
    public static final Codec<LeafyConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group(CodecUtils.option("enableMod", true, Codec.BOOL, LeafyConfig::isEnableMod), CodecUtils.option("renderWithCape", true, Codec.BOOL, LeafyConfig::isRenderWithCape), CodecUtils.option("renderWithElytra", true, Codec.BOOL, LeafyConfig::isRenderWithElytra), (App)Codec.list(TOOL_ENTRY_CODEC).fieldOf("tools").orElse(new ArrayList()).forGetter(LeafyConfig::getTools)).apply((Applicative)instance, LeafyConfig::new));
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Tools On My Back/Config");
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("tools-on-my-back.json5").toFile();
    private static LeafyConfig INSTANCE;
    private boolean enableMod;
    private boolean renderWithCape;
    private boolean renderWithElytra;
    private List<ToolEntry> tools;

    private LeafyConfig() {
        throw new IllegalArgumentException();
    }

    public static LeafyConfig getInstance() {
        return INSTANCE == null ? LeafyConfig.reload() : INSTANCE;
    }

    public static LeafyConfig reload() {
        INSTANCE = LeafyConfig.read();
        return INSTANCE;
    }

    public static LeafyConfig getNewInstance() {
        return CodecUtils.parseNewInstanceHacky(CODEC);
    }

    private static LeafyConfig read() {
        return ConfigUtils.readConfig(CODEC, CONFIG_FILE, LOGGER);
    }

    public void saveAsync() {
        CompletableFuture.runAsync(this::save);
    }

    public void save() {
        ConfigUtils.saveConfig(this, CODEC, CONFIG_FILE, LOGGER);
    }

    public boolean isEnableMod() {
        return this.enableMod;
    }

    public boolean isRenderWithCape() {
        return this.renderWithCape;
    }

    public boolean isRenderWithElytra() {
        return this.renderWithElytra;
    }

    public List<ToolEntry> getTools() {
        return this.tools;
    }

    public void setEnableMod(boolean enableMod) {
        this.enableMod = enableMod;
    }

    public void setRenderWithCape(boolean renderWithCape) {
        this.renderWithCape = renderWithCape;
    }

    public void setRenderWithElytra(boolean renderWithElytra) {
        this.renderWithElytra = renderWithElytra;
    }

    public void setTools(List<ToolEntry> tools) {
        this.tools = tools;
    }

    public LeafyConfig(boolean enableMod, boolean renderWithCape, boolean renderWithElytra, List<ToolEntry> tools) {
        this.enableMod = enableMod;
        this.renderWithCape = renderWithCape;
        this.renderWithElytra = renderWithElytra;
        this.tools = tools;
    }
}

