/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.polarsexplorationadditions.block;

import net.mcreator.polarsexplorationadditions.init.PolarsExplorationAdditionsModBlocks;
import net.mcreator.polarsexplorationadditions.procedures.OakBushBlockValidPlacementConditionProcedure;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

public class OakBushBlock
extends Block {
    public OakBushBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.GRASS).instabreak().noOcclusion().isRedstoneConductor((bs, br, bp) -> false).instrument(NoteBlockInstrument.BASEDRUM));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return OakBushBlock.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        if (worldIn instanceof LevelAccessor) {
            LevelAccessor world = (LevelAccessor)worldIn;
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return OakBushBlockValidPlacementConditionProcedure.execute(world, x, y, z);
        }
        return super.canSurvive(blockstate, worldIn, pos);
    }

    public BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess scheduledTickAccess, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        return !state.canSurvive(world, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, world, scheduledTickAccess, currentPos, facing, facingPos, facingState, random);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void blockColorLoad(RegisterColorHandlersEvent.Block event) {
        event.register((bs, world, pos, index) -> world != null && pos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)world, (BlockPos)pos) : -12012264, new Block[]{(Block)PolarsExplorationAdditionsModBlocks.OAK_BUSH.get()});
    }
}

