/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.polarsexplorationadditions.fluid;

import net.mcreator.polarsexplorationadditions.init.PolarsExplorationAdditionsModBlocks;
import net.mcreator.polarsexplorationadditions.init.PolarsExplorationAdditionsModFluidTypes;
import net.mcreator.polarsexplorationadditions.init.PolarsExplorationAdditionsModFluids;
import net.mcreator.polarsexplorationadditions.init.PolarsExplorationAdditionsModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class HoneyFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)PolarsExplorationAdditionsModFluidTypes.HONEY_TYPE.get(), () -> (Fluid)PolarsExplorationAdditionsModFluids.HONEY.get(), () -> (Fluid)PolarsExplorationAdditionsModFluids.FLOWING_HONEY.get()).explosionResistance(100.0f).tickRate(40).levelDecreasePerBlock(2).slopeFindDistance(3).bucket(() -> (Item)PolarsExplorationAdditionsModItems.HONEY_BUCKET.get()).block(() -> (LiquidBlock)PolarsExplorationAdditionsModBlocks.HONEY.get());

    private HoneyFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.DRIPPING_HONEY;
    }

    public static class Flowing
    extends HoneyFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends HoneyFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

